/*
     This file is part of GNUnet.
     (C) 2005, 2006, 2007 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/helper.c
 * @brief helper functions (parsing)
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "helper.h"
#include "fs.h"
#include "search.h"
#include <ctype.h>

/**
 * Parse a time given in the form
 * "XX seconds yy days zz months".
 *
 * @param val set to the computed time
 * @return GNUNET_OK on success, GNUNET_SYSERR on error
 */
int
parseTime (const char *t, GNUNET_Int32Time * param)
{
  int pos;
  int start;
  unsigned int val;
  char *tmp;
  GNUNET_CronTime ret;

  ret = 0;
  pos = 0;

  while (t[pos] != '\0')
    {
      start = pos;
      while ((isdigit (t[pos])) && (t[pos] != '\0'))
        pos++;
      tmp = GNUNET_strdup (&t[start]);
      tmp[pos - start] = '\0';
      if (1 != sscanf (tmp, "%u", &val))
        return -1;              /* parse error */
      GNUNET_free (tmp);
      while (t[pos] == ' ')
        pos++;
      start = pos;
      while ((t[pos] != ' ') && (t[pos] != '\0'))
        pos++;
      if (0 == strncasecmp (&t[start], _("ms"), strlen (_("ms"))))
        ret += GNUNET_CRON_MILLISECONDS * val;
      if (0 == strncasecmp (&t[start], _("minutes"), strlen (_("minutes"))))
        ret += GNUNET_CRON_MINUTES * val;
      else if (0 == strncasecmp (&t[start],
                                 _("seconds"), strlen (_("seconds"))))
        ret += GNUNET_CRON_SECONDS * val;
      else if (0 == strncasecmp (&t[start], _("hours"), strlen (_("hours"))))
        ret += GNUNET_CRON_HOURS * val;
      else if (0 == strncasecmp (&t[start], _("days"), strlen (_("days"))))
        ret += GNUNET_CRON_DAYS * val;
      else
        if (0 == strncasecmp (&t[start], _("minute"), strlen (_("minute"))))
        ret += GNUNET_CRON_MINUTES * val;
      else if (0 == strncasecmp (&t[start],
                                 _("second"), strlen (_("second"))))
        ret += GNUNET_CRON_SECONDS * val;
      else if (0 == strncasecmp (&t[start], _("hour"), strlen (_("hour"))))
        ret += GNUNET_CRON_HOURS * val;
      else if (0 == strncasecmp (&t[start], _("day"), strlen (_("day"))))
        ret += GNUNET_CRON_DAYS * val;
      else if (0 == strncasecmp (&t[start], "m", strlen ("m")))
        ret += GNUNET_CRON_MINUTES * val;
      else if (0 == strncasecmp (&t[start], "s", strlen ("s")))
        ret += GNUNET_CRON_SECONDS * val;
      else if (0 == strncasecmp (&t[start], "h", strlen ("h")))
        ret += GNUNET_CRON_HOURS * val;
      else
        return GNUNET_SYSERR;   /* parse error */
      while (t[pos] == ' ')
        pos++;
    }
  *param = ret / GNUNET_CRON_SECONDS;
  return GNUNET_OK;
}
