/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/namespace.h
 * @brief code for dealing with namespaces
 * @author Christian Grothoff
 */

#ifndef GTK_NAMESPACE_H
#define GTK_NAMESPACE_H

/**
 * Add a tab for the given namespace.
 */
int addTabForNamespace (void *unused,
                        const GNUNET_HashCode * namespaceId,
                        const struct GNUNET_MetaData *md, int rating);


void fs_namespace_start (void);

void fs_namespace_stop (void);

#endif
