/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <VrFileSink.h>
#include <VrFileSource.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <GrTCPSink.h>
#include <atsc_types.h>
#include <unistd.h>

const int Rate	= 8000;

void
usage (const char *name)
{
  cerr << "usage: " << name << " [-f <filename>] [-p <port_number>]\n";
  exit (1);
}

int 
main (int argc, char **argv)
{
  char *filename = "mpeg.in";
  int	port = 9000;

  int	ch;
  while ((ch = getopt (argc, argv, "f:p:")) != EOF){
    switch (ch){
    case 'f':
      filename = optarg;
      break;

    case 'p':
      port = strtol (optarg, 0, 0);
      break;

    default:
      usage (argv[0]);
    }
  }

  // create the modules

  VrFileSource<atsc_mpeg_packet>* source =
    new VrFileSource<atsc_mpeg_packet>(Rate, filename, 1);

  GrTCPSink<atsc_mpeg_packet>* sink =
    new GrTCPSink<atsc_mpeg_packet>(port);
  
  VrMultiTask *m = new VrMultiTask ();
  m->add (sink);

  NWO_CONNECT (source, sink);

  m->start ();
  while (1){
    m->process ();
  }
  m->stop ();

  return 0;
}
