#!/bin/env python
# -*- python -*-
#
# Copyright 2003,2009 Free Software Foundation, Inc.
#
# This file is part of GNU Radio
#
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
#

from generate_utils import *


# ----------------------------------------------------------------

def make_gr_fir_sysconfig_h ():
    out = open_and_log_name ('gr_fir_sysconfig.h', 'w')
    if not out:
        return

    out.write (copyright)

    out.write (
'''
/*
 * WARNING: This file is automatically generated by generate_gr_fir_sysconfig.py
 * Any changes made to this file will be overwritten.
 */

#ifndef INCLUDED_GR_FIR_SYSCONFIG_H
#define INCLUDED_GR_FIR_SYSCONFIG_H

#include <gr_types.h>

''')

    # for sig in fir_signatures:
    #    out.write ('class gr_fir_' + sig + ';\n')

    out.write ('#include <gr_fir_util.h>\n')

    out.write (
'''
/*!
 * \\brief abstract base class for configuring the automatic selection of the
 * fastest gr_fir for your platform.
 *
 * This is used internally by gr_fir_util.
 */

class gr_fir_sysconfig {
public:
  virtual ~gr_fir_sysconfig ();

''')

    for sig in fir_signatures:
      out.write (('  virtual gr_fir_%s *create_gr_fir_%s (const std::vector<%s> &taps) = 0;\n' %
        (sig, sig, tap_type (sig))))

    out.write ('\n')

    for sig in fir_signatures:
      out.write (('  virtual void get_gr_fir_%s_info (std::vector<gr_fir_%s_info> *info) = 0;\n' %
        (sig, sig)))

    out.write (
'''
};

/*
 * This returns the single instance of the appropriate derived class.
 * This function must be defined only once in the system, and should be defined
 * in the platform specific code.
 */

gr_fir_sysconfig *gr_fir_sysconfig_singleton ();


#endif /* INCLUDED_GR_FIR_SYSCONFIG_H */
''')
    out.close ()


# ----------------------------------------------------------------

def make_gr_fir_sysconfig_cc ():
    out = open_and_log_name ('gr_fir_sysconfig.cc', 'w')
    if not out:
        return

    out.write (copyright)

    out.write (
'''
/*
 * WARNING: This file is automatically generated by generate_gr_fir_sysconfig.py
 * Any changes made to this file will be overwritten.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gr_fir_sysconfig.h>

gr_fir_sysconfig::~gr_fir_sysconfig ()
{
}
''')
    out.close ()


# ----------------------------------------------------------------

def generate ():
    make_gr_fir_sysconfig_h ()
    make_gr_fir_sysconfig_cc ()

if __name__ == '__main__':
    generate ()
