
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_PDF_DOCUMENT
#define _H_PDF_DOCUMENT

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <Foundation/NSGeometry.h>

#include <PDFKit/PDFOutline.h>


/* Provides a wrapper for an XPDF PDFDoc object. Such
 * an object provides access to the meta-data of a
 * PDF document as well as to the document content.  */
@interface PDFDocument : NSObject
{
   void*       pdfDoc;
   PDFOutline* outline;
}

- (id) init;
- (void) dealloc;
+ (void) initialize;

// Create a new PDF Document from an input file. 
// If the document could not be created, an invalid
// Document is returned (isOk returns NO). Use errorCode
// to get the reason of the failure.
// All returned objects are autoreleased.
+ (PDFDocument*)documentFromFile: (NSString*)fileName;

+ (PDFDocument*)documentFromFile: (NSString*)fileName 
                   ownerPassword: (NSString*)ownerPassword
                    userPassword: (NSString*)userPassword;

- (BOOL) isOk;
- (int) errorCode;

- (double) pageWidth: (int)pageNum;
- (double) pageHeight: (int)pageNum;
- (NSSize) pageSize: (int)pageNum considerRotation: (BOOL)rotation;
- (int) pageRotate: (int)pageNum;

- (int) countPages;

- (NSString*) metaData; 
// returns nil if no MetaData is available
// otherwise an autoreleases string object.

- (BOOL) hasOutline;
- (PDFOutline*) outline;

- (BOOL) findText: (NSString*)text
             page: (int*)pageNum
           toPage: (int)maxPage
         position: (NSRect*)pos
          context: (NSString**)context;

- (NSString*) getTextAtPage: (int)pageNum inRect: (NSRect)pos;

@end

// only for internal usage
@interface PDFDocument(Wrapper)
- (void*) xpdfobject;
@end

#endif
