
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL


#include <PDFKit/PDFOutline.h>
#include "XPDFBridge.h"

#include <Foundation/NSException.h>


/*
 * Non-Public methods of PDFOutlineItem.
 */
@interface PDFOutlineItem(Private)
- (void) setTitle: (NSString*)_title;
@end


NSArray* buildItemsArray(XPDFObject* outlineItems, XPDFObject* pdfDoc)
{
   NSMutableArray* items = [[NSMutableArray alloc] initWithCapacity: 0];
   int i;

   for (i = 0; i < PDFOutline_CountItems(outlineItems); i++)
   {
      NSString* title;
      char*     titleBuffer;

      XPDFObject xpdfItem = PDFOutline_ItemAt(outlineItems, i);
      id outlineItem = [[PDFOutlineItem alloc] initWithOutlineItem: xpdfItem
                                               ofDocument: pdfDoc];

      titleBuffer = PDFOutline_GetTitle(xpdfItem);
      title = [[NSString alloc] initWithCString: titleBuffer];
      free(titleBuffer);
      [outlineItem setTitle: title];
      
      [items addObject: outlineItem];
      [outlineItem autorelease];
   }

   return items;
}


@implementation PDFOutline

- (id) initWithOutlineItems: (void*)xpdfItems ofDocument: (void*)doc;
{
   if ((self = [super init]))
   {
      NSAssert(xpdfItems, @"OutlineItems(xpdf) is NULL");
      items = nil;
      xpdfOutlineItems = xpdfItems;
      xpdfDoc = doc;
   }

   return self;
}


- (void) dealloc
{
   [items release];

   [super dealloc];
}


- (NSArray*) items
{
   if (!items)
   {
      items = buildItemsArray(xpdfOutlineItems, xpdfDoc);
   }

   return items;
}

@end


/*
 * An item of an PDFDocument Outline.
 */
@implementation PDFOutlineItem

- (id) initWithOutlineItem: (void*)xpdfItem ofDocument: (void*)doc;
{
   if ((self = [super init]))
   {
      NSAssert(xpdfItem, @"OutlineItem(xpdf) is NULL");
      title = nil;
      kids  = nil;
      xpdfOutlineItem = xpdfItem;
      xpdfDoc = doc;
      PDFOutline_ItemOpen(xpdfOutlineItem);
   }

   return self;
}


- (void) dealloc
{
   PDFOutline_ItemClose(xpdfOutlineItem);

   [title release];
   [kids release];

   [super dealloc];
}


- (void) setTitle: (NSString*)_title
{
   title = _title;
}

- (NSString*) title
{
   return title;
}


- (int) destinationPage
{
   return PDFOutline_GetTargetPage(xpdfOutlineItem, xpdfDoc);
}


- (BOOL) hasKids
{
   return PDFOutline_HasKids(xpdfOutlineItem);
}


- (NSArray*) kids
{
   if (!kids)
   {
      if ([self hasKids])
      {
         kids = buildItemsArray(PDFOutline_GetKids(xpdfOutlineItem), xpdfDoc);
      }
      else
      {
         kids = [[NSArray alloc] init];
      }
   }

   return kids;
}


- (int) countKids
{
   return [[self kids] count];
}


@end
