;;; file gnuyahoo.scm: example gnuyahoo startup file

;   this is comment
;;; sample gnuyahoo.scm
;;; login-id is equal to my gnu/linux account
;; (gy-set-default-login-id! (array-ref (getpwuid (getuid)) 0))

;;; default login-id for yahoo service
(gy-set-default-login-id! "gnu_india")
;; (gy-set-default-login-id! "abindian")
;; (gy-set-default-login-id! "gnubot")

;;; default global password
(gy-set-default-password! "nopassword")
;; (gy-set-default-password! "pressenter")

;;; by default session mode is AUTO-INSERT. switch it to VANILLA mode
;; (gy-toggle! "session")

;;; by default display of status message is ON. switch it OFF
;; (gy-toggle! "status")

;;; if login-id is "abindian"
(and (string=? (gy-get-default-login-id) "abindian")
     ;;; default password
     (gy-set-default-password! "pressenter")
     ;;; switch OFF bell
     (gy-toggle! "bell")
     ;;; show ALL buddies
     (gy-toggle! "who")
     ;;; login in invisible mode
     (gy-set-default-status! 12))

;;; if login-id is "gnubot"
(and (string=? (gy-get-default-login-id) "gnubot")
     ;;; default password
     (gy-set-default-password! "pressescape")
     ;;; switch OFF bell
     (gy-toggle! "bell"))

;;; create aliases
(define alias '((helpdesk . (abindian balugi kvisu2000))
                (mridul . (gnuindian))
                (bala . (balugi))
                (nags . (nagappanal))
                (visu . (kvisu2000))))

;;; create CC lists
(define cc '((rms . (markus roland thomas))
             (gopal_narayanan . (parag_mehta))))

;;; create forward lists
(define forward '((gnubot . (ramyog_2000 nagappanal balugi))
                 (gopal_narayanan . (parag_mehta))))

