;;; cc.scm: CC the messages to other buddies in the list too
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; cc.scm should be automatically loaded thru init.scm
;;; you need to define cc dotted pair in your ~/.gnuyahoo/gnuyahoo.scm
;;; like this
;;; (define cc '((rms . (gnuindian nagappanal kvisu2000 bala))
;;;	     (gopal . (mehta))))

(if (defined? 'cc)
    '()
    (begin
      (define cc '())))

(define (cc-buddy to msg)
  "CC the messages sent to buddy"
  (and (list? (assq-ref cc (string->symbol to)))
       (send-message-to-group (assq-ref cc 
					(string->symbol to)) 
			      (string-append "CC:" to " " msg))))

(add-hook! gy-message-send-hook cc-buddy)

;;; Dynamic command support
(gy-register-command!
 '("?cc"
   "?cc BUDDY CC-LIST\n\t- cc messages of a BUDDY to a CC-LIST"))

(define (?cc args-list)
  (if (> (length args-list) 1)
      (set! cc (assoc-set! cc (car args-list) (cdr args-list)))
      (begin 
	(display "?cc: wrong number of arguments\n")
	(display "usage: ?cc BUDDY CC-LIST\n"))))
