// Code generated by smithy-go-codegen DO NOT EDIT.

// Package ivsrealtime provides the API client, operations, and parameter types for
// Amazon Interactive Video Service RealTime.
//
// Introduction The Amazon Interactive Video Service (IVS) stage API is REST
// compatible, using a standard HTTP API and an AWS EventBridge event stream for
// responses. JSON is used for both requests and responses, including errors.
// Terminology: The IVS stage API sometimes is referred to as the IVS RealTime API.
// Resources The following resources contain information about your IVS live stream
// (see Getting Started with Amazon IVS
// (https://docs.aws.amazon.com/ivs/latest/userguide/getting-started.html)):
//
// *
// Stage — A stage is a virtual space where multiple participants can exchange
// audio and video in real time.
//
// Tagging A tag is a metadata label that you assign
// to an AWS resource. A tag comprises a key and a value, both set by you. For
// example, you might set a tag as topic:nature to label a particular video
// category. See Tagging AWS Resources
// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more
// information, including restrictions that apply to tags and "Tag naming limits
// and requirements"; Amazon IVS stages has no service-specific constraints beyond
// what is documented there. Tags can help you identify and organize your AWS
// resources. For example, you can use the same tag for different resources to
// indicate that they are related. You can also use tags to manage access (see
// Access Tags
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)). The Amazon
// IVS stage API has these tag-related endpoints: TagResource, UntagResource, and
// ListTagsForResource. The following resource supports tagging: Stage. At most 50
// tags can be applied to a resource. Stages Endpoints
//
// * CreateParticipantToken —
// Creates an additional token for a specified stage. This can be done after stage
// creation or when tokens expire.
//
// * CreateStage — Creates a new stage (and
// optionally participant tokens).
//
// * DeleteStage — Shuts down and deletes the
// specified stage (disconnecting all participants).
//
// * DisconnectParticipant —
// Disconnects a specified participant and revokes the participant permanently from
// a specified stage.
//
// * GetStage — Gets information for the specified stage.
//
// *
// ListStages — Gets summary information about all stages in your account, in the
// AWS region where the API request is processed.
//
// * UpdateStage — Updates a
// stage’s configuration.
//
// # Tags Endpoints
//
// * ListTagsForResource — Gets information
// about AWS tags for the specified ARN.
//
// * TagResource — Adds or updates tags for
// the AWS resource with the specified ARN.
//
// * UntagResource — Removes tags from
// the resource with the specified ARN.
package ivsrealtime
