// Code generated by smithy-go-codegen DO NOT EDIT.

package m2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/m2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the details of a specific batch job execution for a specific application.
func (c *Client) GetBatchJobExecution(ctx context.Context, params *GetBatchJobExecutionInput, optFns ...func(*Options)) (*GetBatchJobExecutionOutput, error) {
	if params == nil {
		params = &GetBatchJobExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBatchJobExecution", params, optFns, c.addOperationGetBatchJobExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBatchJobExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBatchJobExecutionInput struct {

	// The identifier of the application.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier of the batch job execution.
	//
	// This member is required.
	ExecutionId *string

	noSmithyDocumentSerde
}

type GetBatchJobExecutionOutput struct {

	// The identifier of the application.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier for this batch job execution.
	//
	// This member is required.
	ExecutionId *string

	// The timestamp when the batch job execution started.
	//
	// This member is required.
	StartTime *time.Time

	// The status of the batch job execution.
	//
	// This member is required.
	Status types.BatchJobExecutionStatus

	// Identifies a specific batch job.
	BatchJobIdentifier types.BatchJobIdentifier

	// The timestamp when the batch job execution ended.
	EndTime *time.Time

	// The unique identifier for this batch job.
	JobId *string

	// The name of this batch job.
	JobName *string

	// The type of job.
	JobType types.BatchJobType

	// The user for the job.
	JobUser *string

	//
	ReturnCode *string

	// The reason for the reported status.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBatchJobExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetBatchJobExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetBatchJobExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetBatchJobExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBatchJobExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBatchJobExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "m2",
		OperationName: "GetBatchJobExecution",
	}
}
