// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// You are not authorized to access the cluster.
type AccessToClusterDeniedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessToClusterDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessToClusterDeniedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessToClusterDeniedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessToClusterDenied"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessToClusterDeniedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The owner of the specified snapshot has not authorized your account to access
// the snapshot.
type AccessToSnapshotDeniedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessToSnapshotDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessToSnapshotDeniedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessToSnapshotDeniedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessToSnapshotDenied"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessToSnapshotDeniedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The authentication profile already exists.
type AuthenticationProfileAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthenticationProfileAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthenticationProfileAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthenticationProfileAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthenticationProfileAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthenticationProfileAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The authentication profile can't be found.
type AuthenticationProfileNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthenticationProfileNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthenticationProfileNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthenticationProfileNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthenticationProfileNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthenticationProfileNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The size or number of authentication profiles has exceeded the quota. The
// maximum length of the JSON string and maximum number of authentication profiles
// is determined by a quota for your account.
type AuthenticationProfileQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthenticationProfileQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthenticationProfileQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthenticationProfileQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthenticationProfileQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthenticationProfileQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified CIDR block or EC2 security group is already authorized for the
// specified cluster security group.
type AuthorizationAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified CIDR IP range or EC2 security group is not authorized for the
// specified cluster security group.
type AuthorizationNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The authorization quota for the cluster security group has been reached.
type AuthorizationQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number for a batch delete of snapshots has been reached. The limit
// is 100.
type BatchDeleteRequestSizeExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BatchDeleteRequestSizeExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BatchDeleteRequestSizeExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BatchDeleteRequestSizeExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BatchDeleteRequestSizeExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *BatchDeleteRequestSizeExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number for snapshot identifiers has been reached. The limit is 100.
type BatchModifyClusterSnapshotsLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BatchModifyClusterSnapshotsLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BatchModifyClusterSnapshotsLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BatchModifyClusterSnapshotsLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BatchModifyClusterSnapshotsLimitExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *BatchModifyClusterSnapshotsLimitExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Could not find the specified S3 bucket.
type BucketNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BucketNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BucketNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BucketNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BucketNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *BucketNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The account already has a cluster with the given identifier.
type ClusterAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The ClusterIdentifier parameter does not refer to an existing cluster.
type ClusterNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cluster is already on the latest database revision.
type ClusterOnLatestRevisionFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterOnLatestRevisionFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterOnLatestRevisionFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterOnLatestRevisionFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterOnLatestRevision"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterOnLatestRevisionFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A cluster parameter group with the same name already exists.
type ClusterParameterGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterParameterGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterParameterGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterParameterGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterParameterGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterParameterGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The parameter group name does not refer to an existing parameter group.
type ClusterParameterGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterParameterGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterParameterGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterParameterGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterParameterGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterParameterGroupNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request would result in the user exceeding the allowed number of cluster
// parameter groups. For information about increasing your quota, go to Limits in
// Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type ClusterParameterGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterParameterGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterParameterGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterParameterGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterParameterGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterParameterGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request would exceed the allowed number of cluster instances for this
// account. For information about increasing your quota, go to Limits in Amazon
// Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type ClusterQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A cluster security group with the same name already exists.
type ClusterSecurityGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSecurityGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSecurityGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSecurityGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSecurityGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSecurityGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The cluster security group name does not refer to an existing cluster security
// group.
type ClusterSecurityGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSecurityGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSecurityGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSecurityGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSecurityGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSecurityGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of cluster
// security groups. For information about increasing your quota, go to Limits in
// Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type ClusterSecurityGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSecurityGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSecurityGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSecurityGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QuotaExceeded.ClusterSecurityGroup"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSecurityGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The value specified as a snapshot identifier is already used by an existing
// snapshot.
type ClusterSnapshotAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSnapshotAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSnapshotAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSnapshotAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSnapshotAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSnapshotAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The snapshot identifier does not refer to an existing cluster snapshot.
type ClusterSnapshotNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSnapshotNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSnapshotNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSnapshotNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSnapshotNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSnapshotNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of cluster
// snapshots.
type ClusterSnapshotQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSnapshotQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSnapshotQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSnapshotQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSnapshotQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSnapshotQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A ClusterSubnetGroupName is already used by an existing cluster subnet group.
type ClusterSubnetGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSubnetGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSubnetGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSubnetGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSubnetGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSubnetGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The cluster subnet group name does not refer to an existing cluster subnet
// group.
type ClusterSubnetGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSubnetGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSubnetGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSubnetGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSubnetGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSubnetGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in user exceeding the allowed number of cluster subnet
// groups. For information about increasing your quota, go to Limits in Amazon
// Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type ClusterSubnetGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSubnetGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSubnetGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSubnetGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSubnetGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSubnetGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request would result in user exceeding the allowed number of subnets in a
// cluster subnet groups. For information about increasing your quota, go to Limits
// in Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type ClusterSubnetQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterSubnetQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterSubnetQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterSubnetQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterSubnetQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterSubnetQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cross-region snapshot copy was temporarily disabled. Try your request again.
type CopyToRegionDisabledFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CopyToRegionDisabledFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CopyToRegionDisabledFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CopyToRegionDisabledFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CopyToRegionDisabledFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CopyToRegionDisabledFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be completed because a dependent service is throttling
// requests made by Amazon Redshift on your behalf. Wait and retry the request.
type DependentServiceRequestThrottlingFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DependentServiceRequestThrottlingFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DependentServiceRequestThrottlingFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DependentServiceRequestThrottlingFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DependentServiceRequestThrottlingFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DependentServiceRequestThrottlingFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request cannot be completed because a dependent internal service is
// temporarily unavailable. Wait 30 to 60 seconds and try again.
type DependentServiceUnavailableFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DependentServiceUnavailableFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DependentServiceUnavailableFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DependentServiceUnavailableFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DependentServiceUnavailableFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DependentServiceUnavailableFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The account already has a Redshift-managed VPC endpoint with the given
// identifier.
type EndpointAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The authorization already exists for this endpoint.
type EndpointAuthorizationAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointAuthorizationAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointAuthorizationAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointAuthorizationAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointAuthorizationAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointAuthorizationAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The authorization for this endpoint can't be found.
type EndpointAuthorizationNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointAuthorizationNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointAuthorizationNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointAuthorizationNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointAuthorizationNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointAuthorizationNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of endpoint authorizations per cluster has exceeded its limit.
type EndpointAuthorizationsPerClusterLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointAuthorizationsPerClusterLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointAuthorizationsPerClusterLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointAuthorizationsPerClusterLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointAuthorizationsPerClusterLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointAuthorizationsPerClusterLimitExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The endpoint name doesn't refer to an existing endpoint.
type EndpointNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of Redshift-managed VPC endpoints per authorization has exceeded its
// limit.
type EndpointsPerAuthorizationLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointsPerAuthorizationLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointsPerAuthorizationLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointsPerAuthorizationLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointsPerAuthorizationLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointsPerAuthorizationLimitExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of Redshift-managed VPC endpoints per cluster has exceeded its limit.
type EndpointsPerClusterLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EndpointsPerClusterLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EndpointsPerClusterLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EndpointsPerClusterLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EndpointsPerClusterLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EndpointsPerClusterLimitExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request would exceed the allowed number of event subscriptions for this
// account. For information about increasing your quota, go to Limits in Amazon
// Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type EventSubscriptionQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventSubscriptionQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventSubscriptionQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventSubscriptionQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EventSubscriptionQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EventSubscriptionQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is already an existing Amazon Redshift HSM client certificate with the
// specified identifier.
type HsmClientCertificateAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HsmClientCertificateAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HsmClientCertificateAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HsmClientCertificateAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HsmClientCertificateAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *HsmClientCertificateAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is no Amazon Redshift HSM client certificate with the specified
// identifier.
type HsmClientCertificateNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HsmClientCertificateNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HsmClientCertificateNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HsmClientCertificateNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HsmClientCertificateNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *HsmClientCertificateNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota for HSM client certificates has been reached. For information about
// increasing your quota, go to Limits in Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type HsmClientCertificateQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HsmClientCertificateQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HsmClientCertificateQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HsmClientCertificateQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HsmClientCertificateQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *HsmClientCertificateQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is already an existing Amazon Redshift HSM configuration with the
// specified identifier.
type HsmConfigurationAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HsmConfigurationAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HsmConfigurationAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HsmConfigurationAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HsmConfigurationAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *HsmConfigurationAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is no Amazon Redshift HSM configuration with the specified identifier.
type HsmConfigurationNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HsmConfigurationNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HsmConfigurationNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HsmConfigurationNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HsmConfigurationNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *HsmConfigurationNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota for HSM configurations has been reached. For information about
// increasing your quota, go to Limits in Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type HsmConfigurationQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HsmConfigurationQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HsmConfigurationQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HsmConfigurationQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HsmConfigurationQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *HsmConfigurationQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified options are incompatible.
type IncompatibleOrderableOptions struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IncompatibleOrderableOptions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IncompatibleOrderableOptions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IncompatibleOrderableOptions) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IncompatibleOrderableOptions"
	}
	return *e.ErrorCodeOverride
}
func (e *IncompatibleOrderableOptions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the allowed number of table restore requests. Wait for your
// current table restore requests to complete before making a new request.
type InProgressTableRestoreQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InProgressTableRestoreQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InProgressTableRestoreQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InProgressTableRestoreQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InProgressTableRestoreQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InProgressTableRestoreQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of nodes specified exceeds the allotted capacity of the cluster.
type InsufficientClusterCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientClusterCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientClusterCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientClusterCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientClusterCapacity"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientClusterCapacityFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cluster does not have read bucket or put object permissions on the S3 bucket
// specified when enabling logging.
type InsufficientS3BucketPolicyFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientS3BucketPolicyFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientS3BucketPolicyFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientS3BucketPolicyFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientS3BucketPolicyFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientS3BucketPolicyFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The authentication profile request is not valid. The profile name can't be null
// or empty. The authentication profile API operation must be available in the
// Amazon Web Services Region.
type InvalidAuthenticationProfileRequestFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAuthenticationProfileRequestFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAuthenticationProfileRequestFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAuthenticationProfileRequestFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAuthenticationProfileRequestFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAuthenticationProfileRequestFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The status of the authorization is not valid.
type InvalidAuthorizationStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAuthorizationStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAuthorizationStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAuthorizationStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAuthorizationState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAuthorizationStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cluster parameter group action can not be completed because another task is
// in progress that involves the parameter group. Wait a few moments and try the
// operation again.
type InvalidClusterParameterGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterParameterGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterParameterGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterParameterGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterParameterGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterParameterGroupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The state of the cluster security group is not available.
type InvalidClusterSecurityGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterSecurityGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterSecurityGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterSecurityGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterSecurityGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterSecurityGroupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The cluster snapshot schedule state is not valid.
type InvalidClusterSnapshotScheduleStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterSnapshotScheduleStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterSnapshotScheduleStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterSnapshotScheduleStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterSnapshotScheduleState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterSnapshotScheduleStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified cluster snapshot is not in the available state, or other accounts
// are authorized to access the snapshot.
type InvalidClusterSnapshotStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterSnapshotStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterSnapshotStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterSnapshotStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterSnapshotState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterSnapshotStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified cluster is not in the available state.
type InvalidClusterStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cluster subnet group cannot be deleted because it is in use.
type InvalidClusterSubnetGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterSubnetGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterSubnetGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterSubnetGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterSubnetGroupStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterSubnetGroupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The state of the subnet is invalid.
type InvalidClusterSubnetStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterSubnetStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterSubnetStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterSubnetStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterSubnetStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterSubnetStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The provided cluster track name is not valid.
type InvalidClusterTrackFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClusterTrackFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClusterTrackFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClusterTrackFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClusterTrack"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClusterTrackFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There is an error with the datashare.
type InvalidDataShareFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDataShareFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDataShareFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDataShareFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDataShareFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDataShareFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Elastic IP (EIP) is invalid or cannot be found.
type InvalidElasticIpFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidElasticIpFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidElasticIpFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidElasticIpFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidElasticIpFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidElasticIpFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The status of the endpoint is not valid.
type InvalidEndpointStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEndpointStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEndpointStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEndpointStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidEndpointState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEndpointStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified HSM client certificate is not in the available state, or it is
// still in use by one or more Amazon Redshift clusters.
type InvalidHsmClientCertificateStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidHsmClientCertificateStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidHsmClientCertificateStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidHsmClientCertificateStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidHsmClientCertificateStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidHsmClientCertificateStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified HSM configuration is not in the available state, or it is still in
// use by one or more Amazon Redshift clusters.
type InvalidHsmConfigurationStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidHsmConfigurationStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidHsmConfigurationStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidHsmConfigurationStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidHsmConfigurationStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidHsmConfigurationStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The namespace isn't valid because the namespace doesn't exist. Provide a valid
// namespace.
type InvalidNamespaceFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNamespaceFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNamespaceFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNamespaceFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNamespaceFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNamespaceFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Indicates that the Reserved Node being exchanged is not in an active state.
type InvalidReservedNodeStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReservedNodeStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReservedNodeStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReservedNodeStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidReservedNodeState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReservedNodeStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The restore is invalid.
type InvalidRestoreFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRestoreFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRestoreFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRestoreFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRestore"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRestoreFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The retention period specified is either in the past or is not a valid value.
// The value must be either -1 or an integer between 1 and 3,653.
type InvalidRetentionPeriodFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRetentionPeriodFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRetentionPeriodFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRetentionPeriodFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRetentionPeriodFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRetentionPeriodFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The S3 bucket name is invalid. For more information about naming rules, go to
// Bucket Restrictions and Limitations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html) in the
// Amazon Simple Storage Service (S3) Developer Guide.
type InvalidS3BucketNameFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3BucketNameFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3BucketNameFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3BucketNameFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidS3BucketNameFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3BucketNameFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The string specified for the logging S3 key prefix does not comply with the
// documented constraints.
type InvalidS3KeyPrefixFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3KeyPrefixFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3KeyPrefixFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3KeyPrefixFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidS3KeyPrefixFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3KeyPrefixFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The scheduled action is not valid.
type InvalidScheduledActionFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidScheduledActionFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidScheduledActionFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidScheduledActionFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidScheduledAction"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidScheduledActionFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The schedule you submitted isn't valid.
type InvalidScheduleFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidScheduleFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidScheduleFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidScheduleFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSchedule"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidScheduleFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The snapshot copy grant can't be deleted because it is used by one or more
// clusters.
type InvalidSnapshotCopyGrantStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSnapshotCopyGrantStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSnapshotCopyGrantStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSnapshotCopyGrantStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSnapshotCopyGrantStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSnapshotCopyGrantStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested subnet is not valid, or not all of the subnets are in the same
// VPC.
type InvalidSubnet struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSubnet) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSubnet) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSubnet"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSubnet) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The subscription request is invalid because it is a duplicate request. This
// subscription request is already in progress.
type InvalidSubscriptionStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSubscriptionStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSubscriptionStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSubscriptionStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSubscriptionStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSubscriptionStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The value specified for the sourceDatabaseName, sourceSchemaName, or
// sourceTableName parameter, or a combination of these, doesn't exist in the
// snapshot.
type InvalidTableRestoreArgumentFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTableRestoreArgumentFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTableRestoreArgumentFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTableRestoreArgumentFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTableRestoreArgument"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTableRestoreArgumentFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tag is invalid.
type InvalidTagFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTagFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTagFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTagFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The usage limit is not valid.
type InvalidUsageLimitFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUsageLimitFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUsageLimitFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUsageLimitFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidUsageLimit"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUsageLimitFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cluster subnet group does not cover all Availability Zones.
type InvalidVPCNetworkStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidVPCNetworkStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidVPCNetworkStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidVPCNetworkStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidVPCNetworkStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidVPCNetworkStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The encryption key has exceeded its grant limit in Amazon Web Services KMS.
type LimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation would exceed the number of nodes allowed for a cluster.
type NumberOfNodesPerClusterLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NumberOfNodesPerClusterLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NumberOfNodesPerClusterLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NumberOfNodesPerClusterLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NumberOfNodesPerClusterLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *NumberOfNodesPerClusterLimitExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation would exceed the number of nodes allotted to the account. For
// information about increasing your quota, go to Limits in Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type NumberOfNodesQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NumberOfNodesQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NumberOfNodesQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NumberOfNodesQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NumberOfNodesQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *NumberOfNodesQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The name of the partner was not found.
type PartnerNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PartnerNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PartnerNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PartnerNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PartnerNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *PartnerNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// User already has a reservation with the given identifier.
type ReservedNodeAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNodeAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNodeAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNodeAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNodeAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNodeAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Indicates that the reserved node has already been exchanged.
type ReservedNodeAlreadyMigratedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNodeAlreadyMigratedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNodeAlreadyMigratedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNodeAlreadyMigratedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNodeAlreadyMigrated"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNodeAlreadyMigratedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The reserved-node exchange status wasn't found.
type ReservedNodeExchangeNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNodeExchangeNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNodeExchangeNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNodeExchangeNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNodeExchangeNotFond"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNodeExchangeNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified reserved compute node not found.
type ReservedNodeNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNodeNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNodeNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNodeNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNodeNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNodeNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Specified offering does not exist.
type ReservedNodeOfferingNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNodeOfferingNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNodeOfferingNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNodeOfferingNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNodeOfferingNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNodeOfferingNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Request would exceed the user's compute node quota. For information about
// increasing your quota, go to Limits in Amazon Redshift
// (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
// in the Amazon Redshift Cluster Management Guide.
type ReservedNodeQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNodeQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNodeQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNodeQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNodeQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNodeQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resize operation for the specified cluster is not found.
type ResizeNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResizeNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResizeNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResizeNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResizeNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ResizeNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource could not be found.
type ResourceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The scheduled action already exists.
type ScheduledActionAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ScheduledActionAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ScheduledActionAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ScheduledActionAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ScheduledActionAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ScheduledActionAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The scheduled action cannot be found.
type ScheduledActionNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ScheduledActionNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ScheduledActionNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ScheduledActionNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ScheduledActionNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ScheduledActionNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota for scheduled actions exceeded.
type ScheduledActionQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ScheduledActionQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ScheduledActionQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ScheduledActionQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ScheduledActionQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ScheduledActionQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The action type specified for a scheduled action is not supported.
type ScheduledActionTypeUnsupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ScheduledActionTypeUnsupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ScheduledActionTypeUnsupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ScheduledActionTypeUnsupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ScheduledActionTypeUnsupported"
	}
	return *e.ErrorCodeOverride
}
func (e *ScheduledActionTypeUnsupportedFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The definition you submitted is not supported.
type ScheduleDefinitionTypeUnsupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ScheduleDefinitionTypeUnsupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ScheduleDefinitionTypeUnsupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ScheduleDefinitionTypeUnsupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ScheduleDefinitionTypeUnsupported"
	}
	return *e.ErrorCodeOverride
}
func (e *ScheduleDefinitionTypeUnsupportedFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The cluster already has cross-region snapshot copy disabled.
type SnapshotCopyAlreadyDisabledFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotCopyAlreadyDisabledFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotCopyAlreadyDisabledFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotCopyAlreadyDisabledFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotCopyAlreadyDisabledFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotCopyAlreadyDisabledFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cluster already has cross-region snapshot copy enabled.
type SnapshotCopyAlreadyEnabledFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotCopyAlreadyEnabledFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotCopyAlreadyEnabledFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotCopyAlreadyEnabledFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotCopyAlreadyEnabledFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotCopyAlreadyEnabledFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cross-region snapshot copy was temporarily disabled. Try your request again.
type SnapshotCopyDisabledFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotCopyDisabledFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotCopyDisabledFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotCopyDisabledFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotCopyDisabledFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotCopyDisabledFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The snapshot copy grant can't be created because a grant with the same name
// already exists.
type SnapshotCopyGrantAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotCopyGrantAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotCopyGrantAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotCopyGrantAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotCopyGrantAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotCopyGrantAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified snapshot copy grant can't be found. Make sure that the name is
// typed correctly and that the grant exists in the destination region.
type SnapshotCopyGrantNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotCopyGrantNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotCopyGrantNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotCopyGrantNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotCopyGrantNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotCopyGrantNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon Web Services account has exceeded the maximum number of snapshot copy
// grants in this region.
type SnapshotCopyGrantQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotCopyGrantQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotCopyGrantQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotCopyGrantQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotCopyGrantQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotCopyGrantQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified snapshot schedule already exists.
type SnapshotScheduleAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotScheduleAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotScheduleAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotScheduleAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotScheduleAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotScheduleAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// We could not find the specified snapshot schedule.
type SnapshotScheduleNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotScheduleNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotScheduleNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotScheduleNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotScheduleNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotScheduleNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the quota of snapshot schedules.
type SnapshotScheduleQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotScheduleQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotScheduleQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotScheduleQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotScheduleQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotScheduleQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified snapshot schedule is already being updated.
type SnapshotScheduleUpdateInProgressFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotScheduleUpdateInProgressFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotScheduleUpdateInProgressFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotScheduleUpdateInProgressFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotScheduleUpdateInProgress"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotScheduleUpdateInProgressFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Amazon SNS has responded that there is a problem with the specified Amazon SNS
// topic.
type SNSInvalidTopicFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSInvalidTopicFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSInvalidTopicFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSInvalidTopicFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSInvalidTopic"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSInvalidTopicFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You do not have permission to publish to the specified Amazon SNS topic.
type SNSNoAuthorizationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSNoAuthorizationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSNoAuthorizationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSNoAuthorizationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSNoAuthorization"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSNoAuthorizationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
// exist.
type SNSTopicArnNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSTopicArnNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSTopicArnNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSTopicArnNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSTopicArnNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSTopicArnNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon Redshift event source could not be found.
type SourceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SourceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified subnet is already in use by another cluster.
type SubnetAlreadyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubnetAlreadyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubnetAlreadyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubnetAlreadyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubnetAlreadyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *SubnetAlreadyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There is already an existing event notification subscription with the specified
// name.
type SubscriptionAlreadyExistFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionAlreadyExistFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionAlreadyExistFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionAlreadyExistFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionAlreadyExist"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionAlreadyExistFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The value specified for the event category was not one of the allowed values, or
// it specified a category that does not apply to the specified source type. The
// allowed values are Configuration, Management, Monitoring, and Security.
type SubscriptionCategoryNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionCategoryNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionCategoryNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionCategoryNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionCategoryNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionCategoryNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An Amazon Redshift event with the specified event ID does not exist.
type SubscriptionEventIdNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionEventIdNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionEventIdNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionEventIdNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionEventIdNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionEventIdNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An Amazon Redshift event notification subscription with the specified name does
// not exist.
type SubscriptionNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The value specified for the event severity was not one of the allowed values, or
// it specified a severity that does not apply to the specified source type. The
// allowed values are ERROR and INFO.
type SubscriptionSeverityNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionSeverityNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionSeverityNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionSeverityNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionSeverityNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionSeverityNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of tables in the cluster exceeds the limit for the requested new
// cluster node type.
type TableLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TableLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TableLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TableLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TableLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *TableLimitExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified TableRestoreRequestId value was not found.
type TableRestoreNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TableRestoreNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TableRestoreNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TableRestoreNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TableRestoreNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *TableRestoreNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the number of tags allowed.
type TagLimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagLimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagLimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagLimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TagLimitExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *TagLimitExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your account is not authorized to perform the requested operation.
type UnauthorizedOperation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnauthorizedOperation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnauthorizedOperation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnauthorizedOperation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnauthorizedOperation"
	}
	return *e.ErrorCodeOverride
}
func (e *UnauthorizedOperation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The partner integration is not authorized.
type UnauthorizedPartnerIntegrationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnauthorizedPartnerIntegrationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnauthorizedPartnerIntegrationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnauthorizedPartnerIntegrationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnauthorizedPartnerIntegration"
	}
	return *e.ErrorCodeOverride
}
func (e *UnauthorizedPartnerIntegrationFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified region is incorrect or does not exist.
type UnknownSnapshotCopyRegionFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnknownSnapshotCopyRegionFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnknownSnapshotCopyRegionFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnknownSnapshotCopyRegionFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnknownSnapshotCopyRegionFault"
	}
	return *e.ErrorCodeOverride
}
func (e *UnknownSnapshotCopyRegionFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation isn't supported.
type UnsupportedOperationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOperation"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A request option was specified that is not supported.
type UnsupportedOptionFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOptionFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOptionFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOptionFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOptionFault"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOptionFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The usage limit already exists.
type UsageLimitAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UsageLimitAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UsageLimitAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UsageLimitAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UsageLimitAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *UsageLimitAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The usage limit identifier can't be found.
type UsageLimitNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UsageLimitNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UsageLimitNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UsageLimitNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UsageLimitNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *UsageLimitNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
