// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a SageMaker experiment. An experiment is a collection of trials that are
// observed, compared and evaluated as a group. A trial is a set of steps, called
// trial components, that produce a machine learning model. In the Studio UI,
// trials are referred to as run groups and trial components are referred to as
// runs. The goal of an experiment is to determine the components that produce the
// best model. Multiple trials are performed, each one isolating and measuring the
// impact of a change to one or more inputs, while keeping the remaining inputs
// constant. When you use SageMaker Studio or the SageMaker Python SDK, all
// experiments, trials, and trial components are automatically tracked, logged, and
// indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
// use the logging APIs provided by the SDK. You can add tags to experiments,
// trials, trial components and then use the Search API to search for the tags. To
// add a description to an experiment, specify the optional Description parameter.
// To add a description later, or to change the description, call the
// UpdateExperiment API. To get a list of all your experiments, call the
// ListExperiments API. To view an experiment's properties, call the
// DescribeExperiment API. To get a list of all the trials associated with an
// experiment, call the ListTrials API. To create a trial call the CreateTrial API.
func (c *Client) CreateExperiment(ctx context.Context, params *CreateExperimentInput, optFns ...func(*Options)) (*CreateExperimentOutput, error) {
	if params == nil {
		params = &CreateExperimentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateExperiment", params, optFns, c.addOperationCreateExperimentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateExperimentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateExperimentInput struct {

	// The name of the experiment. The name must be unique in your Amazon Web Services
	// account and is not case-sensitive.
	//
	// This member is required.
	ExperimentName *string

	// The description of the experiment.
	Description *string

	// The name of the experiment as displayed. The name doesn't need to be unique. If
	// you don't specify DisplayName, the value in ExperimentName is displayed.
	DisplayName *string

	// A list of tags to associate with the experiment. You can use Search API to
	// search on the tags.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateExperimentOutput struct {

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateExperimentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateExperiment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateExperiment{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateExperimentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateExperiment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateExperiment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "CreateExperiment",
	}
}
