// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a job queue.
func (c *Client) UpdateJobQueue(ctx context.Context, params *UpdateJobQueueInput, optFns ...func(*Options)) (*UpdateJobQueueOutput, error) {
	if params == nil {
		params = &UpdateJobQueueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateJobQueue", params, optFns, c.addOperationUpdateJobQueueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateJobQueueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Contains the parameters for UpdateJobQueue .
type UpdateJobQueueInput struct {

	// The name or the Amazon Resource Name (ARN) of the job queue.
	//
	// This member is required.
	JobQueue *string

	// Details the set of compute environments mapped to a job queue and their order
	// relative to each other. This is one of the parameters used by the job scheduler
	// to determine which compute environment runs a given job. Compute environments
	// must be in the VALID state before you can associate them with a job queue. All
	// of the compute environments must be either EC2 ( EC2 or SPOT ) or Fargate (
	// FARGATE or FARGATE_SPOT ). EC2 and Fargate compute environments can't be mixed.
	// All compute environments that are associated with a job queue must share the
	// same architecture. Batch doesn't support mixing compute environment architecture
	// types in a single job queue.
	ComputeEnvironmentOrder []types.ComputeEnvironmentOrder

	// The set of actions that Batch perform on jobs that remain at the head of the
	// job queue in the specified state longer than specified times. Batch will perform
	// each action after maxTimeSeconds has passed.
	JobStateTimeLimitActions []types.JobStateTimeLimitAction

	// The priority of the job queue. Job queues with a higher priority (or a higher
	// integer value for the priority parameter) are evaluated first when associated
	// with the same compute environment. Priority is determined in descending order.
	// For example, a job queue with a priority value of 10 is given scheduling
	// preference over a job queue with a priority value of 1 . All of the compute
	// environments must be either EC2 ( EC2 or SPOT ) or Fargate ( FARGATE or
	// FARGATE_SPOT ). EC2 and Fargate compute environments can't be mixed.
	Priority *int32

	// Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job
	// queue is created, the fair share scheduling policy can be replaced but not
	// removed. The format is
	// aws:Partition:batch:Region:Account:scheduling-policy/Name . For example,
	// aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy .
	SchedulingPolicyArn *string

	// Describes the queue's ability to accept new jobs. If the job queue state is
	// ENABLED , it can accept jobs. If the job queue state is DISABLED , new jobs
	// can't be added to the queue, but jobs already in the queue can finish.
	State types.JQState

	noSmithyDocumentSerde
}

type UpdateJobQueueOutput struct {

	// The Amazon Resource Name (ARN) of the job queue.
	JobQueueArn *string

	// The name of the job queue.
	JobQueueName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateJobQueueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateJobQueue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateJobQueue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateJobQueue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateJobQueueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateJobQueue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateJobQueue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateJobQueue",
	}
}
