// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An augmented manifest file that provides training data for your custom model.
// An augmented manifest file is a labeled dataset that is produced by Amazon
// SageMaker Ground Truth.
type AugmentedManifestsListItem struct {

	// The JSON attribute that contains the annotations for your training documents.
	// The number of attribute names that you specify depends on whether your augmented
	// manifest file is the output of a single labeling job or a chained labeling job.
	// If your file is the output of a single labeling job, specify the
	// LabelAttributeName key that was used when the job was created in Ground Truth.
	// If your file is the output of a chained labeling job, specify the
	// LabelAttributeName key for one or more jobs in the chain. Each
	// LabelAttributeName key provides the annotations from an individual job.
	//
	// This member is required.
	AttributeNames []string

	// The Amazon S3 location of the augmented manifest file.
	//
	// This member is required.
	S3Uri *string

	// The S3 prefix to the annotation files that are referred in the augmented
	// manifest file.
	AnnotationDataS3Uri *string

	// The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If
	// you don't specify, the default is PlainTextDocument.
	//   - PLAIN_TEXT_DOCUMENT A document type that represents any unicode text that is
	//   encoded in UTF-8.
	//   - SEMI_STRUCTURED_DOCUMENT A document type with positional and structural
	//   context, like a PDF. For training with Amazon Comprehend, only PDFs are
	//   supported. For inference, Amazon Comprehend support PDFs, DOCX and TXT.
	DocumentType AugmentedManifestsDocumentTypeFormat

	// The S3 prefix to the source files (PDFs) that are referred to in the augmented
	// manifest file.
	SourceDocumentsS3Uri *string

	// The purpose of the data you've provided in the augmented manifest. You can
	// either train or test this data. If you don't specify, the default is train.
	// TRAIN - all of the documents in the manifest will be used for training. If no
	// test documents are provided, Amazon Comprehend will automatically reserve a
	// portion of the training documents for testing. TEST - all of the documents in
	// the manifest will be used for testing.
	Split Split

	noSmithyDocumentSerde
}

// The result of calling the operation. The operation returns one object for each
// document that is successfully processed by the operation.
type BatchDetectDominantLanguageItemResult struct {

	// The zero-based index of the document in the input list.
	Index *int32

	// One or more DominantLanguage objects describing the dominant languages in the
	// document.
	Languages []DominantLanguage

	noSmithyDocumentSerde
}

// The result of calling the operation. The operation returns one object for each
// document that is successfully processed by the operation.
type BatchDetectEntitiesItemResult struct {

	// One or more Entity objects, one for each entity detected in the document.
	Entities []Entity

	// The zero-based index of the document in the input list.
	Index *int32

	noSmithyDocumentSerde
}

// The result of calling the operation. The operation returns one object for each
// document that is successfully processed by the operation.
type BatchDetectKeyPhrasesItemResult struct {

	// The zero-based index of the document in the input list.
	Index *int32

	// One or more KeyPhrase objects, one for each key phrase detected in the document.
	KeyPhrases []KeyPhrase

	noSmithyDocumentSerde
}

// The result of calling the operation. The operation returns one object for each
// document that is successfully processed by the operation.
type BatchDetectSentimentItemResult struct {

	// The zero-based index of the document in the input list.
	Index *int32

	// The sentiment detected in the document.
	Sentiment SentimentType

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// sentiment detection.
	SentimentScore *SentimentScore

	noSmithyDocumentSerde
}

// The result of calling the operation. The operation returns one object that is
// successfully processed by the operation.
type BatchDetectSyntaxItemResult struct {

	// The zero-based index of the document in the input list.
	Index *int32

	// The syntax tokens for the words in the document, one token for each word.
	SyntaxTokens []SyntaxToken

	noSmithyDocumentSerde
}

// Analysis results for one of the documents in the batch.
type BatchDetectTargetedSentimentItemResult struct {

	// An array of targeted sentiment entities.
	Entities []TargetedSentimentEntity

	// The zero-based index of this result in the input list.
	Index *int32

	noSmithyDocumentSerde
}

// Describes an error that occurred while processing a document in a batch. The
// operation returns on BatchItemError object for each document that contained an
// error.
type BatchItemError struct {

	// The numeric error code of the error.
	ErrorCode *string

	// A text description of the error.
	ErrorMessage *string

	// The zero-based index of the document in the input list.
	Index *int32

	noSmithyDocumentSerde
}

// Information about each word or line of text in the input document. For
// additional information, see Block (https://docs.aws.amazon.com/textract/latest/dg/API_Block.html)
// in the Amazon Textract API reference.
type Block struct {

	// The block represents a line of text or one word of text.
	//   - WORD - A word that's detected on a document page. A word is one or more ISO
	//   basic Latin script characters that aren't separated by spaces.
	//   - LINE - A string of tab-delimited, contiguous words that are detected on a
	//   document page
	BlockType BlockType

	// Co-ordinates of the rectangle or polygon that contains the text.
	Geometry *Geometry

	// Unique identifier for the block.
	Id *string

	// Page number where the block appears.
	Page *int32

	// A list of child blocks of the current block. For example, a LINE object has
	// child blocks for each WORD block that's part of the line of text.
	Relationships []RelationshipsListItem

	// The word or line of text extracted from the block.
	Text *string

	noSmithyDocumentSerde
}

// A reference to a block.
type BlockReference struct {

	// Offset of the start of the block within its parent block.
	BeginOffset *int32

	// Unique identifier for the block.
	BlockId *string

	// List of child blocks within this block.
	ChildBlocks []ChildBlock

	// Offset of the end of the block within its parent block.
	EndOffset *int32

	noSmithyDocumentSerde
}

// The bounding box around the detected page or around an element on a document
// page. The left (x-coordinate) and top (y-coordinate) are coordinates that
// represent the top and left sides of the bounding box. Note that the upper-left
// corner of the image is the origin (0,0). For additional information, see
// BoundingBox (https://docs.aws.amazon.com/textract/latest/dg/API_BoundingBox.html)
// in the Amazon Textract API reference.
type BoundingBox struct {

	// The height of the bounding box as a ratio of the overall document page height.
	Height *float32

	// The left coordinate of the bounding box as a ratio of overall document page
	// width.
	Left *float32

	// The top coordinate of the bounding box as a ratio of overall document page
	// height.
	Top *float32

	// The width of the bounding box as a ratio of the overall document page width.
	Width *float32

	noSmithyDocumentSerde
}

// Nested block contained within a block.
type ChildBlock struct {

	// Offset of the start of the child block within its parent block.
	BeginOffset *int32

	// Unique identifier for the child block.
	ChildBlockId *string

	// Offset of the end of the child block within its parent block.
	EndOffset *int32

	noSmithyDocumentSerde
}

// Describes the result metrics for the test data associated with an documentation
// classifier.
type ClassifierEvaluationMetrics struct {

	// The fraction of the labels that were correct recognized. It is computed by
	// dividing the number of labels in the test documents that were correctly
	// recognized by the total number of labels in the test documents.
	Accuracy *float64

	// A measure of how accurate the classifier results are for the test data. It is
	// derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. The highest score is 1, and the worst score is 0.
	F1Score *float64

	// Indicates the fraction of labels that are incorrectly predicted. Also seen as
	// the fraction of wrong labels compared to the total number of labels. Scores
	// closer to zero are better.
	HammingLoss *float64

	// A measure of how accurate the classifier results are for the test data. It is a
	// combination of the Micro Precision and Micro Recall values. The Micro F1Score
	// is the harmonic mean of the two scores. The highest score is 1, and the worst
	// score is 0.
	MicroF1Score *float64

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant results
	// than irrelevant ones. Unlike the Precision metric which comes from averaging the
	// precision of all available labels, this is based on the overall score of all
	// precision scores added together.
	MicroPrecision *float64

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results.
	// Specifically, this indicates how many of the correct categories in the text that
	// the model can predict. It is a percentage of correct categories in the text that
	// can found. Instead of averaging the recall scores of all labels (as with
	// Recall), micro Recall is based on the overall score of all recall scores added
	// together.
	MicroRecall *float64

	// A measure of the usefulness of the classifier results in the test data. High
	// precision means that the classifier returned substantially more relevant results
	// than irrelevant ones.
	Precision *float64

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results.
	Recall *float64

	noSmithyDocumentSerde
}

// Provides information about a document classifier.
type ClassifierMetadata struct {

	// Describes the result metrics for the test data associated with an documentation
	// classifier.
	EvaluationMetrics *ClassifierEvaluationMetrics

	// The number of labels in the input data.
	NumberOfLabels *int32

	// The number of documents in the input data that were used to test the
	// classifier. Typically this is 10 to 20 percent of the input documents, up to
	// 10,000 documents.
	NumberOfTestDocuments *int32

	// The number of documents in the input data that were used to train the
	// classifier. Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int32

	noSmithyDocumentSerde
}

// Data security configuration.
type DataSecurityConfig struct {

	// ID for the KMS key that Amazon Comprehend uses to encrypt the data in the data
	// lake.
	DataLakeKmsKeyId *string

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string

	// ID for the KMS key that Amazon Comprehend uses to encrypt the volume.
	VolumeKmsKeyId *string

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for the job. For more information, see
	// Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// An augmented manifest file that provides training data for your custom model.
// An augmented manifest file is a labeled dataset that is produced by Amazon
// SageMaker Ground Truth.
type DatasetAugmentedManifestsListItem struct {

	// The JSON attribute that contains the annotations for your training documents.
	// The number of attribute names that you specify depends on whether your augmented
	// manifest file is the output of a single labeling job or a chained labeling job.
	// If your file is the output of a single labeling job, specify the
	// LabelAttributeName key that was used when the job was created in Ground Truth.
	// If your file is the output of a chained labeling job, specify the
	// LabelAttributeName key for one or more jobs in the chain. Each
	// LabelAttributeName key provides the annotations from an individual job.
	//
	// This member is required.
	AttributeNames []string

	// The Amazon S3 location of the augmented manifest file.
	//
	// This member is required.
	S3Uri *string

	// The S3 prefix to the annotation files that are referred in the augmented
	// manifest file.
	AnnotationDataS3Uri *string

	// The type of augmented manifest. If you don't specify, the default is
	// PlainTextDocument. PLAIN_TEXT_DOCUMENT A document type that represents any
	// unicode text that is encoded in UTF-8.
	DocumentType AugmentedManifestsDocumentTypeFormat

	// The S3 prefix to the source files (PDFs) that are referred to in the augmented
	// manifest file.
	SourceDocumentsS3Uri *string

	noSmithyDocumentSerde
}

// Describes the dataset input data configuration for a document classifier model.
// For more information on how the input file is formatted, see Preparing training
// data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html)
// in the Comprehend Developer Guide.
type DatasetDocumentClassifierInputDataConfig struct {

	// The Amazon S3 URI for the input data. The S3 bucket must be in the same Region
	// as the API endpoint that you are calling. The URI can point to a single input
	// file or it can provide the prefix for a collection of input files. For example,
	// if you use the URI S3://bucketName/prefix , if the prefix is a single file,
	// Amazon Comprehend uses that file as input. If more than one file begins with the
	// prefix, Amazon Comprehend uses all of them as input. This parameter is required
	// if you set DataFormat to COMPREHEND_CSV .
	//
	// This member is required.
	S3Uri *string

	// Indicates the delimiter used to separate each label for training a multi-label
	// classifier. The default delimiter between labels is a pipe (|). You can use a
	// different character as a delimiter (if it's an allowed character) by specifying
	// it under Delimiter for labels. If the training documents use a delimiter other
	// than the default or the delimiter you specify, the labels on that line will be
	// combined to make a single unique label, such as LABELLABELLABEL.
	LabelDelimiter *string

	noSmithyDocumentSerde
}

// Describes the annotations associated with a entity recognizer.
type DatasetEntityRecognizerAnnotations struct {

	// Specifies the Amazon S3 location where the training documents for an entity
	// recognizer are located. The URI must be in the same Region as the API endpoint
	// that you are calling.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Describes the documents submitted with a dataset for an entity recognizer model.
type DatasetEntityRecognizerDocuments struct {

	// Specifies the Amazon S3 location where the documents for the dataset are
	// located.
	//
	// This member is required.
	S3Uri *string

	// Specifies how the text in an input file should be processed. This is optional,
	// and the default is ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered
	// a separate document. Use this option when you are processing large documents,
	// such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line in
	// a file is considered a separate document. Use this option when you are
	// processing many short documents, such as text messages.
	InputFormat InputFormat

	noSmithyDocumentSerde
}

// Describes the dataset entity list for an entity recognizer model. For more
// information on how the input file is formatted, see Preparing training data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-training-data-cer.html)
// in the Comprehend Developer Guide.
type DatasetEntityRecognizerEntityList struct {

	// Specifies the Amazon S3 location where the entity list is located.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Specifies the format and location of the input data. You must provide either
// the Annotations parameter or the EntityList parameter.
type DatasetEntityRecognizerInputDataConfig struct {

	// The format and location of the training documents for your custom entity
	// recognizer.
	//
	// This member is required.
	Documents *DatasetEntityRecognizerDocuments

	// The S3 location of the annotation documents for your custom entity recognizer.
	Annotations *DatasetEntityRecognizerAnnotations

	// The S3 location of the entity list for your custom entity recognizer.
	EntityList *DatasetEntityRecognizerEntityList

	noSmithyDocumentSerde
}

// Filter the datasets based on creation time or dataset status.
type DatasetFilter struct {

	// Filter the datasets to include datasets created after the specified time.
	CreationTimeAfter *time.Time

	// Filter the datasets to include datasets created before the specified time.
	CreationTimeBefore *time.Time

	// Filter the datasets based on the dataset type.
	DatasetType DatasetType

	// Filter the datasets based on the dataset status.
	Status DatasetStatus

	noSmithyDocumentSerde
}

// Specifies the format and location of the input data for the dataset.
type DatasetInputDataConfig struct {

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth.
	AugmentedManifests []DatasetAugmentedManifestsListItem

	// COMPREHEND_CSV : The data format is a two-column CSV file, where the first
	// column contains labels and the second column contains documents.
	// AUGMENTED_MANIFEST : The data format
	DataFormat DatasetDataFormat

	// The input properties for training a document classifier model. For more
	// information on how the input file is formatted, see Preparing training data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html)
	// in the Comprehend Developer Guide.
	DocumentClassifierInputDataConfig *DatasetDocumentClassifierInputDataConfig

	// The input properties for training an entity recognizer model.
	EntityRecognizerInputDataConfig *DatasetEntityRecognizerInputDataConfig

	noSmithyDocumentSerde
}

// Properties associated with the dataset.
type DatasetProperties struct {

	// Creation time of the dataset.
	CreationTime *time.Time

	// The ARN of the dataset.
	DatasetArn *string

	// The name of the dataset.
	DatasetName *string

	// The S3 URI where the dataset is stored.
	DatasetS3Uri *string

	// The dataset type (training data or test data).
	DatasetType DatasetType

	// Description of the dataset.
	Description *string

	// Time when the data from the dataset becomes available in the data lake.
	EndTime *time.Time

	// A description of the status of the dataset.
	Message *string

	// The number of documents in the dataset.
	NumberOfDocuments *int64

	// The dataset status. While the system creates the dataset, the status is CREATING
	// . When the dataset is ready to use, the status changes to COMPLETED .
	Status DatasetStatus

	noSmithyDocumentSerde
}

// Specifies the class that categorizes the document being analyzed
type DocumentClass struct {

	// The name of the class.
	Name *string

	// Page number in the input document. This field is present in the response only
	// if your request includes the Byte parameter.
	Page *int32

	// The confidence score that Amazon Comprehend has this class correctly attributed.
	Score *float32

	noSmithyDocumentSerde
}

// Configuration required for a document classification model.
type DocumentClassificationConfig struct {

	// Classification mode indicates whether the documents are MULTI_CLASS or
	// MULTI_LABEL .
	//
	// This member is required.
	Mode DocumentClassifierMode

	// One or more labels to associate with the custom classifier.
	Labels []string

	noSmithyDocumentSerde
}

// Provides information for filtering a list of document classification jobs. For
// more information, see the operation. You can provide only one filter parameter
// in each request.
type DocumentClassificationJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list based on job status. Returns only jobs with the specified
	// status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a document classification job.
type DocumentClassificationJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string

	// The time that the document classification job completed.
	EndTime *time.Time

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string

	// The input data configuration that you supplied when you created the document
	// classification job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the document classification job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format of the
	// ARN is as follows: arn::comprehend:::document-classification-job/ The following
	// is an example job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the document classification job.
	JobId *string

	// The name that you assigned to the document classification job.
	JobName *string

	// The current status of the document classification job. If the status is FAILED ,
	// the Message field shows the reason for the failure.
	JobStatus JobStatus

	// A description of the status of the job.
	Message *string

	// The output data configuration that you supplied when you created the document
	// classification job.
	OutputDataConfig *OutputDataConfig

	// The time that the document classification job was submitted for processing.
	SubmitTime *time.Time

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your document classification job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The location of the training documents. This parameter is required in a request
// to create a semi-structured document classification model.
type DocumentClassifierDocuments struct {

	// The S3 URI location of the training documents specified in the S3Uri CSV file.
	//
	// This member is required.
	S3Uri *string

	// The S3 URI location of the test documents included in the TestS3Uri CSV file.
	// This field is not required if you do not specify a test CSV file.
	TestS3Uri *string

	noSmithyDocumentSerde
}

// Provides information for filtering a list of document classifiers. You can only
// specify one filtering parameter in a request. For more information, see the
// ListDocumentClassifiers operation.
type DocumentClassifierFilter struct {

	// The name that you assigned to the document classifier
	DocumentClassifierName *string

	// Filters the list of classifiers based on status.
	Status ModelStatus

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted after the specified
	// time. Classifiers are returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted before the
	// specified time. Classifiers are returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// The input properties for training a document classifier. For more information
// on how the input file is formatted, see Preparing training data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html)
// in the Comprehend Developer Guide.
type DocumentClassifierInputDataConfig struct {

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth. This parameter is required if you set DataFormat
	// to AUGMENTED_MANIFEST .
	AugmentedManifests []AugmentedManifestsListItem

	// The format of your training data:
	//   - COMPREHEND_CSV : A two-column CSV file, where labels are provided in the
	//   first column, and documents are provided in the second. If you use this value,
	//   you must provide the S3Uri parameter in your request.
	//   - AUGMENTED_MANIFEST : A labeled dataset that is produced by Amazon SageMaker
	//   Ground Truth. This file is in JSON lines format. Each line is a complete JSON
	//   object that contains a training document and its associated labels. If you use
	//   this value, you must provide the AugmentedManifests parameter in your request.
	// If you don't specify a value, Amazon Comprehend uses COMPREHEND_CSV as the
	// default.
	DataFormat DocumentClassifierDataFormat

	// Provides configuration parameters to override the default actions for
	// extracting text from PDF documents and image files. By default, Amazon
	// Comprehend performs the following actions to extract text from files, based on
	// the input file type:
	//   - Word files - Amazon Comprehend parser extracts the text.
	//   - Digital PDF files - Amazon Comprehend parser extracts the text.
	//   - Image files and scanned PDF files - Amazon Comprehend uses the Amazon
	//   Textract DetectDocumentText API to extract the text.
	// DocumentReaderConfig does not apply to plain text files or Word files. For
	// image files and PDF documents, you can override these default actions using the
	// fields listed below. For more information, see Setting text extraction options (https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html)
	// in the Comprehend Developer Guide.
	DocumentReaderConfig *DocumentReaderConfig

	// The type of input documents for training the model. Provide plain-text
	// documents to create a plain-text model, and provide semi-structured documents to
	// create a native document model.
	DocumentType DocumentClassifierDocumentTypeFormat

	// The S3 location of the training documents. This parameter is required in a
	// request to create a native document model.
	Documents *DocumentClassifierDocuments

	// Indicates the delimiter used to separate each label for training a multi-label
	// classifier. The default delimiter between labels is a pipe (|). You can use a
	// different character as a delimiter (if it's an allowed character) by specifying
	// it under Delimiter for labels. If the training documents use a delimiter other
	// than the default or the delimiter you specify, the labels on that line will be
	// combined to make a single unique label, such as LABELLABELLABEL.
	LabelDelimiter *string

	// The Amazon S3 URI for the input data. The S3 bucket must be in the same Region
	// as the API endpoint that you are calling. The URI can point to a single input
	// file or it can provide the prefix for a collection of input files. For example,
	// if you use the URI S3://bucketName/prefix , if the prefix is a single file,
	// Amazon Comprehend uses that file as input. If more than one file begins with the
	// prefix, Amazon Comprehend uses all of them as input. This parameter is required
	// if you set DataFormat to COMPREHEND_CSV .
	S3Uri *string

	// This specifies the Amazon S3 location that contains the test annotations for
	// the document classifier. The URI must be in the same Amazon Web Services Region
	// as the API endpoint that you are calling.
	TestS3Uri *string

	noSmithyDocumentSerde
}

// Provide the location for output data from a custom classifier job. This field
// is mandatory if you are training a native document model.
type DocumentClassifierOutputDataConfig struct {

	// The Amazon S3 prefix for the data lake location of the flywheel statistics.
	FlywheelStatsS3Prefix *string

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId
	// can be one of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - KMS Key Alias: "alias/ExampleAlias"
	//   - ARN of a KMS Key Alias:
	//   "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string

	// When you use the OutputDataConfig object while creating a custom classifier,
	// you specify the Amazon S3 location where you want to write the confusion matrix
	// and other output files. The URI must be in the same Region as the API endpoint
	// that you are calling. The location is used as the prefix for the actual location
	// of this output file. When the custom classifier job is finished, the service
	// creates the output file in a directory specific to the job. The S3Uri field
	// contains the location of the output file, called output.tar.gz . It is a
	// compressed archive that contains the confusion matrix.
	S3Uri *string

	noSmithyDocumentSerde
}

// Provides information about a document classifier.
type DocumentClassifierProperties struct {

	// Information about the document classifier, including the number of documents
	// used for training the classifier, the number of documents used for test the
	// classifier, and an accuracy rating.
	ClassifierMetadata *ClassifierMetadata

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string

	// The time that training the document classifier completed.
	EndTime *time.Time

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string

	// The input data configuration that you supplied when you created the document
	// classifier for training.
	InputDataConfig *DocumentClassifierInputDataConfig

	// The language code for the language of the documents that the classifier was
	// trained on.
	LanguageCode LanguageCode

	// Additional information about the status of the classifier.
	Message *string

	// Indicates the mode in which the specific classifier was trained. This also
	// indicates the format of input documents and the format of the confusion matrix.
	// Each classifier can only be trained in one mode and this cannot be changed once
	// the classifier is trained.
	Mode DocumentClassifierMode

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string

	// Provides output results configuration parameters for custom classifier jobs.
	OutputDataConfig *DocumentClassifierOutputDataConfig

	// The Amazon Resource Name (ARN) of the source model. This model was imported
	// from a different Amazon Web Services account to create the document classifier
	// model in your Amazon Web Services account.
	SourceModelArn *string

	// The status of the document classifier. If the status is TRAINED the classifier
	// is ready to use. If the status is TRAINED_WITH_WARNINGS the classifier training
	// succeeded, but you should review the warnings returned in the
	// CreateDocumentClassifier response. If the status is FAILED you can see
	// additional information about why the classifier wasn't trained in the Message
	// field.
	Status ModelStatus

	// The time that the document classifier was submitted for training.
	SubmitTime *time.Time

	// The time that training of the document classifier was completed. Indicates the
	// time when the training completes on documentation classifiers. You are billed
	// for the time interval between this time and the value of TrainingStartTime.
	TrainingEndTime *time.Time

	// Indicates the time when the training starts on documentation classifiers. You
	// are billed for the time interval between this time and the value of
	// TrainingEndTime.
	TrainingStartTime *time.Time

	// The version name that you assigned to the document classifier.
	VersionName *string

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom classifier. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Describes information about a document classifier and its versions.
type DocumentClassifierSummary struct {

	// The name that you assigned the document classifier.
	DocumentClassifierName *string

	// The time that the latest document classifier version was submitted for
	// processing.
	LatestVersionCreatedAt *time.Time

	// The version name you assigned to the latest document classifier version.
	LatestVersionName *string

	// Provides the status of the latest document classifier version.
	LatestVersionStatus ModelStatus

	// The number of versions you created.
	NumberOfVersions *int32

	noSmithyDocumentSerde
}

// Specifies one of the label or labels that categorize the document being
// analyzed.
type DocumentLabel struct {

	// The name of the label.
	Name *string

	// Page number where the label occurs. This field is present in the response only
	// if your request includes the Byte parameter.
	Page *int32

	// The confidence score that Amazon Comprehend has this label correctly attributed.
	Score *float32

	noSmithyDocumentSerde
}

// Information about the document, discovered during text extraction.
type DocumentMetadata struct {

	// List of pages in the document, with the number of characters extracted from
	// each page.
	ExtractedCharacters []ExtractedCharactersListItem

	// Number of pages in the document.
	Pages *int32

	noSmithyDocumentSerde
}

// Provides configuration parameters to override the default actions for
// extracting text from PDF documents and image files. By default, Amazon
// Comprehend performs the following actions to extract text from files, based on
// the input file type:
//   - Word files - Amazon Comprehend parser extracts the text.
//   - Digital PDF files - Amazon Comprehend parser extracts the text.
//   - Image files and scanned PDF files - Amazon Comprehend uses the Amazon
//     Textract DetectDocumentText API to extract the text.
//
// DocumentReaderConfig does not apply to plain text files or Word files. For
// image files and PDF documents, you can override these default actions using the
// fields listed below. For more information, see Setting text extraction options (https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html)
// in the Comprehend Developer Guide.
type DocumentReaderConfig struct {

	// This field defines the Amazon Textract API operation that Amazon Comprehend
	// uses to extract text from PDF files and image files. Enter one of the following
	// values:
	//   - TEXTRACT_DETECT_DOCUMENT_TEXT - The Amazon Comprehend service uses the
	//   DetectDocumentText API operation.
	//   - TEXTRACT_ANALYZE_DOCUMENT - The Amazon Comprehend service uses the
	//   AnalyzeDocument API operation.
	//
	// This member is required.
	DocumentReadAction DocumentReadAction

	// Determines the text extraction actions for PDF files. Enter one of the
	// following values:
	//   - SERVICE_DEFAULT - use the Amazon Comprehend service defaults for PDF files.
	//   - FORCE_DOCUMENT_READ_ACTION - Amazon Comprehend uses the Textract API
	//   specified by DocumentReadAction for all PDF files, including digital PDF files.
	DocumentReadMode DocumentReadMode

	// Specifies the type of Amazon Textract features to apply. If you chose
	// TEXTRACT_ANALYZE_DOCUMENT as the read action, you must specify one or both of
	// the following values:
	//   - TABLES - Returns additional information about any tables that are detected
	//   in the input document.
	//   - FORMS - Returns additional information about any forms that are detected in
	//   the input document.
	FeatureTypes []DocumentReadFeatureTypes

	noSmithyDocumentSerde
}

// Document type for each page in the document.
type DocumentTypeListItem struct {

	// Page number.
	Page *int32

	// Document type.
	Type DocumentType

	noSmithyDocumentSerde
}

// Returns the code for the dominant language in the input text and the level of
// confidence that Amazon Comprehend has in the accuracy of the detection.
type DominantLanguage struct {

	// The RFC 5646 language code for the dominant language. For more information
	// about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	LanguageCode *string

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float32

	noSmithyDocumentSerde
}

// Provides information for filtering a list of dominant language detection jobs.
// For more information, see the operation.
type DominantLanguageDetectionJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a dominant language detection job.
type DominantLanguageDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the dominant language detection job completed.
	EndTime *time.Time

	// The input data configuration that you supplied when you created the dominant
	// language detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the dominant language detection job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format of the
	// ARN is as follows: arn::comprehend:::dominant-language-detection-job/ The
	// following is an example job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the dominant language detection job.
	JobId *string

	// The name that you assigned to the dominant language detection job.
	JobName *string

	// The current status of the dominant language detection job. If the status is
	// FAILED , the Message field shows the reason for the failure.
	JobStatus JobStatus

	// A description for the status of a job.
	Message *string

	// The output data configuration that you supplied when you created the dominant
	// language detection job.
	OutputDataConfig *OutputDataConfig

	// The time that the dominant language detection job was submitted for processing.
	SubmitTime *time.Time

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your dominant language detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The filter used to determine which endpoints are returned. You can filter jobs
// on their name, model, status, or the date and time that they were created. You
// can only set one filter at a time.
type EndpointFilter struct {

	// Specifies a date after which the returned endpoint or endpoints were created.
	CreationTimeAfter *time.Time

	// Specifies a date before which the returned endpoint or endpoints were created.
	CreationTimeBefore *time.Time

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string

	// Specifies the status of the endpoint being returned. Possible values are:
	// Creating, Ready, Updating, Deleting, Failed.
	Status EndpointStatus

	noSmithyDocumentSerde
}

// Specifies information about the specified endpoint. For information about
// endpoints, see Managing endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html)
// .
type EndpointProperties struct {

	// The creation date and time of the endpoint.
	CreationTime *time.Time

	// The number of inference units currently used by the model using this endpoint.
	CurrentInferenceUnits *int32

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to trained custom models encrypted with a customer managed key
	// (ModelKmsKeyId).
	DataAccessRoleArn *string

	// Data access role ARN to use in case the new model is encrypted with a customer
	// KMS key.
	DesiredDataAccessRoleArn *string

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters per
	// second.
	DesiredInferenceUnits *int32

	// ARN of the new model to use for updating an existing endpoint. This ARN is
	// going to be different from the model ARN when the update is in progress
	DesiredModelArn *string

	// The Amazon Resource Number (ARN) of the endpoint.
	EndpointArn *string

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string

	// The date and time that the endpoint was last modified.
	LastModifiedTime *time.Time

	// Specifies a reason for failure in cases of Failed status.
	Message *string

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string

	// Specifies the status of the endpoint. Because the endpoint updates and creation
	// are asynchronous, so customers will need to wait for the endpoint to be Ready
	// status before making inference requests.
	Status EndpointStatus

	noSmithyDocumentSerde
}

// Provides information for filtering a list of dominant language detection jobs.
// For more information, see the operation.
type EntitiesDetectionJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about an entities detection job.
type EntitiesDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the entities detection job completed
	EndTime *time.Time

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string

	// The Amazon Resource Name (ARN) of the flywheel associated with this job.
	FlywheelArn *string

	// The input data configuration that you supplied when you created the entities
	// detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the entities detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN is as
	// follows: arn::comprehend:::entities-detection-job/ The following is an example
	// job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the entities detection job.
	JobId *string

	// The name that you assigned the entities detection job.
	JobName *string

	// The current status of the entities detection job. If the status is FAILED , the
	// Message field shows the reason for the failure.
	JobStatus JobStatus

	// The language code of the input documents.
	LanguageCode LanguageCode

	// A description of the status of a job.
	Message *string

	// The output data configuration that you supplied when you created the entities
	// detection job.
	OutputDataConfig *OutputDataConfig

	// The time that the entities detection job was submitted for processing.
	SubmitTime *time.Time

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your entity detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Provides information about an entity.
type Entity struct {

	// The zero-based offset from the beginning of the source text to the first
	// character in the entity. This field is empty for non-text input.
	BeginOffset *int32

	// A reference to each block for this entity. This field is empty for plain-text
	// input.
	BlockReferences []BlockReference

	// The zero-based offset from the beginning of the source text to the last
	// character in the entity. This field is empty for non-text input.
	EndOffset *int32

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float32

	// The text of the entity.
	Text *string

	// The entity type. For entity detection using the built-in model, this field
	// contains one of the standard entity types listed below. For custom entity
	// detection, this field contains one of the entity types that you specified when
	// you trained your custom model.
	Type EntityType

	noSmithyDocumentSerde
}

// Specifies one of the label or labels that categorize the personally
// identifiable information (PII) entity being analyzed.
type EntityLabel struct {

	// The name of the label.
	Name PiiEntityType

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float32

	noSmithyDocumentSerde
}

// Configuration required for an entity recognition model.
type EntityRecognitionConfig struct {

	// Up to 25 entity types that the model is trained to recognize.
	//
	// This member is required.
	EntityTypes []EntityTypesListItem

	noSmithyDocumentSerde
}

// Describes the annotations associated with a entity recognizer.
type EntityRecognizerAnnotations struct {

	// Specifies the Amazon S3 location where the annotations for an entity recognizer
	// are located. The URI must be in the same Region as the API endpoint that you are
	// calling.
	//
	// This member is required.
	S3Uri *string

	// Specifies the Amazon S3 location where the test annotations for an entity
	// recognizer are located. The URI must be in the same Region as the API endpoint
	// that you are calling.
	TestS3Uri *string

	noSmithyDocumentSerde
}

// Describes the training documents submitted with an entity recognizer.
type EntityRecognizerDocuments struct {

	// Specifies the Amazon S3 location where the training documents for an entity
	// recognizer are located. The URI must be in the same Region as the API endpoint
	// that you are calling.
	//
	// This member is required.
	S3Uri *string

	// Specifies how the text in an input file should be processed. This is optional,
	// and the default is ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered
	// a separate document. Use this option when you are processing large documents,
	// such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line in
	// a file is considered a separate document. Use this option when you are
	// processing many short documents, such as text messages.
	InputFormat InputFormat

	// Specifies the Amazon S3 location where the test documents for an entity
	// recognizer are located. The URI must be in the same Amazon Web Services Region
	// as the API endpoint that you are calling.
	TestS3Uri *string

	noSmithyDocumentSerde
}

// Describes the entity list submitted with an entity recognizer.
type EntityRecognizerEntityList struct {

	// Specifies the Amazon S3 location where the entity list is located. The URI must
	// be in the same Region as the API endpoint that you are calling.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Detailed information about the accuracy of an entity recognizer.
type EntityRecognizerEvaluationMetrics struct {

	// A measure of how accurate the recognizer results are for the test data. It is
	// derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. For plain text entity recognizer models, the range is
	// 0 to 100, where 100 is the best score. For PDF/Word entity recognizer models,
	// the range is 0 to 1, where 1 is the best score.
	F1Score *float64

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant results
	// than irrelevant ones.
	Precision *float64

	// A measure of how complete the recognizer results are for the test data. High
	// recall means that the recognizer returned most of the relevant results.
	Recall *float64

	noSmithyDocumentSerde
}

// Provides information for filtering a list of entity recognizers. You can only
// specify one filtering parameter in a request. For more information, see the
// ListEntityRecognizers operation./>
type EntityRecognizerFilter struct {

	// The name that you assigned the entity recognizer.
	RecognizerName *string

	// The status of an entity recognizer.
	Status ModelStatus

	// Filters the list of entities based on the time that the list was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time

	// Filters the list of entities based on the time that the list was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Specifies the format and location of the input data.
type EntityRecognizerInputDataConfig struct {

	// The entity types in the labeled training data that Amazon Comprehend uses to
	// train the custom entity recognizer. Any entity types that you don't specify are
	// ignored. A maximum of 25 entity types can be used at one time to train an entity
	// recognizer. Entity types must not contain the following invalid characters: \n
	// (line break), \\n (escaped line break), \r (carriage return), \\r (escaped
	// carriage return), \t (tab), \\t (escaped tab), space, and , (comma).
	//
	// This member is required.
	EntityTypes []EntityTypesListItem

	// The S3 location of the CSV file that annotates your training documents.
	Annotations *EntityRecognizerAnnotations

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth. This parameter is required if you set DataFormat
	// to AUGMENTED_MANIFEST .
	AugmentedManifests []AugmentedManifestsListItem

	// The format of your training data:
	//   - COMPREHEND_CSV : A CSV file that supplements your training documents. The
	//   CSV file contains information about the custom entities that your trained model
	//   will detect. The required format of the file depends on whether you are
	//   providing annotations or an entity list. If you use this value, you must provide
	//   your CSV file by using either the Annotations or EntityList parameters. You
	//   must provide your training documents by using the Documents parameter.
	//   - AUGMENTED_MANIFEST : A labeled dataset that is produced by Amazon SageMaker
	//   Ground Truth. This file is in JSON lines format. Each line is a complete JSON
	//   object that contains a training document and its labels. Each label annotates a
	//   named entity in the training document. If you use this value, you must provide
	//   the AugmentedManifests parameter in your request.
	// If you don't specify a value, Amazon Comprehend uses COMPREHEND_CSV as the
	// default.
	DataFormat EntityRecognizerDataFormat

	// The S3 location of the folder that contains the training documents for your
	// custom entity recognizer. This parameter is required if you set DataFormat to
	// COMPREHEND_CSV .
	Documents *EntityRecognizerDocuments

	// The S3 location of the CSV file that has the entity list for your custom entity
	// recognizer.
	EntityList *EntityRecognizerEntityList

	noSmithyDocumentSerde
}

// Detailed information about an entity recognizer.
type EntityRecognizerMetadata struct {

	// Entity types from the metadata of an entity recognizer.
	EntityTypes []EntityRecognizerMetadataEntityTypesListItem

	// Detailed information about the accuracy of an entity recognizer.
	EvaluationMetrics *EntityRecognizerEvaluationMetrics

	// The number of documents in the input data that were used to test the entity
	// recognizer. Typically this is 10 to 20 percent of the input documents.
	NumberOfTestDocuments *int32

	// The number of documents in the input data that were used to train the entity
	// recognizer. Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int32

	noSmithyDocumentSerde
}

// Individual item from the list of entity types in the metadata of an entity
// recognizer.
type EntityRecognizerMetadataEntityTypesListItem struct {

	// Detailed information about the accuracy of the entity recognizer for a specific
	// item on the list of entity types.
	EvaluationMetrics *EntityTypesEvaluationMetrics

	// Indicates the number of times the given entity type was seen in the training
	// data.
	NumberOfTrainMentions *int32

	// Type of entity from the list of entity types in the metadata of an entity
	// recognizer.
	Type *string

	noSmithyDocumentSerde
}

// Output data configuration.
type EntityRecognizerOutputDataConfig struct {

	// The Amazon S3 prefix for the data lake location of the flywheel statistics.
	FlywheelStatsS3Prefix *string

	noSmithyDocumentSerde
}

// Describes information about an entity recognizer.
type EntityRecognizerProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the recognizer creation completed.
	EndTime *time.Time

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string

	// The input data properties of an entity recognizer.
	InputDataConfig *EntityRecognizerInputDataConfig

	// The language of the input documents. All documents must be in the same
	// language. Only English ("en") is currently supported.
	LanguageCode LanguageCode

	// A description of the status of the recognizer.
	Message *string

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string

	// Output data configuration.
	OutputDataConfig *EntityRecognizerOutputDataConfig

	// Provides information about an entity recognizer.
	RecognizerMetadata *EntityRecognizerMetadata

	// The Amazon Resource Name (ARN) of the source model. This model was imported
	// from a different Amazon Web Services account to create the entity recognizer
	// model in your Amazon Web Services account.
	SourceModelArn *string

	// Provides the status of the entity recognizer.
	Status ModelStatus

	// The time that the recognizer was submitted for processing.
	SubmitTime *time.Time

	// The time that training of the entity recognizer was completed.
	TrainingEndTime *time.Time

	// The time that training of the entity recognizer started.
	TrainingStartTime *time.Time

	// The version name you assigned to the entity recognizer.
	VersionName *string

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom entity recognizer. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Describes the information about an entity recognizer and its versions.
type EntityRecognizerSummary struct {

	// The time that the latest entity recognizer version was submitted for processing.
	LatestVersionCreatedAt *time.Time

	// The version name you assigned to the latest entity recognizer version.
	LatestVersionName *string

	// Provides the status of the latest entity recognizer version.
	LatestVersionStatus ModelStatus

	// The number of versions you created.
	NumberOfVersions *int32

	// The name that you assigned the entity recognizer.
	RecognizerName *string

	noSmithyDocumentSerde
}

// Detailed information about the accuracy of an entity recognizer for a specific
// entity type.
type EntityTypesEvaluationMetrics struct {

	// A measure of how accurate the recognizer results are for a specific entity type
	// in the test data. It is derived from the Precision and Recall values. The
	// F1Score is the harmonic average of the two scores. The highest score is 1, and
	// the worst score is 0.
	F1Score *float64

	// A measure of the usefulness of the recognizer results for a specific entity
	// type in the test data. High precision means that the recognizer returned
	// substantially more relevant results than irrelevant ones.
	Precision *float64

	// A measure of how complete the recognizer results are for a specific entity type
	// in the test data. High recall means that the recognizer returned most of the
	// relevant results.
	Recall *float64

	noSmithyDocumentSerde
}

// An entity type within a labeled training dataset that Amazon Comprehend uses to
// train a custom entity recognizer.
type EntityTypesListItem struct {

	// An entity type within a labeled training dataset that Amazon Comprehend uses to
	// train a custom entity recognizer. Entity types must not contain the following
	// invalid characters: \n (line break), \\n (escaped line break, \r (carriage
	// return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), and ,
	// (comma).
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Text extraction encountered one or more page-level errors in the input
// document. The ErrorCode contains one of the following values:
//   - TEXTRACT_BAD_PAGE - Amazon Textract cannot read the page. For more
//     information about page limits in Amazon Textract, see Page Quotas in Amazon
//     Textract (https://docs.aws.amazon.com/textract/latest/dg/limits-document.html)
//     .
//   - TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED - The number of requests exceeded
//     your throughput limit. For more information about throughput quotas in Amazon
//     Textract, see Default quotas in Amazon Textract (https://docs.aws.amazon.com/textract/latest/dg/limits-quotas-explained.html)
//     .
//   - PAGE_CHARACTERS_EXCEEDED - Too many text characters on the page (10,000
//     characters maximum).
//   - PAGE_SIZE_EXCEEDED - The maximum page size is 10 MB.
//   - INTERNAL_SERVER_ERROR - The request encountered a service issue. Try the
//     API request again.
type ErrorsListItem struct {

	// Error code for the cause of the error.
	ErrorCode PageBasedErrorCode

	// Text message explaining the reason for the error.
	ErrorMessage *string

	// Page number where the error occurred.
	Page *int32

	noSmithyDocumentSerde
}

// Provides information for filtering a list of event detection jobs.
type EventsDetectionJobFilter struct {

	// Filters on the name of the events detection job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about an events detection job.
type EventsDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the events detection job completed.
	EndTime *time.Time

	// The input data configuration that you supplied when you created the events
	// detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the events detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN is as
	// follows: arn::comprehend:::events-detection-job/ The following is an example
	// job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the events detection job.
	JobId *string

	// The name you assigned the events detection job.
	JobName *string

	// The current status of the events detection job.
	JobStatus JobStatus

	// The language code of the input documents.
	LanguageCode LanguageCode

	// A description of the status of the events detection job.
	Message *string

	// The output data configuration that you supplied when you created the events
	// detection job.
	OutputDataConfig *OutputDataConfig

	// The time that the events detection job was submitted for processing.
	SubmitTime *time.Time

	// The types of events that are detected by the job.
	TargetEventTypes []string

	noSmithyDocumentSerde
}

// Array of the number of characters extracted from each page.
type ExtractedCharactersListItem struct {

	// Number of characters extracted from each page.
	Count *int32

	// Page number.
	Page *int32

	noSmithyDocumentSerde
}

// Filter the flywheels based on creation time or flywheel status.
type FlywheelFilter struct {

	// Filter the flywheels to include flywheels created after the specified time.
	CreationTimeAfter *time.Time

	// Filter the flywheels to include flywheels created before the specified time.
	CreationTimeBefore *time.Time

	// Filter the flywheels based on the flywheel status.
	Status FlywheelStatus

	noSmithyDocumentSerde
}

// Filter the flywheel iterations based on creation time.
type FlywheelIterationFilter struct {

	// Filter the flywheel iterations to include iterations created after the
	// specified time.
	CreationTimeAfter *time.Time

	// Filter the flywheel iterations to include iterations created before the
	// specified time.
	CreationTimeBefore *time.Time

	noSmithyDocumentSerde
}

// The configuration properties of a flywheel iteration.
type FlywheelIterationProperties struct {

	// The creation start time of the flywheel iteration.
	CreationTime *time.Time

	// The completion time of this flywheel iteration.
	EndTime *time.Time

	// The ARN of the evaluated model associated with this flywheel iteration.
	EvaluatedModelArn *string

	// The evaluation metrics associated with the evaluated model.
	EvaluatedModelMetrics *FlywheelModelEvaluationMetrics

	//
	EvaluationManifestS3Prefix *string

	//
	FlywheelArn *string

	//
	FlywheelIterationId *string

	// A description of the status of the flywheel iteration.
	Message *string

	// The status of the flywheel iteration.
	Status FlywheelIterationStatus

	// The ARN of the trained model associated with this flywheel iteration.
	TrainedModelArn *string

	// The metrics associated with the trained model.
	TrainedModelMetrics *FlywheelModelEvaluationMetrics

	noSmithyDocumentSerde
}

// The evaluation metrics associated with the evaluated model.
type FlywheelModelEvaluationMetrics struct {

	// Average accuracy metric for the model.
	AverageAccuracy *float64

	// The average F1 score from the evaluation metrics.
	AverageF1Score *float64

	// Average precision metric for the model.
	AveragePrecision *float64

	// Average recall metric for the model.
	AverageRecall *float64

	noSmithyDocumentSerde
}

// The flywheel properties.
type FlywheelProperties struct {

	// The Amazon Resource Number (ARN) of the active model version.
	ActiveModelArn *string

	// Creation time of the flywheel.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// permission to access the flywheel data.
	DataAccessRoleArn *string

	// Amazon S3 URI of the data lake location.
	DataLakeS3Uri *string

	// Data security configuration.
	DataSecurityConfig *DataSecurityConfig

	// The Amazon Resource Number (ARN) of the flywheel.
	FlywheelArn *string

	// Last modified time for the flywheel.
	LastModifiedTime *time.Time

	// The most recent flywheel iteration.
	LatestFlywheelIteration *string

	// A description of the status of the flywheel.
	Message *string

	// Model type of the flywheel's model.
	ModelType ModelType

	// The status of the flywheel.
	Status FlywheelStatus

	// Configuration about the model associated with a flywheel.
	TaskConfig *TaskConfig

	noSmithyDocumentSerde
}

// Flywheel summary information.
type FlywheelSummary struct {

	// ARN of the active model version for the flywheel.
	ActiveModelArn *string

	// Creation time of the flywheel.
	CreationTime *time.Time

	// Amazon S3 URI of the data lake location.
	DataLakeS3Uri *string

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string

	// Last modified time for the flywheel.
	LastModifiedTime *time.Time

	// The most recent flywheel iteration.
	LatestFlywheelIteration *string

	// A description of the status of the flywheel.
	Message *string

	// Model type of the flywheel's model.
	ModelType ModelType

	// The status of the flywheel.
	Status FlywheelStatus

	noSmithyDocumentSerde
}

// Information about the location of items on a document page. For additional
// information, see Geometry (https://docs.aws.amazon.com/textract/latest/dg/API_Geometry.html)
// in the Amazon Textract API reference.
type Geometry struct {

	// An axis-aligned coarse representation of the location of the recognized item on
	// the document page.
	BoundingBox *BoundingBox

	// Within the bounding box, a fine-grained polygon around the recognized item.
	Polygon []Point

	noSmithyDocumentSerde
}

// The input properties for an inference job. The document reader config field
// applies only to non-text inputs for custom analysis.
type InputDataConfig struct {

	// The Amazon S3 URI for the input data. The URI must be in same Region as the API
	// endpoint that you are calling. The URI can point to a single input file or it
	// can provide the prefix for a collection of data files. For example, if you use
	// the URI S3://bucketName/prefix , if the prefix is a single file, Amazon
	// Comprehend uses that file as input. If more than one file begins with the
	// prefix, Amazon Comprehend uses all of them as input.
	//
	// This member is required.
	S3Uri *string

	// Provides configuration parameters to override the default actions for
	// extracting text from PDF documents and image files.
	DocumentReaderConfig *DocumentReaderConfig

	// Specifies how the text in an input file should be processed:
	//   - ONE_DOC_PER_FILE - Each file is considered a separate document. Use this
	//   option when you are processing large documents, such as newspaper articles or
	//   scientific papers.
	//   - ONE_DOC_PER_LINE - Each line in a file is considered a separate document.
	//   Use this option when you are processing many short documents, such as text
	//   messages.
	InputFormat InputFormat

	noSmithyDocumentSerde
}

// Provides additional detail about why the request failed.
type InvalidRequestDetail struct {

	// Reason codes include the following values:
	//   - DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your
	//   file and resubmit the request.
	//   - UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type
	//   and resubmit the request.
	//   - PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of
	//   pages in your file and resubmit the request.
	//   - TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your
	//   account has permission to use Amazon Textract API operations and resubmit the
	//   request.
	//   - NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the
	//   format and resubmit the request.
	//   - MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and
	//   resubmit the request.
	//   - INVALID_DOCUMENT - Invalid document. Check the file and resubmit the
	//   request.
	Reason InvalidRequestDetailReason

	noSmithyDocumentSerde
}

// Describes a key noun phrase.
type KeyPhrase struct {

	// The zero-based offset from the beginning of the source text to the first
	// character in the key phrase.
	BeginOffset *int32

	// The zero-based offset from the beginning of the source text to the last
	// character in the key phrase.
	EndOffset *int32

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float32

	// The text of a key noun phrase.
	Text *string

	noSmithyDocumentSerde
}

// Provides information for filtering a list of dominant language detection jobs.
// For more information, see the operation.
type KeyPhrasesDetectionJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a key phrases detection job.
type KeyPhrasesDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the key phrases detection job completed.
	EndTime *time.Time

	// The input data configuration that you supplied when you created the key phrases
	// detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the key phrases detection job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format of the
	// ARN is as follows: arn::comprehend:::key-phrases-detection-job/ The following
	// is an example job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the key phrases detection job.
	JobId *string

	// The name that you assigned the key phrases detection job.
	JobName *string

	// The current status of the key phrases detection job. If the status is FAILED ,
	// the Message field shows the reason for the failure.
	JobStatus JobStatus

	// The language code of the input documents.
	LanguageCode LanguageCode

	// A description of the status of a job.
	Message *string

	// The output data configuration that you supplied when you created the key
	// phrases detection job.
	OutputDataConfig *OutputDataConfig

	// The time that the key phrases detection job was submitted for processing.
	SubmitTime *time.Time

	// ID for the KMS key that Amazon Comprehend uses to encrypt data on the storage
	// volume attached to the ML compute instance(s) that process the analysis job. The
	// VolumeKmsKeyId can be either of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your key phrases detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Contains the sentiment and sentiment score for one mention of an entity. For
// more information about targeted sentiment, see Targeted sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html)
// in the Amazon Comprehend Developer Guide.
type MentionSentiment struct {

	// The sentiment of the mention.
	Sentiment SentimentType

	// Describes the level of confidence that Amazon Comprehend has in the accuracy of
	// its detection of sentiments.
	SentimentScore *SentimentScore

	noSmithyDocumentSerde
}

// Provides configuration parameters for the output of inference jobs.
type OutputDataConfig struct {

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The URI
	// must be in the same Region as the API endpoint that you are calling. The
	// location is used as the prefix for the actual location of the output file. When
	// the topic detection job is finished, the service creates an output file in a
	// directory specific to the job. The S3Uri field contains the location of the
	// output file, called output.tar.gz . It is a compressed archive that contains the
	// ouput of the operation. For a PII entity detection job, the output file is plain
	// text, not a compressed archive. The output file name is the same as the input
	// file, with .out appended at the end.
	//
	// This member is required.
	S3Uri *string

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt the output results from an analysis job. Specify the
	// Key Id of a symmetric key, because you cannot use an asymmetric key for
	// uploading data to S3. The KmsKeyId can be one of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - KMS Key Alias: "alias/ExampleAlias"
	//   - ARN of a KMS Key Alias:
	//   "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Identifies the part of speech represented by the token and gives the confidence
// that Amazon Comprehend has that the part of speech was correctly identified. For
// more information about the parts of speech that Amazon Comprehend can identify,
// see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
// in the Comprehend Developer Guide.
type PartOfSpeechTag struct {

	// The confidence that Amazon Comprehend has that the part of speech was correctly
	// identified.
	Score *float32

	// Identifies the part of speech that the token represents.
	Tag PartOfSpeechTagType

	noSmithyDocumentSerde
}

// Provides information for filtering a list of PII entity detection jobs.
type PiiEntitiesDetectionJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a PII entities detection job.
type PiiEntitiesDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the PII entities detection job completed.
	EndTime *time.Time

	// The input properties for a PII entities detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the PII entities detection job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format of the
	// ARN is as follows: arn::comprehend:::pii-entities-detection-job/ The following
	// is an example job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the PII entities detection job.
	JobId *string

	// The name that you assigned the PII entities detection job.
	JobName *string

	// The current status of the PII entities detection job. If the status is FAILED ,
	// the Message field shows the reason for the failure.
	JobStatus JobStatus

	// The language code of the input documents.
	LanguageCode LanguageCode

	// A description of the status of a job.
	Message *string

	// Specifies whether the output provides the locations (offsets) of PII entities
	// or a file in which PII entities are redacted.
	Mode PiiEntitiesDetectionMode

	// The output data configuration that you supplied when you created the PII
	// entities detection job.
	OutputDataConfig *PiiOutputDataConfig

	// Provides configuration parameters for PII entity redaction. This parameter is
	// required if you set the Mode parameter to ONLY_REDACTION . In that case, you
	// must provide a RedactionConfig definition that includes the PiiEntityTypes
	// parameter.
	RedactionConfig *RedactionConfig

	// The time that the PII entities detection job was submitted for processing.
	SubmitTime *time.Time

	noSmithyDocumentSerde
}

// Provides information about a PII entity.
type PiiEntity struct {

	// The zero-based offset from the beginning of the source text to the first
	// character in the entity.
	BeginOffset *int32

	// The zero-based offset from the beginning of the source text to the last
	// character in the entity.
	EndOffset *int32

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float32

	// The entity's type.
	Type PiiEntityType

	noSmithyDocumentSerde
}

// Provides configuration parameters for the output of PII entity detection jobs.
type PiiOutputDataConfig struct {

	// When you use the PiiOutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. For a
	// PII entity detection job, the output file is plain text, not a compressed
	// archive. The output file name is the same as the input file, with .out appended
	// at the end.
	//
	// This member is required.
	S3Uri *string

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt the output results from an analysis job.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The X and Y coordinates of a point on a document page. For additional
// information, see Point (https://docs.aws.amazon.com/textract/latest/dg/API_Point.html)
// in the Amazon Textract API reference.
type Point struct {

	// The value of the X coordinate for a point on a polygon
	X *float32

	// The value of the Y coordinate for a point on a polygon
	Y *float32

	noSmithyDocumentSerde
}

// Provides configuration parameters for PII entity redaction.
type RedactionConfig struct {

	// A character that replaces each character in the redacted PII entity.
	MaskCharacter *string

	// Specifies whether the PII entity is redacted with the mask character or the
	// entity type.
	MaskMode PiiEntitiesDetectionMaskMode

	// An array of the types of PII entities that Amazon Comprehend detects in the
	// input text for your request.
	PiiEntityTypes []PiiEntityType

	noSmithyDocumentSerde
}

// List of child blocks for the current block.
type RelationshipsListItem struct {

	// Identifers of the child blocks.
	Ids []string

	// Only supported relationship is a child relationship.
	Type RelationshipType

	noSmithyDocumentSerde
}

// Provides information for filtering a list of dominant language detection jobs.
// For more information, see the operation.
type SentimentDetectionJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a sentiment detection job.
type SentimentDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the sentiment detection job ended.
	EndTime *time.Time

	// The input data configuration that you supplied when you created the sentiment
	// detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN is as
	// follows: arn::comprehend:::sentiment-detection-job/ The following is an example
	// job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the sentiment detection job.
	JobId *string

	// The name that you assigned to the sentiment detection job
	JobName *string

	// The current status of the sentiment detection job. If the status is FAILED , the
	// Messages field shows the reason for the failure.
	JobStatus JobStatus

	// The language code of the input documents.
	LanguageCode LanguageCode

	// A description of the status of a job.
	Message *string

	// The output data configuration that you supplied when you created the sentiment
	// detection job.
	OutputDataConfig *OutputDataConfig

	// The time that the sentiment detection job was submitted for processing.
	SubmitTime *time.Time

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your sentiment detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Describes the level of confidence that Amazon Comprehend has in the accuracy of
// its detection of sentiments.
type SentimentScore struct {

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float32

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float32

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float32

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float32

	noSmithyDocumentSerde
}

// Represents a work in the input text that was recognized and assigned a part of
// speech. There is one syntax token record for each word in the source text.
type SyntaxToken struct {

	// The zero-based offset from the beginning of the source text to the first
	// character in the word.
	BeginOffset *int32

	// The zero-based offset from the beginning of the source text to the last
	// character in the word.
	EndOffset *int32

	// Provides the part of speech label and the confidence level that Amazon
	// Comprehend has that the part of speech was correctly identified. For more
	// information, see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
	// in the Comprehend Developer Guide.
	PartOfSpeech *PartOfSpeechTag

	// The word that was recognized in the source text.
	Text *string

	// A unique identifier for a token.
	TokenId *int32

	noSmithyDocumentSerde
}

// A key-value pair that adds as a metadata to a resource used by Amazon
// Comprehend. For example, a tag with the key-value pair ‘Department’:’Sales’
// might be added to a resource to indicate its use by a particular department.
type Tag struct {

	// The initial part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the key portion of the pair, with
	// multiple possible values such as “sales,” “legal,” and “administration.”
	//
	// This member is required.
	Key *string

	// The second part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the initial (key) portion of the
	// pair, with a value of “sales” to indicate the sales department.
	Value *string

	noSmithyDocumentSerde
}

// Provides information for filtering a list of dominant language detection jobs.
// For more information, see the ListTargetedSentimentDetectionJobs operation.
type TargetedSentimentDetectionJobFilter struct {

	// Filters on the name of the job.
	JobName *string

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a targeted sentiment detection job.
type TargetedSentimentDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string

	// The time that the targeted sentiment detection job ended.
	EndTime *time.Time

	// The input properties for an inference job. The document reader config field
	// applies only to non-text inputs for custom analysis.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the targeted sentiment detection job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format of the
	// ARN is as follows: arn::comprehend:::targeted-sentiment-detection-job/ The
	// following is an example job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:targeted-sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the targeted sentiment detection job.
	JobId *string

	// The name that you assigned to the targeted sentiment detection job.
	JobName *string

	// The current status of the targeted sentiment detection job. If the status is
	// FAILED , the Messages field shows the reason for the failure.
	JobStatus JobStatus

	// The language code of the input documents.
	LanguageCode LanguageCode

	// A description of the status of a job.
	Message *string

	// Provides configuration parameters for the output of inference jobs.
	OutputDataConfig *OutputDataConfig

	// The time that the targeted sentiment detection job was submitted for processing.
	SubmitTime *time.Time

	// ID for the KMS key that Amazon Comprehend uses to encrypt the data on the
	// storage volume attached to the ML compute instance(s) that process the targeted
	// sentiment detection job. The VolumeKmsKeyId can be either of the following
	// formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for the job. For more information, see
	// Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Information about one of the entities found by targeted sentiment analysis. For
// more information about targeted sentiment, see Targeted sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html)
// in the Amazon Comprehend Developer Guide.
type TargetedSentimentEntity struct {

	// One or more index into the Mentions array that provides the best name for the
	// entity group.
	DescriptiveMentionIndex []int32

	// An array of mentions of the entity in the document. The array represents a
	// co-reference group. See Co-reference group (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-values)
	// for an example.
	Mentions []TargetedSentimentMention

	noSmithyDocumentSerde
}

// Information about one mention of an entity. The mention information includes
// the location of the mention in the text and the sentiment of the mention. For
// more information about targeted sentiment, see Targeted sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html)
// in the Amazon Comprehend Developer Guide.
type TargetedSentimentMention struct {

	// The offset into the document text where the mention begins.
	BeginOffset *int32

	// The offset into the document text where the mention ends.
	EndOffset *int32

	// The confidence that all the entities mentioned in the group relate to the same
	// entity.
	GroupScore *float32

	// Contains the sentiment and sentiment score for the mention.
	MentionSentiment *MentionSentiment

	// Model confidence that the entity is relevant. Value range is zero to one, where
	// one is highest confidence.
	Score *float32

	// The text in the document that identifies the entity.
	Text *string

	// The type of the entity. Amazon Comprehend supports a variety of entity types (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-entities)
	// .
	Type TargetedSentimentEntityType

	noSmithyDocumentSerde
}

// Configuration about the model associated with a flywheel.
type TaskConfig struct {

	// Language code for the language that the model supports.
	//
	// This member is required.
	LanguageCode LanguageCode

	// Configuration required for a document classification model.
	DocumentClassificationConfig *DocumentClassificationConfig

	// Configuration required for an entity recognition model.
	EntityRecognitionConfig *EntityRecognitionConfig

	noSmithyDocumentSerde
}

// One of the of text strings. Each string has a size limit of 1KB.
type TextSegment struct {

	// The text content.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Provides information for filtering topic detection jobs. For more information,
// see .
type TopicsDetectionJobFilter struct {

	//
	JobName *string

	// Filters the list of topic detection jobs based on job status. Returns only jobs
	// with the specified status.
	JobStatus JobStatus

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time

	noSmithyDocumentSerde
}

// Provides information about a topic detection job.
type TopicsDetectionJobProperties struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your job data.
	DataAccessRoleArn *string

	// The time that the topic detection job was completed.
	EndTime *time.Time

	// The input data configuration supplied when you created the topic detection job.
	InputDataConfig *InputDataConfig

	// The Amazon Resource Name (ARN) of the topics detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN is as
	// follows: arn::comprehend:::topics-detection-job/ The following is an example
	// job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier assigned to the topic detection job.
	JobId *string

	// The name of the topic detection job.
	JobName *string

	// The current status of the topic detection job. If the status is Failed , the
	// reason for the failure is shown in the Message field.
	JobStatus JobStatus

	// A description for the status of a job.
	Message *string

	// The number of topics to detect supplied when you created the topic detection
	// job. The default is 10.
	NumberOfTopics *int32

	// The output data configuration supplied when you created the topic detection job.
	OutputDataConfig *OutputDataConfig

	// The time that the topic detection job was submitted for processing.
	SubmitTime *time.Time

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your topic detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Toxic content analysis result for one string. For more information about
// toxicity detection, see Toxicity detection (https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html)
// in the Amazon Comprehend Developer Guide
type ToxicContent struct {

	// The name of the toxic content type.
	Name ToxicContentType

	// Model confidence in the detected content type. Value range is zero to one,
	// where one is highest confidence.
	Score *float32

	noSmithyDocumentSerde
}

// Toxicity analysis result for one string. For more information about toxicity
// detection, see Toxicity detection (https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html)
// in the Amazon Comprehend Developer Guide.
type ToxicLabels struct {

	// Array of toxic content types identified in the string.
	Labels []ToxicContent

	// Overall toxicity score for the string. Value range is zero to one, where one is
	// the highest confidence.
	Toxicity *float32

	noSmithyDocumentSerde
}

// Data security configuration.
type UpdateDataSecurityConfig struct {

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string

	// ID for the KMS key that Amazon Comprehend uses to encrypt the volume.
	VolumeKmsKeyId *string

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for the job. For more information, see
	// Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Configuration parameters for an optional private Virtual Private Cloud (VPC)
// containing the resources you are using for the job. For more information, see
// Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
// .
type VpcConfig struct {

	// The ID number for a security group on an instance of your private VPC. Security
	// groups on your VPC function serve as a virtual firewall to control inbound and
	// outbound traffic and provides security for the resources that you’ll be
	// accessing on the VPC. This ID number is preceded by "sg-", for instance:
	// "sg-03b388029b0a285ea". For more information, see Security Groups for your VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
	// .
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID for each subnet being used in your private VPC. This subnet is a subset
	// of the a range of IPv4 addresses used by the VPC and is specific to a given
	// availability zone in the VPC’s Region. This ID number is preceded by "subnet-",
	// for instance: "subnet-04ccf456919e69055". For more information, see VPCs and
	// Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// The system identified one of the following warnings while processing the input
// document:
//   - The document to classify is plain text, but the classifier is a native
//     document model.
//   - The document to classify is semi-structured, but the classifier is a
//     plain-text model.
type WarningsListItem struct {

	// Page number in the input document.
	Page *int32

	// The type of warning.
	WarnCode PageBasedWarningCode

	// Text message associated with the warning.
	WarnMessage *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
