package powerbidedicated

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AutoScaleVCoresClient is the powerBI Dedicated Web API provides a RESTful set of web services that enables users to
// create, retrieve, update, and delete Power BI dedicated capacities
type AutoScaleVCoresClient struct {
	BaseClient
}

// NewAutoScaleVCoresClient creates an instance of the AutoScaleVCoresClient client.
func NewAutoScaleVCoresClient(subscriptionID string) AutoScaleVCoresClient {
	return NewAutoScaleVCoresClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAutoScaleVCoresClientWithBaseURI creates an instance of the AutoScaleVCoresClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAutoScaleVCoresClientWithBaseURI(baseURI string, subscriptionID string) AutoScaleVCoresClient {
	return AutoScaleVCoresClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create provisions the specified auto scale v-core based on the configuration specified in the request.
// Parameters:
// resourceGroupName - the name of the Azure Resource group of which a given PowerBIDedicated capacity is part.
// This name must be at least 1 character in length, and no more than 90.
// vcoreName - the name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
// vCoreParameters - contains the information used to provision the auto scale v-core.
func (client AutoScaleVCoresClient) Create(ctx context.Context, resourceGroupName string, vcoreName string, vCoreParameters AutoScaleVCore) (result AutoScaleVCore, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoScaleVCoresClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: vcoreName,
			Constraints: []validation.Constraint{{Target: "vcoreName", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "vcoreName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "vcoreName", Name: validation.Pattern, Rule: `^[-a-zA-Z0-9_]+$`, Chain: nil}}},
		{TargetValue: vCoreParameters,
			Constraints: []validation.Constraint{{Target: "vCoreParameters.Sku", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "vCoreParameters.Sku.Name", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("powerbidedicated.AutoScaleVCoresClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, vcoreName, vCoreParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client AutoScaleVCoresClient) CreatePreparer(ctx context.Context, resourceGroupName string, vcoreName string, vCoreParameters AutoScaleVCore) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vcoreName":         autorest.Encode("path", vcoreName),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}", pathParameters),
		autorest.WithJSON(vCoreParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client AutoScaleVCoresClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client AutoScaleVCoresClient) CreateResponder(resp *http.Response) (result AutoScaleVCore, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the specified auto scale v-core.
// Parameters:
// resourceGroupName - the name of the Azure Resource group of which a given PowerBIDedicated capacity is part.
// This name must be at least 1 character in length, and no more than 90.
// vcoreName - the name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
func (client AutoScaleVCoresClient) Delete(ctx context.Context, resourceGroupName string, vcoreName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoScaleVCoresClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: vcoreName,
			Constraints: []validation.Constraint{{Target: "vcoreName", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "vcoreName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "vcoreName", Name: validation.Pattern, Rule: `^[-a-zA-Z0-9_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("powerbidedicated.AutoScaleVCoresClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, vcoreName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AutoScaleVCoresClient) DeletePreparer(ctx context.Context, resourceGroupName string, vcoreName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vcoreName":         autorest.Encode("path", vcoreName),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AutoScaleVCoresClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AutoScaleVCoresClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets details about the specified auto scale v-core.
// Parameters:
// resourceGroupName - the name of the Azure Resource group of which a given PowerBIDedicated capacity is part.
// This name must be at least 1 character in length, and no more than 90.
// vcoreName - the name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
func (client AutoScaleVCoresClient) Get(ctx context.Context, resourceGroupName string, vcoreName string) (result AutoScaleVCore, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoScaleVCoresClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: vcoreName,
			Constraints: []validation.Constraint{{Target: "vcoreName", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "vcoreName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "vcoreName", Name: validation.Pattern, Rule: `^[-a-zA-Z0-9_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("powerbidedicated.AutoScaleVCoresClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, vcoreName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client AutoScaleVCoresClient) GetPreparer(ctx context.Context, resourceGroupName string, vcoreName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vcoreName":         autorest.Encode("path", vcoreName),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AutoScaleVCoresClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AutoScaleVCoresClient) GetResponder(resp *http.Response) (result AutoScaleVCore, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup gets all the auto scale v-cores for the given resource group.
// Parameters:
// resourceGroupName - the name of the Azure Resource group of which a given PowerBIDedicated capacity is part.
// This name must be at least 1 character in length, and no more than 90.
func (client AutoScaleVCoresClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result AutoScaleVCoreListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoScaleVCoresClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("powerbidedicated.AutoScaleVCoresClient", "ListByResourceGroup", err.Error())
	}

	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AutoScaleVCoresClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AutoScaleVCoresClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AutoScaleVCoresClient) ListByResourceGroupResponder(resp *http.Response) (result AutoScaleVCoreListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySubscription lists all the auto scale v-cores for the given subscription.
func (client AutoScaleVCoresClient) ListBySubscription(ctx context.Context) (result AutoScaleVCoreListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoScaleVCoresClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListBySubscriptionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "ListBySubscription", resp, "Failure responding to request")
		return
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client AutoScaleVCoresClient) ListBySubscriptionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PowerBIDedicated/autoScaleVCores", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client AutoScaleVCoresClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client AutoScaleVCoresClient) ListBySubscriptionResponder(resp *http.Response) (result AutoScaleVCoreListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates the current state of the specified auto scale v-core.
// Parameters:
// resourceGroupName - the name of the Azure Resource group of which a given PowerBIDedicated capacity is part.
// This name must be at least 1 character in length, and no more than 90.
// vcoreName - the name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
// vCoreUpdateParameters - request object that contains the updated information for the auto scale v-core.
func (client AutoScaleVCoresClient) Update(ctx context.Context, resourceGroupName string, vcoreName string, vCoreUpdateParameters AutoScaleVCoreUpdateParameters) (result AutoScaleVCore, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoScaleVCoresClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: vcoreName,
			Constraints: []validation.Constraint{{Target: "vcoreName", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "vcoreName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "vcoreName", Name: validation.Pattern, Rule: `^[-a-zA-Z0-9_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("powerbidedicated.AutoScaleVCoresClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, vcoreName, vCoreUpdateParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbidedicated.AutoScaleVCoresClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AutoScaleVCoresClient) UpdatePreparer(ctx context.Context, resourceGroupName string, vcoreName string, vCoreUpdateParameters AutoScaleVCoreUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vcoreName":         autorest.Encode("path", vcoreName),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}", pathParameters),
		autorest.WithJSON(vCoreUpdateParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AutoScaleVCoresClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AutoScaleVCoresClient) UpdateResponder(resp *http.Response) (result AutoScaleVCore, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
