/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	_context "context"
	"fmt"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// NATGatewaysApiService NATGatewaysApi service
type NATGatewaysApiService service

type ApiDatacentersNatgatewaysDeleteRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	datacenterId    string
	natGatewayId    string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysDeleteRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysDeleteRequest) Depth(depth int32) ApiDatacentersNatgatewaysDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysDeleteExecute(r)
}

/*
 * DatacentersNatgatewaysDelete Delete NAT Gateways
 * Remove the specified NAT Gateway from the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysDeleteRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysDelete(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysDeleteRequest {
	return ApiDatacentersNatgatewaysDeleteRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
	}
}

/*
 * Execute executes the request
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysDeleteExecute(r ApiDatacentersNatgatewaysDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFindByNatGatewayIdRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	datacenterId    string
	natGatewayId    string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysFindByNatGatewayIdRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFindByNatGatewayIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFindByNatGatewayIdRequest) Depth(depth int32) ApiDatacentersNatgatewaysFindByNatGatewayIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysFindByNatGatewayIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysFindByNatGatewayIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysFindByNatGatewayIdRequest) Execute() (NatGateway, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFindByNatGatewayIdExecute(r)
}

/*
 * DatacentersNatgatewaysFindByNatGatewayId Retrieve NAT Gateways
 * Retrieve the properties of the specified NAT Gateway within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysFindByNatGatewayIdRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFindByNatGatewayId(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysFindByNatGatewayIdRequest {
	return ApiDatacentersNatgatewaysFindByNatGatewayIdRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
	}
}

/*
 * Execute executes the request
 * @return NatGateway
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFindByNatGatewayIdExecute(r ApiDatacentersNatgatewaysFindByNatGatewayIdRequest) (NatGateway, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGateway
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFindByNatGatewayId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFindByNatGatewayId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFlowlogsDeleteRequest struct {
	ctx          _context.Context
	ApiService   *NATGatewaysApiService
	datacenterId string
	natGatewayId string
	flowLogId    string
	pretty       *bool
	depth        *int32
}

func (r ApiDatacentersNatgatewaysFlowlogsDeleteRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFlowlogsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsDeleteRequest) Depth(depth int32) ApiDatacentersNatgatewaysFlowlogsDeleteRequest {
	r.depth = &depth
	return r
}

func (r ApiDatacentersNatgatewaysFlowlogsDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFlowlogsDeleteExecute(r)
}

/*
 * DatacentersNatgatewaysFlowlogsDelete Delete NAT Gateway Flow Logs
 * Delete the specified NAT Gateway Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNatgatewaysFlowlogsDeleteRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsDelete(ctx _context.Context, datacenterId string, natGatewayId string, flowLogId string) ApiDatacentersNatgatewaysFlowlogsDeleteRequest {
	return ApiDatacentersNatgatewaysFlowlogsDeleteRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
		flowLogId:    flowLogId,
	}
}

/*
 * Execute executes the request
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsDeleteExecute(r ApiDatacentersNatgatewaysFlowlogsDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFlowlogsDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFlowlogsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest struct {
	ctx          _context.Context
	ApiService   *NATGatewaysApiService
	datacenterId string
	natGatewayId string
	flowLogId    string
	pretty       *bool
	depth        *int32
}

func (r ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest) Depth(depth int32) ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest {
	r.depth = &depth
	return r
}

func (r ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFlowlogsFindByFlowLogIdExecute(r)
}

/*
 * DatacentersNatgatewaysFlowlogsFindByFlowLogId Retrieve NAT Gateway Flow Logs
 * Retrieve the specified NAT Gateway Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsFindByFlowLogId(ctx _context.Context, datacenterId string, natGatewayId string, flowLogId string) ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest {
	return ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
		flowLogId:    flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsFindByFlowLogIdExecute(r ApiDatacentersNatgatewaysFlowlogsFindByFlowLogIdRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFlowlogsFindByFlowLogId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFlowlogsFindByFlowLogId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFlowlogsGetRequest struct {
	ctx          _context.Context
	ApiService   *NATGatewaysApiService
	filters      _neturl.Values
	orderBy      *string
	maxResults   *int32
	datacenterId string
	natGatewayId string
	pretty       *bool
	depth        *int32
	offset       *int32
	limit        *int32
}

func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) Depth(depth int32) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) Offset(offset int32) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	r.offset = &offset
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) Limit(limit int32) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	r.limit = &limit
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) Filter(key string, value string) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) OrderBy(orderBy string) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) MaxResults(maxResults int32) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersNatgatewaysFlowlogsGetRequest) Execute() (FlowLogs, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFlowlogsGetExecute(r)
}

/*
 * DatacentersNatgatewaysFlowlogsGet List NAT Gateway Flow Logs
 * List all the Flow Logs for the specified NAT Gateway.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysFlowlogsGetRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsGet(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysFlowlogsGetRequest {
	return ApiDatacentersNatgatewaysFlowlogsGetRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
		filters:      _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return FlowLogs
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsGetExecute(r ApiDatacentersNatgatewaysFlowlogsGetRequest) (FlowLogs, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLogs
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFlowlogsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/flowlogs"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("offset")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("offset", parameterToString(0, ""))
		}
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("limit")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("limit", parameterToString(1000, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFlowlogsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFlowlogsPatchRequest struct {
	ctx                         _context.Context
	ApiService                  *NATGatewaysApiService
	datacenterId                string
	natGatewayId                string
	flowLogId                   string
	natGatewayFlowLogProperties *FlowLogProperties
	pretty                      *bool
	depth                       *int32
}

func (r ApiDatacentersNatgatewaysFlowlogsPatchRequest) NatGatewayFlowLogProperties(natGatewayFlowLogProperties FlowLogProperties) ApiDatacentersNatgatewaysFlowlogsPatchRequest {
	r.natGatewayFlowLogProperties = &natGatewayFlowLogProperties
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsPatchRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFlowlogsPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsPatchRequest) Depth(depth int32) ApiDatacentersNatgatewaysFlowlogsPatchRequest {
	r.depth = &depth
	return r
}

func (r ApiDatacentersNatgatewaysFlowlogsPatchRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFlowlogsPatchExecute(r)
}

/*
 * DatacentersNatgatewaysFlowlogsPatch Partially modify NAT Gateway Flow Logs
 * Update the properties of the specified NAT Gateway Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNatgatewaysFlowlogsPatchRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsPatch(ctx _context.Context, datacenterId string, natGatewayId string, flowLogId string) ApiDatacentersNatgatewaysFlowlogsPatchRequest {
	return ApiDatacentersNatgatewaysFlowlogsPatchRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
		flowLogId:    flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsPatchExecute(r ApiDatacentersNatgatewaysFlowlogsPatchRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFlowlogsPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayFlowLogProperties == nil {
		return localVarReturnValue, nil, reportError("natGatewayFlowLogProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.natGatewayFlowLogProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFlowlogsPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFlowlogsPostRequest struct {
	ctx               _context.Context
	ApiService        *NATGatewaysApiService
	datacenterId      string
	natGatewayId      string
	natGatewayFlowLog *FlowLog
	pretty            *bool
	depth             *int32
}

func (r ApiDatacentersNatgatewaysFlowlogsPostRequest) NatGatewayFlowLog(natGatewayFlowLog FlowLog) ApiDatacentersNatgatewaysFlowlogsPostRequest {
	r.natGatewayFlowLog = &natGatewayFlowLog
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsPostRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFlowlogsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsPostRequest) Depth(depth int32) ApiDatacentersNatgatewaysFlowlogsPostRequest {
	r.depth = &depth
	return r
}

func (r ApiDatacentersNatgatewaysFlowlogsPostRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFlowlogsPostExecute(r)
}

/*
 * DatacentersNatgatewaysFlowlogsPost Create NAT Gateway Flow Logs
 * Add a new Flow Log for the specified NAT Gateway.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysFlowlogsPostRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsPost(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysFlowlogsPostRequest {
	return ApiDatacentersNatgatewaysFlowlogsPostRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsPostExecute(r ApiDatacentersNatgatewaysFlowlogsPostRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFlowlogsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/flowlogs"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayFlowLog == nil {
		return localVarReturnValue, nil, reportError("natGatewayFlowLog is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.natGatewayFlowLog
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFlowlogsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysFlowlogsPutRequest struct {
	ctx               _context.Context
	ApiService        *NATGatewaysApiService
	datacenterId      string
	natGatewayId      string
	flowLogId         string
	natGatewayFlowLog *FlowLogPut
	pretty            *bool
	depth             *int32
}

func (r ApiDatacentersNatgatewaysFlowlogsPutRequest) NatGatewayFlowLog(natGatewayFlowLog FlowLogPut) ApiDatacentersNatgatewaysFlowlogsPutRequest {
	r.natGatewayFlowLog = &natGatewayFlowLog
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsPutRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysFlowlogsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysFlowlogsPutRequest) Depth(depth int32) ApiDatacentersNatgatewaysFlowlogsPutRequest {
	r.depth = &depth
	return r
}

func (r ApiDatacentersNatgatewaysFlowlogsPutRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysFlowlogsPutExecute(r)
}

/*
 * DatacentersNatgatewaysFlowlogsPut Modify NAT Gateway Flow Logs
 * Modify the specified NAT Gateway Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNatgatewaysFlowlogsPutRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsPut(ctx _context.Context, datacenterId string, natGatewayId string, flowLogId string) ApiDatacentersNatgatewaysFlowlogsPutRequest {
	return ApiDatacentersNatgatewaysFlowlogsPutRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
		flowLogId:    flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysFlowlogsPutExecute(r ApiDatacentersNatgatewaysFlowlogsPutRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysFlowlogsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayFlowLog == nil {
		return localVarReturnValue, nil, reportError("natGatewayFlowLog is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.natGatewayFlowLog
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysFlowlogsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysGetRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	filters         _neturl.Values
	orderBy         *string
	maxResults      *int32
	datacenterId    string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysGetRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysGetRequest) Depth(depth int32) ApiDatacentersNatgatewaysGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersNatgatewaysGetRequest) Filter(key string, value string) ApiDatacentersNatgatewaysGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersNatgatewaysGetRequest) OrderBy(orderBy string) ApiDatacentersNatgatewaysGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersNatgatewaysGetRequest) MaxResults(maxResults int32) ApiDatacentersNatgatewaysGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersNatgatewaysGetRequest) Execute() (NatGateways, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysGetExecute(r)
}

/*
 * DatacentersNatgatewaysGet List NAT Gateways
 * List all NAT Gateways within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @return ApiDatacentersNatgatewaysGetRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysGet(ctx _context.Context, datacenterId string) ApiDatacentersNatgatewaysGetRequest {
	return ApiDatacentersNatgatewaysGetRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		filters:      _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return NatGateways
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysGetExecute(r ApiDatacentersNatgatewaysGetRequest) (NatGateways, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGateways
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysPatchRequest struct {
	ctx                  _context.Context
	ApiService           *NATGatewaysApiService
	datacenterId         string
	natGatewayId         string
	natGatewayProperties *NatGatewayProperties
	pretty               *bool
	depth                *int32
	xContractNumber      *int32
}

func (r ApiDatacentersNatgatewaysPatchRequest) NatGatewayProperties(natGatewayProperties NatGatewayProperties) ApiDatacentersNatgatewaysPatchRequest {
	r.natGatewayProperties = &natGatewayProperties
	return r
}
func (r ApiDatacentersNatgatewaysPatchRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysPatchRequest) Depth(depth int32) ApiDatacentersNatgatewaysPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysPatchRequest) Execute() (NatGateway, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysPatchExecute(r)
}

/*
 * DatacentersNatgatewaysPatch Partially modify NAT Gateways
 * Update the properties of the specified NAT Gateway within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysPatchRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysPatch(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysPatchRequest {
	return ApiDatacentersNatgatewaysPatchRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
	}
}

/*
 * Execute executes the request
 * @return NatGateway
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysPatchExecute(r ApiDatacentersNatgatewaysPatchRequest) (NatGateway, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGateway
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayProperties == nil {
		return localVarReturnValue, nil, reportError("natGatewayProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.natGatewayProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysPostRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	datacenterId    string
	natGateway      *NatGateway
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysPostRequest) NatGateway(natGateway NatGateway) ApiDatacentersNatgatewaysPostRequest {
	r.natGateway = &natGateway
	return r
}
func (r ApiDatacentersNatgatewaysPostRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysPostRequest) Depth(depth int32) ApiDatacentersNatgatewaysPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysPostRequest) Execute() (NatGateway, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysPostExecute(r)
}

/*
  - DatacentersNatgatewaysPost Create NAT Gateways
  - Create a NAT Gateway within the data center.

This operation is restricted to contract owner, admin, and users with 'createInternetAccess' privileges.
  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @param datacenterId The unique ID of the data center.
  - @return ApiDatacentersNatgatewaysPostRequest
*/
func (a *NATGatewaysApiService) DatacentersNatgatewaysPost(ctx _context.Context, datacenterId string) ApiDatacentersNatgatewaysPostRequest {
	return ApiDatacentersNatgatewaysPostRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return NatGateway
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysPostExecute(r ApiDatacentersNatgatewaysPostRequest) (NatGateway, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGateway
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGateway == nil {
		return localVarReturnValue, nil, reportError("natGateway is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.natGateway
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysPutRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	datacenterId    string
	natGatewayId    string
	natGateway      *NatGatewayPut
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysPutRequest) NatGateway(natGateway NatGatewayPut) ApiDatacentersNatgatewaysPutRequest {
	r.natGateway = &natGateway
	return r
}
func (r ApiDatacentersNatgatewaysPutRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysPutRequest) Depth(depth int32) ApiDatacentersNatgatewaysPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysPutRequest) Execute() (NatGateway, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysPutExecute(r)
}

/*
 * DatacentersNatgatewaysPut Modify NAT Gateways
 * Modify the properties of the specified NAT Gateway within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysPutRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysPut(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysPutRequest {
	return ApiDatacentersNatgatewaysPutRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
	}
}

/*
 * Execute executes the request
 * @return NatGateway
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysPutExecute(r ApiDatacentersNatgatewaysPutRequest) (NatGateway, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGateway
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGateway == nil {
		return localVarReturnValue, nil, reportError("natGateway is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.natGateway
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysRulesDeleteRequest struct {
	ctx              _context.Context
	ApiService       *NATGatewaysApiService
	datacenterId     string
	natGatewayId     string
	natGatewayRuleId string
	pretty           *bool
	depth            *int32
	xContractNumber  *int32
}

func (r ApiDatacentersNatgatewaysRulesDeleteRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysRulesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysRulesDeleteRequest) Depth(depth int32) ApiDatacentersNatgatewaysRulesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysRulesDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysRulesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysRulesDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysRulesDeleteExecute(r)
}

/*
 * DatacentersNatgatewaysRulesDelete Delete NAT Gateway rules
 * Delete the specified NAT Gateway rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param natGatewayRuleId The unique ID of the NAT Gateway rule.
 * @return ApiDatacentersNatgatewaysRulesDeleteRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesDelete(ctx _context.Context, datacenterId string, natGatewayId string, natGatewayRuleId string) ApiDatacentersNatgatewaysRulesDeleteRequest {
	return ApiDatacentersNatgatewaysRulesDeleteRequest{
		ApiService:       a,
		ctx:              ctx,
		datacenterId:     datacenterId,
		natGatewayId:     natGatewayId,
		natGatewayRuleId: natGatewayRuleId,
	}
}

/*
 * Execute executes the request
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesDeleteExecute(r ApiDatacentersNatgatewaysRulesDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysRulesDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/rules/{natGatewayRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayRuleId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysRulesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest struct {
	ctx              _context.Context
	ApiService       *NATGatewaysApiService
	datacenterId     string
	natGatewayId     string
	natGatewayRuleId string
	pretty           *bool
	depth            *int32
	xContractNumber  *int32
}

func (r ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest) Depth(depth int32) ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest) Execute() (NatGatewayRule, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysRulesFindByNatGatewayRuleIdExecute(r)
}

/*
 * DatacentersNatgatewaysRulesFindByNatGatewayRuleId Retrieve NAT Gateway rules
 * Retrieve the properties of the specified NAT Gateway rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param natGatewayRuleId The unique ID of the NAT Gateway rule.
 * @return ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesFindByNatGatewayRuleId(ctx _context.Context, datacenterId string, natGatewayId string, natGatewayRuleId string) ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest {
	return ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest{
		ApiService:       a,
		ctx:              ctx,
		datacenterId:     datacenterId,
		natGatewayId:     natGatewayId,
		natGatewayRuleId: natGatewayRuleId,
	}
}

/*
 * Execute executes the request
 * @return NatGatewayRule
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesFindByNatGatewayRuleIdExecute(r ApiDatacentersNatgatewaysRulesFindByNatGatewayRuleIdRequest) (NatGatewayRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGatewayRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysRulesFindByNatGatewayRuleId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/rules/{natGatewayRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayRuleId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysRulesFindByNatGatewayRuleId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysRulesGetRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	filters         _neturl.Values
	orderBy         *string
	maxResults      *int32
	datacenterId    string
	natGatewayId    string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysRulesGetRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysRulesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysRulesGetRequest) Depth(depth int32) ApiDatacentersNatgatewaysRulesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysRulesGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysRulesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersNatgatewaysRulesGetRequest) Filter(key string, value string) ApiDatacentersNatgatewaysRulesGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersNatgatewaysRulesGetRequest) OrderBy(orderBy string) ApiDatacentersNatgatewaysRulesGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersNatgatewaysRulesGetRequest) MaxResults(maxResults int32) ApiDatacentersNatgatewaysRulesGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersNatgatewaysRulesGetRequest) Execute() (NatGatewayRules, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysRulesGetExecute(r)
}

/*
 * DatacentersNatgatewaysRulesGet List NAT Gateway rules
 * List all rules for the specified NAT Gateway.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysRulesGetRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesGet(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysRulesGetRequest {
	return ApiDatacentersNatgatewaysRulesGetRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
		filters:      _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return NatGatewayRules
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesGetExecute(r ApiDatacentersNatgatewaysRulesGetRequest) (NatGatewayRules, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGatewayRules
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysRulesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/rules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysRulesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysRulesPatchRequest struct {
	ctx                      _context.Context
	ApiService               *NATGatewaysApiService
	datacenterId             string
	natGatewayId             string
	natGatewayRuleId         string
	natGatewayRuleProperties *NatGatewayRuleProperties
	pretty                   *bool
	depth                    *int32
	xContractNumber          *int32
}

func (r ApiDatacentersNatgatewaysRulesPatchRequest) NatGatewayRuleProperties(natGatewayRuleProperties NatGatewayRuleProperties) ApiDatacentersNatgatewaysRulesPatchRequest {
	r.natGatewayRuleProperties = &natGatewayRuleProperties
	return r
}
func (r ApiDatacentersNatgatewaysRulesPatchRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysRulesPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysRulesPatchRequest) Depth(depth int32) ApiDatacentersNatgatewaysRulesPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysRulesPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysRulesPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysRulesPatchRequest) Execute() (NatGatewayRule, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysRulesPatchExecute(r)
}

/*
 * DatacentersNatgatewaysRulesPatch Partially modify NAT Gateway rules
 * Update the properties of the specified NAT Gateway rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param natGatewayRuleId The unique ID of the NAT Gateway rule.
 * @return ApiDatacentersNatgatewaysRulesPatchRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesPatch(ctx _context.Context, datacenterId string, natGatewayId string, natGatewayRuleId string) ApiDatacentersNatgatewaysRulesPatchRequest {
	return ApiDatacentersNatgatewaysRulesPatchRequest{
		ApiService:       a,
		ctx:              ctx,
		datacenterId:     datacenterId,
		natGatewayId:     natGatewayId,
		natGatewayRuleId: natGatewayRuleId,
	}
}

/*
 * Execute executes the request
 * @return NatGatewayRule
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesPatchExecute(r ApiDatacentersNatgatewaysRulesPatchRequest) (NatGatewayRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGatewayRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysRulesPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/rules/{natGatewayRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayRuleId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayRuleProperties == nil {
		return localVarReturnValue, nil, reportError("natGatewayRuleProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.natGatewayRuleProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysRulesPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysRulesPostRequest struct {
	ctx             _context.Context
	ApiService      *NATGatewaysApiService
	datacenterId    string
	natGatewayId    string
	natGatewayRule  *NatGatewayRule
	pretty          *bool
	depth           *int32
	xContractNumber *int32
}

func (r ApiDatacentersNatgatewaysRulesPostRequest) NatGatewayRule(natGatewayRule NatGatewayRule) ApiDatacentersNatgatewaysRulesPostRequest {
	r.natGatewayRule = &natGatewayRule
	return r
}
func (r ApiDatacentersNatgatewaysRulesPostRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysRulesPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysRulesPostRequest) Depth(depth int32) ApiDatacentersNatgatewaysRulesPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysRulesPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysRulesPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysRulesPostRequest) Execute() (NatGatewayRule, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysRulesPostExecute(r)
}

/*
 * DatacentersNatgatewaysRulesPost Create NAT Gateway rules
 * Create a rule for the specified NAT Gateway.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @return ApiDatacentersNatgatewaysRulesPostRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesPost(ctx _context.Context, datacenterId string, natGatewayId string) ApiDatacentersNatgatewaysRulesPostRequest {
	return ApiDatacentersNatgatewaysRulesPostRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		natGatewayId: natGatewayId,
	}
}

/*
 * Execute executes the request
 * @return NatGatewayRule
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesPostExecute(r ApiDatacentersNatgatewaysRulesPostRequest) (NatGatewayRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGatewayRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysRulesPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/rules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayRule == nil {
		return localVarReturnValue, nil, reportError("natGatewayRule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.natGatewayRule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysRulesPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNatgatewaysRulesPutRequest struct {
	ctx              _context.Context
	ApiService       *NATGatewaysApiService
	datacenterId     string
	natGatewayId     string
	natGatewayRuleId string
	natGatewayRule   *NatGatewayRulePut
	pretty           *bool
	depth            *int32
	xContractNumber  *int32
}

func (r ApiDatacentersNatgatewaysRulesPutRequest) NatGatewayRule(natGatewayRule NatGatewayRulePut) ApiDatacentersNatgatewaysRulesPutRequest {
	r.natGatewayRule = &natGatewayRule
	return r
}
func (r ApiDatacentersNatgatewaysRulesPutRequest) Pretty(pretty bool) ApiDatacentersNatgatewaysRulesPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNatgatewaysRulesPutRequest) Depth(depth int32) ApiDatacentersNatgatewaysRulesPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNatgatewaysRulesPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersNatgatewaysRulesPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNatgatewaysRulesPutRequest) Execute() (NatGatewayRule, *APIResponse, error) {
	return r.ApiService.DatacentersNatgatewaysRulesPutExecute(r)
}

/*
 * DatacentersNatgatewaysRulesPut Modify NAT Gateway rules
 * Modify the specified NAT Gateway rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param natGatewayId The unique ID of the NAT Gateway.
 * @param natGatewayRuleId The unique ID of the NAT Gateway rule.
 * @return ApiDatacentersNatgatewaysRulesPutRequest
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesPut(ctx _context.Context, datacenterId string, natGatewayId string, natGatewayRuleId string) ApiDatacentersNatgatewaysRulesPutRequest {
	return ApiDatacentersNatgatewaysRulesPutRequest{
		ApiService:       a,
		ctx:              ctx,
		datacenterId:     datacenterId,
		natGatewayId:     natGatewayId,
		natGatewayRuleId: natGatewayRuleId,
	}
}

/*
 * Execute executes the request
 * @return NatGatewayRule
 */
func (a *NATGatewaysApiService) DatacentersNatgatewaysRulesPutExecute(r ApiDatacentersNatgatewaysRulesPutRequest) (NatGatewayRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NatGatewayRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NATGatewaysApiService.DatacentersNatgatewaysRulesPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/natgateways/{natGatewayId}/rules/{natGatewayRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"natGatewayRuleId"+"}", _neturl.PathEscape(parameterToString(r.natGatewayRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.natGatewayRule == nil {
		return localVarReturnValue, nil, reportError("natGatewayRule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.natGatewayRule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNatgatewaysRulesPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
