// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/keyword_plan_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [KeywordPlanService.GetKeywordPlan][google.ads.googleads.v2.services.KeywordPlanService.GetKeywordPlan].
type GetKeywordPlanRequest struct {
	// The resource name of the plan to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKeywordPlanRequest) Reset()         { *m = GetKeywordPlanRequest{} }
func (m *GetKeywordPlanRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeywordPlanRequest) ProtoMessage()    {}
func (*GetKeywordPlanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{0}
}

func (m *GetKeywordPlanRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeywordPlanRequest.Unmarshal(m, b)
}
func (m *GetKeywordPlanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeywordPlanRequest.Marshal(b, m, deterministic)
}
func (m *GetKeywordPlanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeywordPlanRequest.Merge(m, src)
}
func (m *GetKeywordPlanRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeywordPlanRequest.Size(m)
}
func (m *GetKeywordPlanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeywordPlanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeywordPlanRequest proto.InternalMessageInfo

func (m *GetKeywordPlanRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanService.MutateKeywordPlans][google.ads.googleads.v2.services.KeywordPlanService.MutateKeywordPlans].
type MutateKeywordPlansRequest struct {
	// The ID of the customer whose keyword plans are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual keyword plans.
	Operations []*KeywordPlanOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateKeywordPlansRequest) Reset()         { *m = MutateKeywordPlansRequest{} }
func (m *MutateKeywordPlansRequest) String() string { return proto.CompactTextString(m) }
func (*MutateKeywordPlansRequest) ProtoMessage()    {}
func (*MutateKeywordPlansRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{1}
}

func (m *MutateKeywordPlansRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateKeywordPlansRequest.Unmarshal(m, b)
}
func (m *MutateKeywordPlansRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateKeywordPlansRequest.Marshal(b, m, deterministic)
}
func (m *MutateKeywordPlansRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateKeywordPlansRequest.Merge(m, src)
}
func (m *MutateKeywordPlansRequest) XXX_Size() int {
	return xxx_messageInfo_MutateKeywordPlansRequest.Size(m)
}
func (m *MutateKeywordPlansRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateKeywordPlansRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateKeywordPlansRequest proto.InternalMessageInfo

func (m *MutateKeywordPlansRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateKeywordPlansRequest) GetOperations() []*KeywordPlanOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateKeywordPlansRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateKeywordPlansRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a keyword plan.
type KeywordPlanOperation struct {
	// The FieldMask that determines which resource fields are modified in an
	// update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*KeywordPlanOperation_Create
	//	*KeywordPlanOperation_Update
	//	*KeywordPlanOperation_Remove
	Operation            isKeywordPlanOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *KeywordPlanOperation) Reset()         { *m = KeywordPlanOperation{} }
func (m *KeywordPlanOperation) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanOperation) ProtoMessage()    {}
func (*KeywordPlanOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{2}
}

func (m *KeywordPlanOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanOperation.Unmarshal(m, b)
}
func (m *KeywordPlanOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanOperation.Marshal(b, m, deterministic)
}
func (m *KeywordPlanOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanOperation.Merge(m, src)
}
func (m *KeywordPlanOperation) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanOperation.Size(m)
}
func (m *KeywordPlanOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanOperation.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanOperation proto.InternalMessageInfo

func (m *KeywordPlanOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isKeywordPlanOperation_Operation interface {
	isKeywordPlanOperation_Operation()
}

type KeywordPlanOperation_Create struct {
	Create *resources.KeywordPlan `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type KeywordPlanOperation_Update struct {
	Update *resources.KeywordPlan `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type KeywordPlanOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*KeywordPlanOperation_Create) isKeywordPlanOperation_Operation() {}

func (*KeywordPlanOperation_Update) isKeywordPlanOperation_Operation() {}

func (*KeywordPlanOperation_Remove) isKeywordPlanOperation_Operation() {}

func (m *KeywordPlanOperation) GetOperation() isKeywordPlanOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *KeywordPlanOperation) GetCreate() *resources.KeywordPlan {
	if x, ok := m.GetOperation().(*KeywordPlanOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *KeywordPlanOperation) GetUpdate() *resources.KeywordPlan {
	if x, ok := m.GetOperation().(*KeywordPlanOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *KeywordPlanOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*KeywordPlanOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*KeywordPlanOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*KeywordPlanOperation_Create)(nil),
		(*KeywordPlanOperation_Update)(nil),
		(*KeywordPlanOperation_Remove)(nil),
	}
}

// Response message for a keyword plan mutate.
type MutateKeywordPlansResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateKeywordPlansResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateKeywordPlansResponse) Reset()         { *m = MutateKeywordPlansResponse{} }
func (m *MutateKeywordPlansResponse) String() string { return proto.CompactTextString(m) }
func (*MutateKeywordPlansResponse) ProtoMessage()    {}
func (*MutateKeywordPlansResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{3}
}

func (m *MutateKeywordPlansResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateKeywordPlansResponse.Unmarshal(m, b)
}
func (m *MutateKeywordPlansResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateKeywordPlansResponse.Marshal(b, m, deterministic)
}
func (m *MutateKeywordPlansResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateKeywordPlansResponse.Merge(m, src)
}
func (m *MutateKeywordPlansResponse) XXX_Size() int {
	return xxx_messageInfo_MutateKeywordPlansResponse.Size(m)
}
func (m *MutateKeywordPlansResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateKeywordPlansResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateKeywordPlansResponse proto.InternalMessageInfo

func (m *MutateKeywordPlansResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateKeywordPlansResponse) GetResults() []*MutateKeywordPlansResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the keyword plan mutate.
type MutateKeywordPlansResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateKeywordPlansResult) Reset()         { *m = MutateKeywordPlansResult{} }
func (m *MutateKeywordPlansResult) String() string { return proto.CompactTextString(m) }
func (*MutateKeywordPlansResult) ProtoMessage()    {}
func (*MutateKeywordPlansResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{4}
}

func (m *MutateKeywordPlansResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateKeywordPlansResult.Unmarshal(m, b)
}
func (m *MutateKeywordPlansResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateKeywordPlansResult.Marshal(b, m, deterministic)
}
func (m *MutateKeywordPlansResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateKeywordPlansResult.Merge(m, src)
}
func (m *MutateKeywordPlansResult) XXX_Size() int {
	return xxx_messageInfo_MutateKeywordPlansResult.Size(m)
}
func (m *MutateKeywordPlansResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateKeywordPlansResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateKeywordPlansResult proto.InternalMessageInfo

func (m *MutateKeywordPlansResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanService.GenerateForecastMetrics][google.ads.googleads.v2.services.KeywordPlanService.GenerateForecastMetrics].
type GenerateForecastMetricsRequest struct {
	// The resource name of the keyword plan to be forecasted.
	KeywordPlan          string   `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateForecastMetricsRequest) Reset()         { *m = GenerateForecastMetricsRequest{} }
func (m *GenerateForecastMetricsRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateForecastMetricsRequest) ProtoMessage()    {}
func (*GenerateForecastMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{5}
}

func (m *GenerateForecastMetricsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateForecastMetricsRequest.Unmarshal(m, b)
}
func (m *GenerateForecastMetricsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateForecastMetricsRequest.Marshal(b, m, deterministic)
}
func (m *GenerateForecastMetricsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateForecastMetricsRequest.Merge(m, src)
}
func (m *GenerateForecastMetricsRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateForecastMetricsRequest.Size(m)
}
func (m *GenerateForecastMetricsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateForecastMetricsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateForecastMetricsRequest proto.InternalMessageInfo

func (m *GenerateForecastMetricsRequest) GetKeywordPlan() string {
	if m != nil {
		return m.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateForecastMetrics][google.ads.googleads.v2.services.KeywordPlanService.GenerateForecastMetrics].
type GenerateForecastMetricsResponse struct {
	// List of campaign forecasts.
	// One maximum.
	CampaignForecasts []*KeywordPlanCampaignForecast `protobuf:"bytes,1,rep,name=campaign_forecasts,json=campaignForecasts,proto3" json:"campaign_forecasts,omitempty"`
	// List of ad group forecasts.
	AdGroupForecasts []*KeywordPlanAdGroupForecast `protobuf:"bytes,2,rep,name=ad_group_forecasts,json=adGroupForecasts,proto3" json:"ad_group_forecasts,omitempty"`
	// List of keyword forecasts.
	KeywordForecasts     []*KeywordPlanKeywordForecast `protobuf:"bytes,3,rep,name=keyword_forecasts,json=keywordForecasts,proto3" json:"keyword_forecasts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *GenerateForecastMetricsResponse) Reset()         { *m = GenerateForecastMetricsResponse{} }
func (m *GenerateForecastMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateForecastMetricsResponse) ProtoMessage()    {}
func (*GenerateForecastMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{6}
}

func (m *GenerateForecastMetricsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateForecastMetricsResponse.Unmarshal(m, b)
}
func (m *GenerateForecastMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateForecastMetricsResponse.Marshal(b, m, deterministic)
}
func (m *GenerateForecastMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateForecastMetricsResponse.Merge(m, src)
}
func (m *GenerateForecastMetricsResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateForecastMetricsResponse.Size(m)
}
func (m *GenerateForecastMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateForecastMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateForecastMetricsResponse proto.InternalMessageInfo

func (m *GenerateForecastMetricsResponse) GetCampaignForecasts() []*KeywordPlanCampaignForecast {
	if m != nil {
		return m.CampaignForecasts
	}
	return nil
}

func (m *GenerateForecastMetricsResponse) GetAdGroupForecasts() []*KeywordPlanAdGroupForecast {
	if m != nil {
		return m.AdGroupForecasts
	}
	return nil
}

func (m *GenerateForecastMetricsResponse) GetKeywordForecasts() []*KeywordPlanKeywordForecast {
	if m != nil {
		return m.KeywordForecasts
	}
	return nil
}

// A campaign forecast.
type KeywordPlanCampaignForecast struct {
	// The resource name of the Keyword Plan campaign related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanCampaigns/{keyword+plan_campaign_id}`
	KeywordPlanCampaign *wrappers.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The forecast for the Keyword Plan campaign.
	CampaignForecast     *ForecastMetrics `protobuf:"bytes,2,opt,name=campaign_forecast,json=campaignForecast,proto3" json:"campaign_forecast,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *KeywordPlanCampaignForecast) Reset()         { *m = KeywordPlanCampaignForecast{} }
func (m *KeywordPlanCampaignForecast) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanCampaignForecast) ProtoMessage()    {}
func (*KeywordPlanCampaignForecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{7}
}

func (m *KeywordPlanCampaignForecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanCampaignForecast.Unmarshal(m, b)
}
func (m *KeywordPlanCampaignForecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanCampaignForecast.Marshal(b, m, deterministic)
}
func (m *KeywordPlanCampaignForecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanCampaignForecast.Merge(m, src)
}
func (m *KeywordPlanCampaignForecast) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanCampaignForecast.Size(m)
}
func (m *KeywordPlanCampaignForecast) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanCampaignForecast.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanCampaignForecast proto.InternalMessageInfo

func (m *KeywordPlanCampaignForecast) GetKeywordPlanCampaign() *wrappers.StringValue {
	if m != nil {
		return m.KeywordPlanCampaign
	}
	return nil
}

func (m *KeywordPlanCampaignForecast) GetCampaignForecast() *ForecastMetrics {
	if m != nil {
		return m.CampaignForecast
	}
	return nil
}

// An ad group forecast.
type KeywordPlanAdGroupForecast struct {
	// The resource name of the Keyword Plan ad group related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanAdGroups/{keyword_plan_ad_group_id}`
	KeywordPlanAdGroup *wrappers.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_ad_group,json=keywordPlanAdGroup,proto3" json:"keyword_plan_ad_group,omitempty"`
	// The forecast for the Keyword Plan ad group.
	AdGroupForecast      *ForecastMetrics `protobuf:"bytes,2,opt,name=ad_group_forecast,json=adGroupForecast,proto3" json:"ad_group_forecast,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *KeywordPlanAdGroupForecast) Reset()         { *m = KeywordPlanAdGroupForecast{} }
func (m *KeywordPlanAdGroupForecast) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanAdGroupForecast) ProtoMessage()    {}
func (*KeywordPlanAdGroupForecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{8}
}

func (m *KeywordPlanAdGroupForecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanAdGroupForecast.Unmarshal(m, b)
}
func (m *KeywordPlanAdGroupForecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanAdGroupForecast.Marshal(b, m, deterministic)
}
func (m *KeywordPlanAdGroupForecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanAdGroupForecast.Merge(m, src)
}
func (m *KeywordPlanAdGroupForecast) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanAdGroupForecast.Size(m)
}
func (m *KeywordPlanAdGroupForecast) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanAdGroupForecast.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanAdGroupForecast proto.InternalMessageInfo

func (m *KeywordPlanAdGroupForecast) GetKeywordPlanAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.KeywordPlanAdGroup
	}
	return nil
}

func (m *KeywordPlanAdGroupForecast) GetAdGroupForecast() *ForecastMetrics {
	if m != nil {
		return m.AdGroupForecast
	}
	return nil
}

// A keyword forecast.
type KeywordPlanKeywordForecast struct {
	// The resource name of the Keyword Plan keyword related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanAdGroupKeywords/{keyword_plan_ad_group_keyword_id}`
	KeywordPlanAdGroupKeyword *wrappers.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_ad_group_keyword,json=keywordPlanAdGroupKeyword,proto3" json:"keyword_plan_ad_group_keyword,omitempty"`
	// The forecast for the Keyword Plan keyword.
	KeywordForecast      *ForecastMetrics `protobuf:"bytes,2,opt,name=keyword_forecast,json=keywordForecast,proto3" json:"keyword_forecast,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *KeywordPlanKeywordForecast) Reset()         { *m = KeywordPlanKeywordForecast{} }
func (m *KeywordPlanKeywordForecast) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanKeywordForecast) ProtoMessage()    {}
func (*KeywordPlanKeywordForecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{9}
}

func (m *KeywordPlanKeywordForecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanKeywordForecast.Unmarshal(m, b)
}
func (m *KeywordPlanKeywordForecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanKeywordForecast.Marshal(b, m, deterministic)
}
func (m *KeywordPlanKeywordForecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanKeywordForecast.Merge(m, src)
}
func (m *KeywordPlanKeywordForecast) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanKeywordForecast.Size(m)
}
func (m *KeywordPlanKeywordForecast) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanKeywordForecast.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanKeywordForecast proto.InternalMessageInfo

func (m *KeywordPlanKeywordForecast) GetKeywordPlanAdGroupKeyword() *wrappers.StringValue {
	if m != nil {
		return m.KeywordPlanAdGroupKeyword
	}
	return nil
}

func (m *KeywordPlanKeywordForecast) GetKeywordForecast() *ForecastMetrics {
	if m != nil {
		return m.KeywordForecast
	}
	return nil
}

// Forecast metrics.
type ForecastMetrics struct {
	// Impressions
	Impressions *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Ctr
	Ctr *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// AVG cpc
	AverageCpc *wrappers.Int64Value `protobuf:"bytes,3,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// Clicks
	Clicks *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Cost
	CostMicros           *wrappers.Int64Value `protobuf:"bytes,6,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ForecastMetrics) Reset()         { *m = ForecastMetrics{} }
func (m *ForecastMetrics) String() string { return proto.CompactTextString(m) }
func (*ForecastMetrics) ProtoMessage()    {}
func (*ForecastMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{10}
}

func (m *ForecastMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForecastMetrics.Unmarshal(m, b)
}
func (m *ForecastMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForecastMetrics.Marshal(b, m, deterministic)
}
func (m *ForecastMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForecastMetrics.Merge(m, src)
}
func (m *ForecastMetrics) XXX_Size() int {
	return xxx_messageInfo_ForecastMetrics.Size(m)
}
func (m *ForecastMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ForecastMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ForecastMetrics proto.InternalMessageInfo

func (m *ForecastMetrics) GetImpressions() *wrappers.DoubleValue {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *ForecastMetrics) GetCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.Ctr
	}
	return nil
}

func (m *ForecastMetrics) GetAverageCpc() *wrappers.Int64Value {
	if m != nil {
		return m.AverageCpc
	}
	return nil
}

func (m *ForecastMetrics) GetClicks() *wrappers.DoubleValue {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *ForecastMetrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

// Request message for [KeywordPlanService.GenerateHistoricalMetrics][google.ads.googleads.v2.services.KeywordPlanService.GenerateHistoricalMetrics].
type GenerateHistoricalMetricsRequest struct {
	// The resource name of the keyword plan of which historical metrics are
	// requested.
	KeywordPlan          string   `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateHistoricalMetricsRequest) Reset()         { *m = GenerateHistoricalMetricsRequest{} }
func (m *GenerateHistoricalMetricsRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateHistoricalMetricsRequest) ProtoMessage()    {}
func (*GenerateHistoricalMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{11}
}

func (m *GenerateHistoricalMetricsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateHistoricalMetricsRequest.Unmarshal(m, b)
}
func (m *GenerateHistoricalMetricsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateHistoricalMetricsRequest.Marshal(b, m, deterministic)
}
func (m *GenerateHistoricalMetricsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateHistoricalMetricsRequest.Merge(m, src)
}
func (m *GenerateHistoricalMetricsRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateHistoricalMetricsRequest.Size(m)
}
func (m *GenerateHistoricalMetricsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateHistoricalMetricsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateHistoricalMetricsRequest proto.InternalMessageInfo

func (m *GenerateHistoricalMetricsRequest) GetKeywordPlan() string {
	if m != nil {
		return m.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateHistoricalMetrics][google.ads.googleads.v2.services.KeywordPlanService.GenerateHistoricalMetrics].
type GenerateHistoricalMetricsResponse struct {
	// List of keyword historical metrics.
	Metrics              []*KeywordPlanKeywordHistoricalMetrics `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *GenerateHistoricalMetricsResponse) Reset()         { *m = GenerateHistoricalMetricsResponse{} }
func (m *GenerateHistoricalMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateHistoricalMetricsResponse) ProtoMessage()    {}
func (*GenerateHistoricalMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{12}
}

func (m *GenerateHistoricalMetricsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateHistoricalMetricsResponse.Unmarshal(m, b)
}
func (m *GenerateHistoricalMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateHistoricalMetricsResponse.Marshal(b, m, deterministic)
}
func (m *GenerateHistoricalMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateHistoricalMetricsResponse.Merge(m, src)
}
func (m *GenerateHistoricalMetricsResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateHistoricalMetricsResponse.Size(m)
}
func (m *GenerateHistoricalMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateHistoricalMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateHistoricalMetricsResponse proto.InternalMessageInfo

func (m *GenerateHistoricalMetricsResponse) GetMetrics() []*KeywordPlanKeywordHistoricalMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// A keyword historical metrics.
type KeywordPlanKeywordHistoricalMetrics struct {
	// The text of the query associated with one or more ad_group_keywords in the
	// plan.
	//
	// Note that we de-dupe your keywords list, eliminating close variants before
	// returning the plan's keywords as text. For example, if your plan originally
	// contained the keywords 'car' and 'cars', the returned search query will
	// only contain 'car'.
	SearchQuery *wrappers.StringValue `protobuf:"bytes,1,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
	// The historical metrics for the query associated with one or more
	// ad_group_keywords in the plan.
	KeywordMetrics       *common.KeywordPlanHistoricalMetrics `protobuf:"bytes,2,opt,name=keyword_metrics,json=keywordMetrics,proto3" json:"keyword_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *KeywordPlanKeywordHistoricalMetrics) Reset()         { *m = KeywordPlanKeywordHistoricalMetrics{} }
func (m *KeywordPlanKeywordHistoricalMetrics) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanKeywordHistoricalMetrics) ProtoMessage()    {}
func (*KeywordPlanKeywordHistoricalMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_57c4f7f2153dbccb, []int{13}
}

func (m *KeywordPlanKeywordHistoricalMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanKeywordHistoricalMetrics.Unmarshal(m, b)
}
func (m *KeywordPlanKeywordHistoricalMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanKeywordHistoricalMetrics.Marshal(b, m, deterministic)
}
func (m *KeywordPlanKeywordHistoricalMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanKeywordHistoricalMetrics.Merge(m, src)
}
func (m *KeywordPlanKeywordHistoricalMetrics) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanKeywordHistoricalMetrics.Size(m)
}
func (m *KeywordPlanKeywordHistoricalMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanKeywordHistoricalMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanKeywordHistoricalMetrics proto.InternalMessageInfo

func (m *KeywordPlanKeywordHistoricalMetrics) GetSearchQuery() *wrappers.StringValue {
	if m != nil {
		return m.SearchQuery
	}
	return nil
}

func (m *KeywordPlanKeywordHistoricalMetrics) GetKeywordMetrics() *common.KeywordPlanHistoricalMetrics {
	if m != nil {
		return m.KeywordMetrics
	}
	return nil
}

func init() {
	proto.RegisterType((*GetKeywordPlanRequest)(nil), "google.ads.googleads.v2.services.GetKeywordPlanRequest")
	proto.RegisterType((*MutateKeywordPlansRequest)(nil), "google.ads.googleads.v2.services.MutateKeywordPlansRequest")
	proto.RegisterType((*KeywordPlanOperation)(nil), "google.ads.googleads.v2.services.KeywordPlanOperation")
	proto.RegisterType((*MutateKeywordPlansResponse)(nil), "google.ads.googleads.v2.services.MutateKeywordPlansResponse")
	proto.RegisterType((*MutateKeywordPlansResult)(nil), "google.ads.googleads.v2.services.MutateKeywordPlansResult")
	proto.RegisterType((*GenerateForecastMetricsRequest)(nil), "google.ads.googleads.v2.services.GenerateForecastMetricsRequest")
	proto.RegisterType((*GenerateForecastMetricsResponse)(nil), "google.ads.googleads.v2.services.GenerateForecastMetricsResponse")
	proto.RegisterType((*KeywordPlanCampaignForecast)(nil), "google.ads.googleads.v2.services.KeywordPlanCampaignForecast")
	proto.RegisterType((*KeywordPlanAdGroupForecast)(nil), "google.ads.googleads.v2.services.KeywordPlanAdGroupForecast")
	proto.RegisterType((*KeywordPlanKeywordForecast)(nil), "google.ads.googleads.v2.services.KeywordPlanKeywordForecast")
	proto.RegisterType((*ForecastMetrics)(nil), "google.ads.googleads.v2.services.ForecastMetrics")
	proto.RegisterType((*GenerateHistoricalMetricsRequest)(nil), "google.ads.googleads.v2.services.GenerateHistoricalMetricsRequest")
	proto.RegisterType((*GenerateHistoricalMetricsResponse)(nil), "google.ads.googleads.v2.services.GenerateHistoricalMetricsResponse")
	proto.RegisterType((*KeywordPlanKeywordHistoricalMetrics)(nil), "google.ads.googleads.v2.services.KeywordPlanKeywordHistoricalMetrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/keyword_plan_service.proto", fileDescriptor_57c4f7f2153dbccb)
}

var fileDescriptor_57c4f7f2153dbccb = []byte{
	// 1255 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0x41, 0x6f, 0xdc, 0xc4,
	0x17, 0xff, 0x7b, 0xf3, 0x27, 0xa5, 0x6f, 0x43, 0xdb, 0x4c, 0xa9, 0xba, 0xdd, 0x96, 0x36, 0x75,
	0x2b, 0x51, 0xe5, 0x60, 0xd3, 0xa5, 0x0a, 0xc8, 0x49, 0x29, 0x9b, 0x90, 0x6c, 0x0a, 0x84, 0x86,
	0x2d, 0xca, 0x01, 0x85, 0x5a, 0x53, 0x7b, 0xb2, 0x98, 0xb5, 0x3d, 0xee, 0x8c, 0xbd, 0x55, 0x54,
	0xf5, 0x82, 0x38, 0x73, 0xe1, 0x1b, 0xc0, 0x8d, 0x1b, 0xe2, 0xc6, 0x47, 0xa8, 0xa8, 0x38, 0x70,
	0xe3, 0x88, 0x10, 0x07, 0x4e, 0x1c, 0x39, 0x21, 0x64, 0xcf, 0xcc, 0xc6, 0x6b, 0xaf, 0x93, 0xcd,
	0xf6, 0x36, 0x7e, 0xf3, 0xde, 0xef, 0xbd, 0xdf, 0x7b, 0x6f, 0xde, 0xbe, 0x85, 0xe5, 0x1e, 0xa5,
	0x3d, 0x9f, 0x98, 0xd8, 0xe5, 0xa6, 0x38, 0xa6, 0xa7, 0x41, 0xcb, 0xe4, 0x84, 0x0d, 0x3c, 0x87,
	0x70, 0xb3, 0x4f, 0xf6, 0x1f, 0x53, 0xe6, 0xda, 0x91, 0x8f, 0x43, 0x5b, 0x4a, 0x8d, 0x88, 0xd1,
	0x98, 0xa2, 0x05, 0x61, 0x61, 0x60, 0x97, 0x1b, 0x43, 0x63, 0x63, 0xd0, 0x32, 0x94, 0x71, 0xf3,
	0xed, 0x2a, 0x78, 0x87, 0x06, 0x01, 0x0d, 0x47, 0xc1, 0x85, 0x4c, 0x60, 0x37, 0x6f, 0x55, 0x59,
	0x32, 0xc2, 0x69, 0xc2, 0x8a, 0x91, 0x49, 0xab, 0x4b, 0xca, 0x2a, 0xf2, 0x4c, 0x1c, 0x86, 0x34,
	0xc6, 0xb1, 0x47, 0x43, 0x2e, 0x6f, 0x65, 0xbc, 0x66, 0xf6, 0xf5, 0x30, 0xd9, 0x33, 0xf7, 0x3c,
	0xe2, 0xbb, 0x76, 0x80, 0x79, 0x5f, 0x6a, 0x5c, 0x2e, 0x6a, 0x3c, 0x66, 0x38, 0x8a, 0x08, 0x53,
	0x08, 0xe7, 0xe5, 0x3d, 0x8b, 0x1c, 0x93, 0xc7, 0x38, 0x4e, 0x8a, 0x17, 0xa9, 0x63, 0xc7, 0xf7,
	0x48, 0x18, 0x8b, 0x0b, 0x7d, 0x05, 0xce, 0x75, 0x48, 0xfc, 0x81, 0x08, 0x75, 0xdb, 0xc7, 0x61,
	0x97, 0x3c, 0x4a, 0x08, 0x8f, 0xd1, 0x35, 0x78, 0x45, 0x51, 0xb1, 0x43, 0x1c, 0x90, 0x86, 0xb6,
	0xa0, 0xdd, 0x38, 0xd9, 0x9d, 0x53, 0xc2, 0x8f, 0x70, 0x40, 0xf4, 0xdf, 0x35, 0xb8, 0xb0, 0x95,
	0xc4, 0x38, 0x26, 0x39, 0x04, 0xae, 0x20, 0xae, 0x40, 0xdd, 0x49, 0x78, 0x4c, 0x03, 0xc2, 0x6c,
	0xcf, 0x95, 0x00, 0xa0, 0x44, 0x77, 0x5d, 0xb4, 0x03, 0x40, 0x23, 0xc2, 0x44, 0x12, 0x1a, 0xb5,
	0x85, 0x99, 0x1b, 0xf5, 0xd6, 0x92, 0x71, 0x54, 0xd5, 0x8c, 0x9c, 0xaf, 0x7b, 0xca, 0xbc, 0x9b,
	0x43, 0x42, 0xaf, 0xc3, 0xe9, 0x08, 0xb3, 0xd8, 0xc3, 0xbe, 0xbd, 0x87, 0x3d, 0x3f, 0x61, 0xa4,
	0x31, 0xb3, 0xa0, 0xdd, 0x78, 0xb9, 0x7b, 0x4a, 0x8a, 0x37, 0x84, 0x34, 0x25, 0x39, 0xc0, 0xbe,
	0xe7, 0xe2, 0x98, 0xd8, 0x34, 0xf4, 0xf7, 0x1b, 0xff, 0xcf, 0xd4, 0xe6, 0x94, 0xf0, 0x5e, 0xe8,
	0xef, 0xeb, 0x5f, 0xd7, 0xe0, 0xd5, 0x71, 0x2e, 0xd1, 0x32, 0xd4, 0x93, 0x28, 0xb3, 0x4d, 0x4b,
	0x94, 0xd9, 0xd6, 0x5b, 0x4d, 0x15, 0xbf, 0xaa, 0x91, 0xb1, 0x91, 0x56, 0x71, 0x0b, 0xf3, 0x7e,
	0x17, 0x84, 0x7a, 0x7a, 0x46, 0x9b, 0x30, 0xeb, 0x30, 0x82, 0x63, 0x91, 0xd8, 0x7a, 0xcb, 0xa8,
	0xe4, 0x3d, 0xec, 0xa8, 0x3c, 0xf1, 0xcd, 0xff, 0x75, 0xa5, 0x7d, 0x8a, 0x24, 0x70, 0x1b, 0xb5,
	0x69, 0x91, 0x84, 0x3d, 0x6a, 0xc0, 0x2c, 0x23, 0x01, 0x1d, 0x88, 0x74, 0x9d, 0x4c, 0x6f, 0xc4,
	0xf7, 0x6a, 0x1d, 0x4e, 0x0e, 0xf3, 0xab, 0xff, 0xa4, 0x41, 0x73, 0x5c, 0xd5, 0x79, 0x44, 0x43,
	0x4e, 0xd0, 0x06, 0x9c, 0x2b, 0x64, 0xdf, 0x26, 0x8c, 0x51, 0x96, 0x81, 0xd6, 0x5b, 0x48, 0x85,
	0xc7, 0x22, 0xc7, 0xb8, 0x9f, 0x35, 0x69, 0xf7, 0xec, 0x68, 0x5d, 0xd6, 0x53, 0x75, 0xf4, 0x09,
	0x9c, 0x60, 0x84, 0x27, 0x7e, 0xac, 0x5a, 0xc3, 0x3a, 0xba, 0x35, 0xc6, 0x86, 0x95, 0xf8, 0x71,
	0x57, 0x41, 0xe9, 0x77, 0xa0, 0x51, 0xa5, 0x34, 0x59, 0xcf, 0xaf, 0xc1, 0xe5, 0x0e, 0x09, 0xd3,
	0x5c, 0x90, 0x0d, 0xca, 0x88, 0x83, 0x79, 0xbc, 0x45, 0x62, 0xe6, 0x39, 0xc3, 0xbe, 0xbf, 0x0a,
	0x73, 0xf9, 0xb7, 0x2f, 0x51, 0xea, 0xfd, 0x03, 0x87, 0xfa, 0x9f, 0x35, 0xb8, 0x52, 0x89, 0x22,
	0xf3, 0xe8, 0x03, 0x72, 0x70, 0x10, 0x61, 0xaf, 0x17, 0xda, 0x7b, 0x52, 0x87, 0x37, 0xb4, 0x2c,
	0x15, 0xb7, 0x8f, 0xf5, 0x4a, 0xd6, 0x24, 0x8c, 0xf2, 0xd4, 0x9d, 0x77, 0x0a, 0x12, 0x8e, 0xbe,
	0x00, 0x84, 0x5d, 0xbb, 0xc7, 0x68, 0x12, 0xe5, 0xbc, 0x89, 0xc4, 0xaf, 0x1c, 0xcb, 0x5b, 0xdb,
	0xed, 0xa4, 0x28, 0x43, 0x67, 0x67, 0xf0, 0xa8, 0x80, 0x23, 0x0f, 0xe6, 0x55, 0x82, 0x0e, 0x5c,
	0xcd, 0x4c, 0xe1, 0x4a, 0x1e, 0x0f, 0x5c, 0xf5, 0x47, 0x05, 0x5c, 0xff, 0x45, 0x83, 0x8b, 0x87,
	0x64, 0x02, 0x6d, 0xc3, 0xb9, 0xd1, 0x21, 0x2f, 0x15, 0xe4, 0xab, 0xbc, 0x54, 0x7a, 0xcd, 0xf7,
	0x63, 0xe6, 0x85, 0xbd, 0x1d, 0xec, 0x27, 0xa4, 0x7b, 0xb6, 0x5f, 0x46, 0x46, 0x0f, 0x60, 0xbe,
	0x54, 0x36, 0xf9, 0x32, 0x6f, 0x1e, 0x4d, 0xae, 0xd8, 0x0c, 0x67, 0x8a, 0x95, 0xd2, 0x7f, 0xd6,
	0xa0, 0x59, 0x9d, 0x6d, 0x74, 0xaf, 0x40, 0x48, 0x15, 0x75, 0x22, 0x42, 0xa8, 0x5f, 0x02, 0x46,
	0x9f, 0xc1, 0x7c, 0xa9, 0x31, 0xa6, 0xe7, 0x73, 0xba, 0xd0, 0x0c, 0xfa, 0x6f, 0xa3, 0x74, 0x0a,
	0x15, 0x45, 0x0f, 0xe0, 0xb5, 0xb1, 0x74, 0x6c, 0x29, 0x9d, 0x88, 0xd6, 0x85, 0x32, 0x2d, 0xe9,
	0x07, 0xed, 0xc2, 0x99, 0x62, 0x2b, 0xbe, 0x00, 0xb9, 0x42, 0xfb, 0xe9, 0x3f, 0xd6, 0xe0, 0x74,
	0x41, 0x09, 0xbd, 0x03, 0x75, 0x2f, 0x88, 0x18, 0xe1, 0x3c, 0xfb, 0xd5, 0xab, 0x8a, 0xff, 0x3d,
	0x9a, 0x3c, 0xf4, 0x89, 0x88, 0x3f, 0x6f, 0x80, 0x0c, 0x98, 0x71, 0x62, 0x26, 0x83, 0x3c, 0xdc,
	0x2e, 0x55, 0x44, 0x2b, 0x50, 0xc7, 0x03, 0xc2, 0x70, 0x8f, 0xd8, 0x4e, 0xe4, 0xc8, 0x21, 0x7c,
	0xb1, 0x64, 0x77, 0x37, 0x8c, 0x97, 0x6e, 0x09, 0x33, 0x90, 0xfa, 0x6b, 0x91, 0x83, 0x6e, 0xc1,
	0xac, 0xe3, 0x7b, 0x4e, 0x9f, 0x37, 0x5e, 0x9a, 0xc0, 0xa1, 0xd4, 0x4d, 0x7d, 0x3a, 0x94, 0xc7,
	0x76, 0xe0, 0x39, 0x8c, 0xf2, 0xc6, 0xec, 0x04, 0x3e, 0x53, 0xfd, 0xad, 0x4c, 0x5d, 0x5f, 0x87,
	0x05, 0x35, 0x1b, 0x37, 0x3d, 0x1e, 0x53, 0xe6, 0x39, 0xd8, 0x3f, 0xfe, 0x8c, 0xfd, 0x4a, 0x83,
	0xab, 0x87, 0xe0, 0xc8, 0x29, 0x6b, 0xc3, 0x89, 0x40, 0x88, 0xe4, 0x68, 0x5d, 0x9f, 0x66, 0x02,
	0x95, 0xf1, 0x15, 0xaa, 0xfe, 0x5c, 0x83, 0x6b, 0x13, 0x18, 0xa0, 0x3b, 0x30, 0xc7, 0x09, 0x66,
	0xce, 0xe7, 0xf6, 0xa3, 0x84, 0xb0, 0xfd, 0x89, 0x1a, 0xbb, 0x2e, 0x2c, 0x3e, 0x4e, 0x0d, 0x10,
	0x01, 0xd5, 0x7f, 0xb6, 0x62, 0x24, 0x9a, 0xa4, 0x7a, 0xa6, 0xca, 0x95, 0x36, 0xbf, 0x0d, 0x94,
	0x88, 0x9c, 0x92, 0xa0, 0xf2, 0xbb, 0xf5, 0xdd, 0x09, 0x40, 0x39, 0x83, 0xfb, 0x22, 0x29, 0xe8,
	0x07, 0x0d, 0x4e, 0x8d, 0x6e, 0x92, 0xe8, 0xad, 0xa3, 0x33, 0x39, 0x76, 0xf7, 0x6c, 0x1e, 0x73,
	0x83, 0xd1, 0x97, 0xbe, 0xfc, 0xf5, 0x8f, 0x6f, 0x6a, 0x6f, 0x20, 0x23, 0x5d, 0xc0, 0x9f, 0x8c,
	0xfc, 0x84, 0xdf, 0x56, 0xeb, 0x26, 0x37, 0x17, 0xcd, 0x5c, 0x77, 0x70, 0x73, 0xf1, 0x29, 0x7a,
	0xae, 0x01, 0x2a, 0x2f, 0x03, 0x68, 0x79, 0xba, 0x3d, 0x43, 0xc4, 0xbe, 0x32, 0xe5, 0x92, 0x92,
	0x75, 0xa3, 0xbe, 0x92, 0x31, 0x59, 0xd2, 0x6f, 0x66, 0x7f, 0x42, 0x86, 0xa1, 0x3f, 0xc9, 0xed,
	0xd1, 0xb7, 0x17, 0x9f, 0x8e, 0x10, 0xb1, 0x82, 0x0c, 0xce, 0xd2, 0x16, 0xd1, 0xdf, 0x1a, 0x9c,
	0xaf, 0xd8, 0x2a, 0xd0, 0xbb, 0x93, 0x14, 0xe3, 0xb0, 0xb5, 0xa6, 0xd9, 0x7e, 0x01, 0x04, 0x49,
	0x6f, 0x3b, 0xa3, 0xf7, 0xbe, 0xbe, 0x9e, 0x15, 0x2a, 0xff, 0x80, 0x0f, 0xab, 0x93, 0xd5, 0x1b,
	0x0f, 0x9b, 0x52, 0xfe, 0x47, 0x83, 0x0b, 0x95, 0x8f, 0x1c, 0xad, 0x4e, 0x1e, 0x72, 0xd5, 0xa4,
	0x69, 0xae, 0xbd, 0x10, 0x86, 0x24, 0xde, 0xcd, 0x88, 0x7f, 0xa8, 0x77, 0xa6, 0x23, 0x5e, 0x02,
	0xb6, 0xb4, 0xc5, 0xe6, 0xc5, 0x67, 0xed, 0xc6, 0x41, 0x3c, 0xf2, 0x14, 0x79, 0x3c, 0x7d, 0xd5,
	0xab, 0xff, 0x6a, 0x70, 0xdd, 0xa1, 0xc1, 0x91, 0xb1, 0xaf, 0x9e, 0x2f, 0xbf, 0xe5, 0xed, 0x74,
	0xd4, 0x6c, 0x6b, 0x9f, 0x6e, 0x4a, 0xe3, 0x1e, 0xf5, 0x71, 0xd8, 0x33, 0x28, 0xeb, 0x99, 0x3d,
	0x12, 0x66, 0x83, 0xc8, 0x3c, 0x70, 0x57, 0xfd, 0xdf, 0x7c, 0x59, 0x1d, 0xbe, 0xad, 0xcd, 0x74,
	0xda, 0xed, 0xef, 0x6b, 0x0b, 0x1d, 0x01, 0xd8, 0x76, 0xb9, 0x21, 0x8e, 0xe9, 0x69, 0xa7, 0x65,
	0x48, 0xc7, 0xfc, 0x99, 0x52, 0xd9, 0x6d, 0xbb, 0x7c, 0x77, 0xa8, 0xb2, 0xbb, 0xd3, 0xda, 0x55,
	0x2a, 0x7f, 0xd5, 0xae, 0x0b, 0xb9, 0x65, 0xb5, 0x5d, 0x6e, 0x59, 0x43, 0x25, 0xcb, 0xda, 0x69,
	0x59, 0x96, 0x52, 0x7b, 0x38, 0x9b, 0xc5, 0xf9, 0xe6, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x03,
	0xdd, 0x7b, 0xcd, 0x42, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KeywordPlanServiceClient is the client API for KeywordPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeywordPlanServiceClient interface {
	// Returns the requested plan in full detail.
	GetKeywordPlan(ctx context.Context, in *GetKeywordPlanRequest, opts ...grpc.CallOption) (*resources.KeywordPlan, error)
	// Creates, updates, or removes keyword plans. Operation statuses are
	// returned.
	MutateKeywordPlans(ctx context.Context, in *MutateKeywordPlansRequest, opts ...grpc.CallOption) (*MutateKeywordPlansResponse, error)
	// Returns the requested Keyword Plan forecasts.
	GenerateForecastMetrics(ctx context.Context, in *GenerateForecastMetricsRequest, opts ...grpc.CallOption) (*GenerateForecastMetricsResponse, error)
	// Returns the requested Keyword Plan historical metrics.
	GenerateHistoricalMetrics(ctx context.Context, in *GenerateHistoricalMetricsRequest, opts ...grpc.CallOption) (*GenerateHistoricalMetricsResponse, error)
}

type keywordPlanServiceClient struct {
	cc *grpc.ClientConn
}

func NewKeywordPlanServiceClient(cc *grpc.ClientConn) KeywordPlanServiceClient {
	return &keywordPlanServiceClient{cc}
}

func (c *keywordPlanServiceClient) GetKeywordPlan(ctx context.Context, in *GetKeywordPlanRequest, opts ...grpc.CallOption) (*resources.KeywordPlan, error) {
	out := new(resources.KeywordPlan)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.KeywordPlanService/GetKeywordPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) MutateKeywordPlans(ctx context.Context, in *MutateKeywordPlansRequest, opts ...grpc.CallOption) (*MutateKeywordPlansResponse, error) {
	out := new(MutateKeywordPlansResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.KeywordPlanService/MutateKeywordPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateForecastMetrics(ctx context.Context, in *GenerateForecastMetricsRequest, opts ...grpc.CallOption) (*GenerateForecastMetricsResponse, error) {
	out := new(GenerateForecastMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.KeywordPlanService/GenerateForecastMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateHistoricalMetrics(ctx context.Context, in *GenerateHistoricalMetricsRequest, opts ...grpc.CallOption) (*GenerateHistoricalMetricsResponse, error) {
	out := new(GenerateHistoricalMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.KeywordPlanService/GenerateHistoricalMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeywordPlanServiceServer is the server API for KeywordPlanService service.
type KeywordPlanServiceServer interface {
	// Returns the requested plan in full detail.
	GetKeywordPlan(context.Context, *GetKeywordPlanRequest) (*resources.KeywordPlan, error)
	// Creates, updates, or removes keyword plans. Operation statuses are
	// returned.
	MutateKeywordPlans(context.Context, *MutateKeywordPlansRequest) (*MutateKeywordPlansResponse, error)
	// Returns the requested Keyword Plan forecasts.
	GenerateForecastMetrics(context.Context, *GenerateForecastMetricsRequest) (*GenerateForecastMetricsResponse, error)
	// Returns the requested Keyword Plan historical metrics.
	GenerateHistoricalMetrics(context.Context, *GenerateHistoricalMetricsRequest) (*GenerateHistoricalMetricsResponse, error)
}

func RegisterKeywordPlanServiceServer(s *grpc.Server, srv KeywordPlanServiceServer) {
	s.RegisterService(&_KeywordPlanService_serviceDesc, srv)
}

func _KeywordPlanService_GetKeywordPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeywordPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GetKeywordPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.KeywordPlanService/GetKeywordPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GetKeywordPlan(ctx, req.(*GetKeywordPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_MutateKeywordPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateKeywordPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).MutateKeywordPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.KeywordPlanService/MutateKeywordPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).MutateKeywordPlans(ctx, req.(*MutateKeywordPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateForecastMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateForecastMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateForecastMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.KeywordPlanService/GenerateForecastMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateForecastMetrics(ctx, req.(*GenerateForecastMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateHistoricalMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateHistoricalMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateHistoricalMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.KeywordPlanService/GenerateHistoricalMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateHistoricalMetrics(ctx, req.(*GenerateHistoricalMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeywordPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.KeywordPlanService",
	HandlerType: (*KeywordPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetKeywordPlan",
			Handler:    _KeywordPlanService_GetKeywordPlan_Handler,
		},
		{
			MethodName: "MutateKeywordPlans",
			Handler:    _KeywordPlanService_MutateKeywordPlans_Handler,
		},
		{
			MethodName: "GenerateForecastMetrics",
			Handler:    _KeywordPlanService_GenerateForecastMetrics_Handler,
		},
		{
			MethodName: "GenerateHistoricalMetrics",
			Handler:    _KeywordPlanService_GenerateHistoricalMetrics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/keyword_plan_service.proto",
}
