/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef IMAGE_H
#define IMAGE_H

/*
 * wrapper around an XImage; this is all used to allow it to be
 * transparent whether this is going to be used as a shm image
 * or not.  image_t's are only usable on one screen.
 */
struct image {
	XImage		*ximage;	/* the ximage structure */
	screen_t	*screen;	/* screen this is usable on */
	int		shmimg;		/* flag if this is an shm ximage */
	XShmSegmentInfo	*shminfo;
};

void image_init();
image_t *image_create(screen_t *screen, int width, int height);
image_t *image_frompixmap(pixmap_t *pixmap, screen_t *screen);
void image_destroy(image_t *image);
void image_put(image_t *image, Drawable d, GC gc, int src_x, int src_y,
	int dest_x, int dest_y, int width, int height);
image_t *image_clone(image_t *src);
image_t *image_scale(image_t *src, int width, int height);

#endif
