/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef WM_H
#define WM_H

/* configure script generated header */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

/* malloc debugging */
#ifdef USE_DMALLOC
# include <dmalloc.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/cursorfont.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/xpm.h>
#include <X11/keysym.h>
#include <X11/extensions/shape.h>
#include <X11/extensions/XShm.h>

#include <sys/param.h>
#include <sys/time.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/wait.h>

#include <assert.h>
#include <dlfcn.h>
#include <errno.h>
#include <inttypes.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_PATHS_H
# include <paths.h>
#else
# define _PATH_BSHELL	"/bin/sh"
#endif

/*
 * some systems don't have the BSD err/warn
 * functions; the bsd_queue.h is always used
 * because even on systems that do have sys/queue.h
 * it's pretty variable what exactly will be in
 * sys/queue.h.
 */
#include "bsd_err.h"
#include "bsd_queue.h"

#include "forward.h"
#include "util.h"
#include "trace.h"
#include "main.h"
#include "screen.h"
#include "stacking.h"
#include "workspace.h"
#include "desktop.h"
#include "pixmap.h"
#include "image.h"
#include "client.h"
#include "event.h"
#include "action.h"
#include "draw.h"
#include "decor.h"
#include "dgroup.h"
#include "placement.h"
#include "rcfile.h"
#include "keys.h"
#include "plugin.h"
#include "focus.h"
#include "rect.h"
#include "xinerama.h"
#include "options.h"

/* internationalization */
#ifdef I18N
# include "i18n.h"
#endif

#define VERSION		"0.0.5"

#endif
