#include <config.h>
#include <string.h>
#include <gtk/gtk.h>
#include <goocanvas.h>


static gboolean
on_focus_in (GooCanvasItemView *view,
	     GooCanvasItemView *target,
	     GdkEventFocus *event,
	     gpointer data)
{
  GooCanvasItem *item;
  gchar *id;

  item = goo_canvas_item_view_get_item (view);
  id = g_object_get_data (G_OBJECT (item), "id");

  g_print ("%s received focus-in event\n", id ? id : "unknown");

  /* Note that this is only for testing. Setting item properties to indicate
     focus isn't a good idea for real apps, as there may be multiple views. */
  g_object_set (item, "stroke-color", "black", NULL);

  return FALSE;
}


static gboolean
on_focus_out (GooCanvasItemView *view,
	      GooCanvasItemView *target,
	      GdkEventFocus *event,
	      gpointer data)
{
  GooCanvasItem *item;
  gchar *id;

  item = goo_canvas_item_view_get_item (view);
  id = g_object_get_data (G_OBJECT (item), "id");

  g_print ("%s received focus-out event\n", id ? id : "unknown");

  /* Note that this is only for testing. Setting item properties to indicate
     focus isn't a good idea for real apps, as there may be multiple views. */
  g_object_set (item, "stroke-pattern", NULL, NULL);

  return FALSE;
}


static gboolean
on_button_press (GooCanvasItemView *view,
		 GooCanvasItemView *target,
		 GdkEventButton *event,
		 gpointer data)
{
  GooCanvasItem *item;
  GooCanvasView *canvas_view;
  gchar *id;

  item = goo_canvas_item_view_get_item (view);
  id = g_object_get_data (G_OBJECT (item), "id");

  g_print ("%s received button-press event\n", id ? id : "unknown");

  canvas_view = goo_canvas_item_view_get_canvas_view (view);
  goo_canvas_view_grab_focus (canvas_view, view);

  return TRUE;
}


static gboolean
on_key_press (GooCanvasItemView *view,
	      GooCanvasItemView *target,
	      GdkEventKey *event,
	      gpointer data)
{
  GooCanvasItem *item;
  gchar *id;

  item = goo_canvas_item_view_get_item (view);
  id = g_object_get_data (G_OBJECT (item), "id");

  g_print ("%s received key-press event\n", id ? id : "unknown");

  return FALSE;
}


static void
on_item_view_created (GooCanvasView     *view,
		      GooCanvasItemView *item_view,
		      GooCanvasItem     *item,
		      gpointer           data)
{
  if (GOO_IS_CANVAS_RECT (item))
    {
      g_object_set (item_view, "can-focus", TRUE, NULL);

      g_signal_connect (item_view, "focus_in_event",
			(GtkSignalFunc) on_focus_in, NULL);
      g_signal_connect (item_view, "focus_out_event",
			(GtkSignalFunc) on_focus_out, NULL);

      g_signal_connect (item_view, "button_press_event",
			(GtkSignalFunc) on_button_press, NULL);

      g_signal_connect (item_view, "key_press_event",
			(GtkSignalFunc) on_key_press, NULL);
    }
}


static GooCanvasModelSimple*
create_canvas_model (void)
{
  GooCanvasModelSimple *canvas_model;
  GooCanvasItem *root, *item;

  canvas_model = goo_canvas_model_simple_new ();

  root = goo_canvas_model_get_root_item (GOO_CANVAS_MODEL (canvas_model));

  item = goo_canvas_rect_new (root, 110, 80, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "red",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "red");

  item = goo_canvas_rect_new (root, 300, 160, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "orange",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "orange");

  item = goo_canvas_rect_new (root, 500, 50, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "yellow",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "yellow");

  item = goo_canvas_rect_new (root, 70, 400, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "blue",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "blue");

  item = goo_canvas_rect_new (root, 130, 200, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "magenta",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "magenta");

  item = goo_canvas_rect_new (root, 200, 160, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "green",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "green");

  item = goo_canvas_rect_new (root, 450, 450, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "cyan",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "cyan");

  item = goo_canvas_rect_new (root, 300, 350, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "grey",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "grey");

  item = goo_canvas_rect_new (root, 900, 900, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "gold",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "gold");

  item = goo_canvas_rect_new (root, 800, 150, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "thistle",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "thistle");

  item = goo_canvas_rect_new (root, 600, 800, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "azure",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "azure");

  item = goo_canvas_rect_new (root, 700, 250, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "moccasin",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "moccasin");

  item = goo_canvas_rect_new (root, 500, 100, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "cornsilk",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "cornsilk");

  item = goo_canvas_rect_new (root, 200, 750, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "plum",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "plum");

  item = goo_canvas_rect_new (root, 400, 800, 50, 30,
			      "stroke-pattern", NULL,
			      "fill-color", "orchid",
			      "line-width", 5.0,
			      NULL);
  g_object_set_data (G_OBJECT (item), "id", "orchid");

  return canvas_model;
}


GtkWidget *
create_focus_page (void)
{
  GtkWidget *vbox, *label, *scrolled_win, *canvas;
  GooCanvasModelSimple *canvas_model;

  vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 4);
  gtk_widget_show (vbox);

  label = gtk_label_new ("Use Tab, Shift+Tab or the arrow keys to move the keyboard focus between the canvas items.");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_win),
				       GTK_SHADOW_IN);
  gtk_widget_show (scrolled_win);
  gtk_container_add (GTK_CONTAINER (vbox), scrolled_win);

  canvas = goo_canvas_view_new ();
  GTK_WIDGET_SET_FLAGS (canvas, GTK_CAN_FOCUS);
  gtk_widget_set_size_request (canvas, 600, 450);
  goo_canvas_view_set_bounds (GOO_CANVAS_VIEW (canvas), 0, 0, 1000, 1000);
  gtk_widget_show (canvas);
  gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);

  g_signal_connect (canvas, "item_view_created",
		    (GtkSignalFunc) on_item_view_created,
		    NULL);

  canvas_model = create_canvas_model ();
  goo_canvas_view_set_model (GOO_CANVAS_VIEW (canvas),
			     GOO_CANVAS_MODEL (canvas_model));
  g_object_unref (canvas_model);

  return vbox;
}
