# gozerbot/aliases.py
#
#

""" command aliases """

__copyright__ = 'this file is in the public domain'

from gozerbot.datadir import datadir
from gozerbot.persist import Persist
from gozerbot.generic import lockdec
import os, thread

aliases = Persist(datadir + os.sep + 'aliases') # aliases
if not aliases.data:
    aliases.data = {}

aliaslock = thread.allocate_lock()
locked = lockdec(aliaslock)

def aliasreverse(what):
    """ get the reverse of an alias """
    for i, j in aliases.data.iteritems():
        if what == j:
            return i

def aliascheck(ievent):
    """ check if alias is available """
    try:
        cmnd = ievent.txt.split()[0]
        alias = aliases.data[cmnd]
        ievent.txt = ievent.txt.replace(cmnd, alias, 1)
        ievent.alias = alias
    except:
        pass

@locked
def aliassave():
    aliases.save()

@locked
def aliasset(fromm, to):
    aliases.data[fromm] = to

@locked
def aliasdel(fromm):
    try:
        del aliases.data[fromm]
        aliases.save()
        return 1
    except KeyError:
        pass

def aliasget(fromm):
    if aliases.data.has_key(fromm): 
        return aliases.data[fromm]
