# gozerbot/persist.py
#
#

""" allow data to be pickled to disk .. creating the persisted object
    restores data
"""

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, handle_exception
import pickle, thread, os, copy

saving = []
stopsave = 0

class Persist(object):

    """ persist data attribute to pickle file """

    def __init__(self, filename, default=None):
        rlog(1, 'persist', 'reading %s' % filename)
        self.fn = filename
        self.lock = thread.allocate_lock()
        self.data = None
        # see if we can open pickle file
        try:
            datafile = open(filename, 'r')
        except IOError:
            if default != None:
                self.data = copy.deepcopy(default)
            return
        # load data from pickled file
        try:
            self.data = pickle.load(datafile)
            datafile.close()
        except:
            rlog(100, 'persist', 'ERROR: %s' % filename)
            handle_exception()
            self.data = copy.deepcopy(default)
            return
        # set default
        if not self.data:
            if default != None:
                self.data = copy.deepcopy(default)

    def save(self):
        """ save persist data """
        if stopsave:
            rlog(100, 'persist', 'stopping mode .. not saving %s' % self.fn)
            return
        try:
            saving.append(str(self.fn))
            self.lock.acquire()
            # first save to temp file and when done rename
            tmp = self.fn + '.tmp'
            try:
                datafile = open(tmp, 'w')
            except IOError:
                rlog(100, 'persist', "can't save %s" % self.fn)
                return
            pickle.dump(self.data, datafile)
            datafile.close()
            os.rename(tmp, self.fn)
            rlog(2, 'persist', '%s saved' % self.fn)
        finally:
            saving.remove(self.fn)
            self.lock.release()
