# dbplugs/quote.py
#
#

""" quote plugin """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import handle_exception
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliases
from gozerbot.db import db
from gozerplugs.dbplugs.karma import karma
import random, time, re

plughelp.add('quote', 'manage quotes')

class Quotes(object):

    """ quotes db interface """

    def size(self):
        """ return nr of quotes """
        result = db.execute(""" SELECT COUNT(*) FROM quotes """)
        return result[0][0]

    def add(self, nick, userhost, quote):
        """ add a quote """
        result = db.execute(""" INSERT INTO quotes(quote, userhost, \
createtime, nick) VALUES (%s, %s, %s, %s) """, (quote, userhost, \
time.time(), nick))
        return result

    def delete(self, quotenr):
        """ delete quote with id == nr """
        result = db.execute(""" DELETE FROM quotes WHERE indx = %s """, \
quotenr)
        return result

    def random(self):
        """ get random quote """
        result = db.execute(""" SELECT indx FROM quotes """)
        indices = []
        if not result:
            return
        for i in result:
            indices.append(i[0])
        if indices:
            idnr = random.choice(indices)
            return self.idquote(idnr)

    def idquote(self, quotenr):
        """ get quote by id """
        if quotenr == 0:
            return None
        result = db.execute(""" SELECT indx, quote FROM quotes WHERE \
indx = %s """, quotenr)
        if result:
            return result[0]

    def whoquote(self, quotenr):
        """ get who quoted the quote """
        result = db.execute(""" SELECT nick, createtime FROM quotes WHERE \
indx = %s """, quotenr)
        if result:
            return result[0]

    def last(self, nr):
        """ get last quote """
        result = db.execute(""" SELECT indx, quote FROM quotes ORDER BY \
indx DESC LIMIT %s """, (nr, ))
        return result

    def search(self, what):
        """ search quotes """
        result = db.execute(""" SELECT indx, quote FROM quotes WHERE \
quote LIKE %s """, '%%%s%%' % what)
        return result

    def searchlast(self, what, nr):
        """ search quotes """
        result = db.execute(""" SELECT indx, quote FROM quotes WHERE \
quote LIKE %s ORDER BY indx DESC LIMIT %s """, ('%%%s%%' % what, nr))
        return result

quotes = Quotes()

def size():
    return quotes.size()

def handle_quoteadd(bot, ievent):
    """ quote-add <txt> .. command that adds a quote """
    if not ievent.rest:
        ievent.missing("<txt>")
        return
    result = 0
    try:
        result = quotes.add(ievent.nick, ievent.userhost, ievent.rest)
    except Exception, ex:
        handle_exception()
        ievent.reply('ERROR: %s' % str(ex))
    if result:
        ievent.reply('quote added')
    else:
        ievent.reply('add failed')

cmnds.add('quote-add', handle_quoteadd, ['USER', 'QUOTEADD'], allowqueue=False)
examples.add('quote-add', 'quote-add <txt> .. add quote', 'quote-add mekker')
aliases.data['aq'] = 'quote-add'

def handle_quotewho(bot, ievent):
    """ quote-who <nr> .. command that shows who added a quote """
    try:
        quotenr = int(ievent.args[0])
    except (IndexError, ValueError):
        ievent.missing("<nr>")
        return
    result = 0
    try:
        result = quotes.whoquote(quotenr)
    except Exception, ex:
        handle_exception()
        ievent.reply('ERROR: %s' % str(ex))
        return
    if result:
        ievent.reply('quote #%s was made by %s on %s' % (quotenr, \
result[0], time.ctime(result[1])))
    else:
        ievent.reply('no who quote data available')

cmnds.add('quote-who', handle_quotewho, ['USER', 'WEB', 'ANON'])
examples.add('quote-who', 'quote-who <nr> .. show who quoted <quotenr>', \
'quote-who 1')
aliases.data['wq'] = 'quote-who'

def handle_quotedel(bot, ievent):
    """ quote-del <nr> .. delete quote by id """
    try:
        quotenr = int(ievent.args[0])
    except (IndexError, ValueError):
        ievent.missing('<nr>')
        return
    result = 0
    try:
        result = quotes.delete(quotenr)
    except Exception, ex:
        handle_exception()
        ievent.reply('ERROR: %s' % str(ex))
        return
    if result:
        ievent.reply('quote deleted')
    else:
        ievent.reply('delete of quote %s failed' % quotenr)

cmnds.add('quote-del', handle_quotedel, ['QUOTEDEL', 'OPER', 'QUOTE'])
examples.add('quote-del', 'quote-del <nr> .. delete quote with id <nr>', \
'quote-del 2')
aliases.data['dq'] = 'quote-del'

def handle_quotelast(bot, ievent):
    """ quote-last .. show last quote """
    search = ""
    try:
        (nr, search) = ievent.args
        nr = int(nr)
    except:
        try:
            nr = ievent.args[0]
            nr = int(nr)
        except (IndexError, ValueError):
            nr = 1
            try:
                search = ievent.args[0]
            except IndexError:
                search = ""
    if nr < 1 or nr > 4:
        ievent.reply('nr needs to be between 1 and 4')
        return
    search = re.sub('^d','', search)
    if search:
        quotelist = quotes.searchlast(search, nr)
    else:
        quotelist = quotes.last(nr)
    if quotelist:
        result = []
        for i in quotelist:
            qkarma = karma.get('quote %s' % i[0])
            if qkarma:
                ievent.reply('#%s (%s) %s' % (i[0], qkarma, i[1]))
            else:
                ievent.reply('#%s %s' % (i[0], i[1]))
    else:
        ievent.reply("can't fetch quote")

cmnds.add('quote-last', handle_quotelast, ['USER', 'WEB', 'ANON'])
examples.add('quote-last', 'show last quote', 'quote-last')
aliases.data['lq'] = 'quote-last'

def handle_quote2(bot, ievent):
    """ quote-2 .. show 2 random quotes """
    got = []
    quote = quotes.random()
    if quote != None:
        qkarma = karma.get('quote %s' % quote[0])
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote[0], qkarma, quote[1]))
        else:
            ievent.reply('#%s %s' % (quote[0], quote[1]))
        got.append(quote[0])
    for i in range(10):
        quote = quotes.random()
        if quote != None:
            if quote[0] in got:
                continue
            else:
                break
    qkarma = karma.get('quote %s' % quote[0])
    if qkarma:
        ievent.reply('#%s (%s) %s' % (quote[0], qkarma, quote[1]))
    else:
        ievent.reply('#%s %s' % (quote[0], quote[1]))

cmnds.add('quote-2', handle_quote2, ['USER', 'WEB', 'ANON'])
examples.add('quote-2', 'show 2 quotes', 'quote-2')
aliases.data['2q'] = 'quote-2'

def handle_quoteid(bot, ievent):
    """ quote-id <nr> .. show quote by id """
    try:
        quotenr = int(ievent.args[0])
    except (IndexError, ValueError):
        ievent.missing('<nr>')
        return
    quote = quotes.idquote(quotenr)
    if quote != None:
        qkarma = karma.get('quote %s' % quote[0])
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote[0], qkarma, quote[1]))
        else:
            ievent.reply('#%s %s' % (quote[0], quote[1]))
    else:
        ievent.reply("can't fetch quotenr %s" % quotenr)

cmnds.add('quote-id', handle_quoteid, ['USER', 'WEB', 'ANON'])
examples.add('quote-id', 'quote-id <nr> .. get quote on id <nr> ', \
'quote-id 2')
aliases.data['iq'] = 'quote-id'

def handle_quote(bot, ievent):
    """ quote .. show random quote """
    quote = quotes.random()
    if quote != None:
        qkarma = karma.get('quote %s' % quote[0])
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote[0], qkarma, quote[1]))
        else:
            ievent.reply('#%s %s' % (quote[0], quote[1]))
    else:
        ievent.reply('no quotes yet')

cmnds.add('quote', handle_quote, ['USER', 'WEB', 'ANON'])
examples.add('quote', 'show random quote', 'quote')
aliases.data['q'] = 'quote'

def handle_quotesearch(bot, ievent):
    """ quote-searcg <txt> .. search quotes for <txt>"""
    if not ievent.rest:
        ievent.missing('<txt>')
        return
    else:
        what = ievent.rest
        nrtimes = 3
    result = quotes.search(what)
    if result:
        if ievent.queues:
            res = []
            for quote in result:
                res.append('#%s %s' % quote)
            ievent.reply(res)
            return
        if nrtimes > len(result):
            nrtimes = len(result)
        randquotes = random.sample(result, nrtimes)
        for quote in randquotes:
            qkarma = karma.get('quote %s' % quote[0])
            if qkarma:
                ievent.reply('#%s (%s) %s' % (quote[0], qkarma, quote[1]))
            else:
                ievent.reply("#%s %s" % (quote[0], quote[1]))
    else:
        ievent.reply('no quotes found with %s' % what)

cmnds.add('quote-search', handle_quotesearch, ['USER', 'WEB', 'ANON'])
examples.add('quote-searcg', 'quote-search <txt> .. search quotes for <txt>', \
'quote-search bla')
aliases.data['sq'] = 'quote-search'

def handle_quotescount(bot, ievent):
    """ quote-count .. show number of quotes """
    ievent.reply('quotes count is %s' % quotes.size())

cmnds.add('quote-count', handle_quotescount, ['USER', 'WEB', 'ANON'])
examples.add('quote-count', 'count nr of quotes', 'quote-count')
aliases.data['cq'] = 'quote-count'

def handle_quotegood(bot, ievent):
    """ karma-good .. show top 10 karma items """
    result = karma.quotegood(limit=10)
    if not result:
        ievent.reply('quote karma void')
        return
    resultstr = ""
    for i in result:
        if i[1] > 0:
            resultstr += "%s: %s " % (i[0], i[1])
    if resultstr:
        ievent.reply('quote goodness: %s' % resultstr)

cmnds.add('quote-good', handle_quotegood, ['USER', 'WEB', 'ANON'])
examples.add('quote-good', 'show top 10 quote karma', 'quote-good')

def handle_quotebad(bot, ievent):
    """ karma-bad .. show lowest 10 quote karma items """
    result = karma.quotebad(limit=10)
    if not result:
        ievent.reply('quote karma void')
        return
    resultstr = ""
    for i in result:
        if i[1] < 0:
            resultstr += "%s: %s " % (i[0], i[1])
    if resultstr:
        ievent.reply('quote badness: %s' % resultstr)

cmnds.add('quote-bad', handle_quotebad, ['USER', 'WEB', 'ANON'])
examples.add('quote-bad', 'show lowest 10 quote karma', 'quote-bad')
