# plugins/autoreply.py
#
#

""" do an autoreply """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.callbacks import jcallbacks
from gozerbot.aliases import aliasset
from gozerbot.persistconfig import PersistConfig

cfg = PersistConfig()
cfg.define('txt', "")

def preautoreply(bot, ievent):
    if not ievent.usercmnd and cfg.get('txt') and not ievent.groupchat:
        return 1

def cbautoreply(bot, ievent):
    bot.say(ievent.userhost, cfg.get('txt'))

jcallbacks.add('Message', cbautoreply, preautoreply)

def handle_autoreplydisable(bot, ievent):
    cfg.set('txt', '')
    ievent.reply('autoreply is disabled')
    
cmnds.add('autoreply-disable', handle_autoreplydisable, 'OPER')

aliasset('autoreply-set', 'autoreply-cfg txt')
