# plugs/install.py
#
#

""" install plugins from remote site """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import geturl2, rlog, waitforuser, hostnamere, \
handle_exception, touch
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plugins import plugins
from gozerbot.config import config
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliases
import re, md5, urllib2, os, shutil

plughelp.add('install', 'install plugin from webserver')

# check if logs dir exists if not create it
if not os.path.isdir('myplugs'):
    os.mkdir('myplugs')
    touch('myplugs/__init__.py') 

def install(plugserver, dirr, what, ievent):
    """ install http://<plugserver>/<dir>/<plugin>.py from server """
    # fetch file signatures
    if not plugserver.startswith('http://'):
        plugserver = 'http://' + plugserver
    if what.endswith('.py'):
        what = what[:-3]
    try:
        sig = geturl2('%s/%s/signatures' % (plugserver, dirr))
    except urllib2.HTTPError:
        ievent.reply("can't find signatures file")
        return
    signatures = dict(re.findall('\((.*).py\) = (.*)', sig))
    # fetch plugin, check signature and save in plugs dir
    try:
        plug = geturl2('%s/%s/%s.py' % (plugserver, dirr, what))
    except urllib2.HTTPError:
        ievent.reply("no %s plugin on server" % what)
        return
    digest = md5.new(plug).hexdigest()
    try:
        digest2 = signatures[what]
    except KeyError:
        if ievent:
            ievent.reply("can't get md5 digest of %s" % what)
        else:
            rlog(10, 'install', "can't get md5 digest of %s" % what)
        return 0
    if not digest == digest2:
        if ievent:
            ievent.reply("md5 digest doesn't match .. not installing \
%s" % what)
        else:
            rlog(10, 'install', "md5 digest doesn't match .. not \
installing %s" % what)
        return 0
    plugfile = open('myplugs' + os.sep + '%s.py' % what,'w')
    plugfile.write(plug)
    plugfile.close()
    return 1

def handle_install(bot, ievent):
    """ install <server> <dir> <plugin> .. install plugin from server """
    if ievent.stripped != bot.owner:
        ievent.reply('only owneruserhost can use install')
        return
    try:
        (server, dirr, plug) = ievent.args
    except ValueError:
        if 'install-plug' in ievent.origtxt:
            ievent.missing("<server> <dir> <plug>")
        else:
            ievent.missing("<server> <dir> <plug> (maybe try install-plug ?)")
        return
    if not re.match(hostnamere, server):
        ievent.reply('%s is not a valid hostname' % server)
        return
    if plug.endswith('.py'):
        plug = plug[:-3]
    try:
        readme = geturl2("http://%s/%s/%s.README" % (server, dirr, plug))
        if readme:
            readme = readme.replace('\n', ' .. ')
            readme = re.sub('\s+', ' ', readme)
            readme += ' (yes/no)'
            ievent.reply(readme)
            response =  waitforuser(bot, ievent.userhost)
            if not response or response.txt != 'yes':
                ievent.reply('not installing %s' % plug)
                return
    except:
        pass
    ievent.reply('fetching %s' % plug)
    if not install(server, dirr, plug, ievent):
        ievent.reply('failed to install %s' % plug)
        return
    if plugins.reload('myplugs', plug):
        ievent.reply("%s reloaded" % plug)
    else:
        ievent.reply('reload of %s failed' % plug)

cmnds.add('install', handle_install, 'OPER')
examples.add('install', 'install <server> <dir> <plug>: install \
http://<plugserver>/<dir>/<plugin>.py from server (maybe try install-plug \
?)', 'install r8.cg.nu plugs dict')
aliases.data['install-plug'] = 'install r8.cg.nu plugs'

def handle_installlist(bot, ievent):
    """ install-list .. list the available remote installable plugs """
    if ievent.stripped != bot.owner:
        ievent.reply('only owneruserhost can use install')
        return
    try:
        plugserver = ievent.args[0]
    except IndexError:
        plugserver = config['pluginserver']
    if not plugserver:
        plugserver = 'http://r8.cg.nu'
    if not plugserver.startswith('http://'):
        plugserver = "http://" + plugserver
    pluglist = geturl2('%s/plugs/' % plugserver)
    result = re.findall('<a href="(.*?)\.py">', pluglist)
    try:
        result.remove('__init__')
    except ValueError:
        pass
    ievent.reply('available plugins: ', result, dot=True)

cmnds.add('install-list', handle_installlist, 'OPER')
examples.add('install-list', 'list plugins that can be installed', \
'install-list')

def handle_installsites(bot, ievent):
    ievent.reply("install sites: http://gozerbot.org/plugs (default) .. \
http://tehmaze.com/plugs")

cmnds.add('install-sites', handle_installsites, 'USER')
