# gozerbot lag meter
# (c) Wijnand 'tehmaze' Modderman - http://tehmaze.com
# BSD License

import time
from gozerbot.callbacks import callbacks
from gozerbot.commands import cmnds
from gozerbot.examples import examples 
from gozerbot.fleet import fleet
from gozerbot.plughelp import plughelp
import gozerbot.thr as thr

plughelp.add('lag', 'lag measuring')

lag_wait = 300

class Lagmeter:
    def __init__(self):
        self.names = []
        self.sent  = {}
        self.lag   = {}
        self.run   = True

    def update_names(self):
        self.names = [bot.name for bot in fleet.bots if bot.type == 'irc']

    def getlag(self, name):
        if self.lag.has_key(name):
            return self.lag[name]
        else:
            return False

    def getsent(self, name):
        if self.sent.has_key(name):
            return self.sent[name]
        else:
            return False

    def measure(self, name):
        bot = fleet.byname(name)
        if bot.connectok.isSet() and bot.connectok:
            bot.sendraw('ISON %s' % bot.nick)
            self.sent[name] = time.time()

    def recieved(self, name):
        sent = self.getsent(name)
        if sent:
            self.lag[name] = time.time() - sent

    def loop(self):
        while self.run:
            self.update_names()
            for name in self.names:
                self.measure(name)
            time.sleep(lag_wait)

lagmeters = Lagmeter()

def init():
    thr.start_new_thread(lagmeters.loop, ())
    return 1

def shutdown():
    lagmeters.run = False

def handle_lag(bot, ievent):
    lag = lagmeters.getlag(bot.name)
    if lag == False:
        ievent.reply('no lag metered')
    else:
        ievent.reply('lag is %f seconds' % lag)

def connectedcb(bot, ievent):
    lagmeters.update_names()
    lagmeters.measure(bot.name)

def isoncb(bot, ievent):
    lagmeters.recieved(bot.name) 

cmnds.add('lag', handle_lag, ['USER'])
examples.add('lag', 'shows the current lag', 'lag')
callbacks.add('001', connectedcb)
callbacks.add('303', isoncb)
