# gozerbot/jabbermsg.py
#
#

""" jabber message definition """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, toenc, fromenc, jabberstrip
from gozerbot.ircevent import makeargrest
import xmpp, types, time

class Jabbermsg(xmpp.Message):

    """ jabber message object """

    def __init__(self, msg=None):
        if msg:
            xmpp.Message.__init__(self, node=msg)
        else:
            xmpp.Message.__init__(self)
        self.jabber = True
        self.id = self.getID()
        self.bot = None
        self.botoutput = False
        rlog(2, 'jabbermsg', str(self))

    def __del__(self):
        if self.bot:
            self.bot.gcevents += 1

    def reply(self, txt, result=None, nick=None, dot=False, nritems=False, \
nr=False):
        """ reply txt .. first check if queue then if DCC then /msg
            otherwise assume channel
        """
        if result == []:
            return
        lt = False
        if type(txt) == types.ListType and not result:
            result = txt
            origtxt = ""
            lt = True
        else:
            origtxt = txt
        if result:
            lt = True
        if self.queues:
            for i in self.queues:
                if lt:
                    for j in result:
                        i.put_nowait(j)
                else:
                    i.put_nowait(txt)
            return
        pretxt = origtxt
        restxt = ""
        if lt:
            if nritems:
                if len(txt) > 1:
                    pretxt = "(%s items) .. " % len(result)
            txtlist = [str(i) for i in result]
            if not nr is False:
                try:
                    start = int(nr)
                except ValueError:
                    start = 0
                txtlist2 = []
                teller = start
                for i in txtlist:
                    txtlist2.append("%s) %s" % (teller, i))
                    teller += 1
                txtlist = txtlist2
            if dot == True:
                restxt = ' .. '.join(txtlist)
            elif dot:
                restxt = dot.join(txtlist)
            else:
                restxt = ' '.join(txtlist)
        if pretxt:
            restxt = pretxt + restxt
        txt = jabberstrip(restxt)
        if not txt:
            return
        what = txt
        txtlist = []
        start = 0
        end = 2000
        length = len(what)
        for i in range(length/end+1):
            endword = what.find(' ', end)
            if endword == -1:
                endword = end
            txtlist.append(what[start:endword])
            start = endword
            end = start + 2000
        size = 0
        # see if we need to store output in less cache
        if len(txtlist) > 1:
            self.bot.less.add(self.userhost, txtlist)
            size = len(txtlist) - 1
            result = txtlist[:1][0]
            if size:
                result += " (+%s)" % size
        else:
            result = txtlist[0]
        repl = self.buildReply(result)
        repl.setNamespace("jabber:client")
        if self.resource == 'jcoll':
            repl.setFrom(self.bot.jid.getStripped() + '/jcollres')
            repl.setTo(self.ruserhost.getStripped())
            self.bot.send(repl)
            return
        if self.groupchat:
            if self.resource == self.bot.nick:
                return
            if self.printto:
                repl.setTo(self.printto)
            else:
                repl.setTo(self.channel)
            repl.setType('groupchat')
        if self.bot.google:
            repl.setFrom(self.bot.me)
        repl.setID(self.id)
        self.bot.send(repl)

    def toirc(self, bot):
        """ set ircevent compat attributes """
        self.jidchange = False
        self.cmnd = 'Message'
        self.conn = None
        self.prefix = ""
        self.postfix = ""
        self.target = ""
        self.arguments = []
        self.resource = fromenc(self.getFrom().getResource())
        self.channel = fromenc(self.getFrom().getStripped())
        self.nick = self.resource
        self.user = ""
        try:
            self.jid = bot.jids[self.channel][self.resource]
            self.jidchange = True
        except KeyError:
            self.jid = self.getFrom()
        self.ruserhost = self.jid
        self.userhost = fromenc(str(self.jid))
        self.stripped = fromenc(self.jid.getStripped())
        self.printto = self.channel
        self.txt = jabberstrip(fromenc(self.getBody()))
        self.origtxt = self.txt
        self.to = fromenc(str(self.getTo()))
        self.time = time.time()
        self.msg = None
        self.args = []
        self.rest = ' '.join(self.args)
        self.usercmnd = 0
        self.bot = bot
        self.sock = None
        self.inqueue = None
        self.queues = []
        self.speed = 5
        self.options = {}
        self.groups = None
        self.type = self.getType()
        self.cc = ""
        self.alias = ""
        self.aliased = ""
        self.denied = False
        if self.type == 'groupchat':
            self.groupchat = True
        else:
            self.groupchat = False
            self.userhost = self.stripped
        self.bot.nrevents += 1
        
    def copyin(self, jmsg):
        """ copy in another jabber message object """
        self.jidchange = bool(jmsg.jidchange)
        self.cmnd = unicode(jmsg.cmnd)
        self.conn = jmsg.conn
        self.prefix = unicode(jmsg.prefix)
        self.postfix = unicode(jmsg.postfix)
        self.target = unicode(jmsg.target)
        self.arguments = unicode(jmsg.arguments)
        self.nick = unicode(jmsg.nick)
        self.user = unicode(jmsg.user)
        if not jmsg.jid:
            self.jid = xmpp.JID(jmsg.userhost)
        else:
            self.jid = jmsg.jid
        self.ruserhost = unicode(jmsg.ruserhost)
        self.userhost = unicode(jmsg.userhost)
        self.resource = unicode(jmsg.resource)
        self.stripped = jmsg.stripped
        self.channel = unicode(jmsg.channel)
        self.printto = unicode(jmsg.printto)
        self.txt = unicode(jmsg.txt)
        self.origtxt = unicode(jmsg.origtxt)
        self.to = unicode(jmsg.to)
        self.time = jmsg.time
        self.msg = jmsg.msg
        self.args = list(jmsg.args)
        self.rest = unicode(jmsg.rest)
        self.usercmnd = jmsg.usercmnd
        self.bot = jmsg.bot
        self.sock = jmsg.sock
        self.inqueue = jmsg.inqueue
        self.queues = list(jmsg.queues)
        self.printto = jmsg.printto
        self.speed = int(jmsg.speed)
        self.options = dict(jmsg.options)
        self.groups = jmsg.groups
        self.groupchat = jmsg.groupchat
        self.cc = unicode(jmsg.cc)
        self.alias = unicode(jmsg.alias)
        self.aliased = unicode(jmsg.aliased)
        self.denied = jmsg.denied

    def ircstr(self):
        """ return a ircevent repr compatible string """
        return "cmnd=%s printto=%s arguments=%s nick=%s user=%s \
userhost=%s channel=%s txt=%s args=%s rest=%s speed=%s" % (self.cmnd, \
self.printto, self.arguments, self.nick, self.user, \
self.userhost, self.channel, self.txt, self.args, self.rest, self.speed)

    def missing(self, txt):
        """ method to call when command arguments are missing """
        if self.origtxt:
            splitted = self.origtxt.split() 
            if self.bot.nick in splitted[0]:
                try:
                    cmnd = splitted[1]
                except IndexError:
                    cmnd = splitted[0] 
            elif 'cmnd' in splitted[0]:
                try:
                    cmnd = splitted[2]
                except IndexError:
                    cmnd = splitted[0]
            else:
                if not self.groupchat:
                    cmnd = splitted[0]
                else:
                    if self.aliased:
                        cmnd = self.aliased
                    else:
                        cmnd = splitted[0][1:]
            self.reply(cmnd + ' ' + txt)
        else:
            self.reply('missing origtxt: %s' % txt)
	