/***************************************************************************
                          gpc_app.h  -  description
                             -------------------
    begin                : Wed May 17 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <gnome.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "gpc_film.h"
#include "gpc_image.h"
#include "gpc_utils.h"

#include "pg_connection.h"
#include "pg_query.h"


#define DEBUG  1

GtkWidget    *gpc_app;

GtkWidget    *gpc_film_dialog;
GtkWidget    *gpc_image_dialog;
GtkWidget    *gpc_options_dialog;
GtkWidget    *gpc_query_dialog;


pgConnection *gpc_connection;
pgQuery      *gpc_films;
pgQuery      *gpc_images;

gboolean         gpc_query_mode;

GpcFilmInfos    *gpc_film_infos;
gboolean         gpc_film_modified;
GpcImageInfos   *gpc_image_infos;
gboolean         gpc_image_modified;

GtkWidget       *gpc_thumbnails_canvas;
GList           *gpc_thumbnails;

GnomeCanvasItem *gpc_image_canvas_item;
gfloat           gpc_image_zoom_factor;
gint             gpc_image_width;
gint             gpc_image_height;
GtkWidget       *gpc_image_canvas;
gint             gpc_image_canvas_width;
gint             gpc_image_canvas_height;

GtkCList     *films_clist;
GtkWidget    *gpc_films_popup_menu;
gint          gpc_film_selection;

GtkCList     *images_clist;
GtkWidget    *gpc_images_popup_menu;
gint          gpc_image_selection;


GList        *gpc_keywords;
GList        *gpc_added_keywords;

GList        *gpc_film_kinds;
GList        *gpc_added_film_kinds;
GList        *gpc_film_makers;
GList        *gpc_added_film_makers;
GList        *gpc_film_maker_codes;
GList        *gpc_added_film_maker_codes;
GList        *gpc_camera_makers;
GList        *gpc_added_camera_makers;
GList        *gpc_camera_maker_codes;
GList        *gpc_added_camera_maker_codes;
GList        *gpc_lens_makers;
GList        *gpc_added_lens_makers;
GList        *gpc_lens_maker_codes;
GList        *gpc_added_lens_maker_codes;

/* Lists only used in query dialogs */
GList        *gpc_film_models;
GList        *gpc_camera_models;
GList        *gpc_lens_models;


/* GPC options */
gchar        *gpc_repository;
gchar        *gpc_last_directory;

GpcZoomMode  gpc_zoom_mode;
gboolean     gpc_confirm_insert_refs;
gboolean     gpc_get_hidden_files;
gboolean     gpc_delete_removed_files;
gboolean     gpc_store_thumbnails;
gboolean     gpc_store_password;
gboolean     gpc_auto_connect;


/* GPC global functions */
gint     gpc_app_get_int_param(pgConnection *connection, gchar *param, gint defvalue);
gboolean gpc_app_set_int_param (pgConnection *connection, gchar *param, gchar *label, gint value);

gchar*   gpc_app_get_string_param (pgConnection *connection, gchar *param, gchar *defvalue);
gboolean gpc_app_set_string_param (pgConnection *connection, gchar *param, gchar *label, gchar *value);

gboolean gpc_app_check_database (pgConnection *connection);
gboolean gpc_app_check_keyword (pgConnection *connection, GList *list, gchar *value, gchar *table);

GList*   gpc_app_get_keywords (pgConnection *connection, gchar *table);
gboolean gpc_app_store_keywords (pgConnection *connection, gchar *table, GList *list);
GList*   gpc_app_get_maker_codes (pgConnection *connection, gchar *table, gchar *maker);
gboolean gpc_app_store_maker_codes (pgConnection *connection, gchar *table, gchar *maker, GList *list);

void gpc_app_read_options ();
void gpc_app_write_options ();

void gpc_app_update_films_list (pgQuery *query);
void gpc_app_update_images_list (pgQuery *query);
void gpc_app_free_lists (void);



// Main window callbacks
void
on_gpc_app_realize_event               (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_gpc_app_map                         (GtkWidget       *widget,
                                        gpointer         user_data);

gboolean
on_gpc_app_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_connect_file_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_add_new_film_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_add_new_image_menu_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_update_current_film_menu_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_delete_current_image_menu_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_delete_current_film_menu_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_print_thumbnails_menu_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_print_image_menu_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_close_file_menu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_exit_file_menu_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_preferences_edit_menu_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_zoom_in_view_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_zoom_out_view_menu_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_zoom_normal_view_menu_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_zoom_fit_view_menu_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_film_properties_view_menu_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_image_properties_view_menu_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_query_images_view_menu_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_acquire_new_image_tools_menu_activate (GtkMenuItem     *menuitem,
                                          gpointer         user_data);

void
on_edit_with_gimp_tools_menu_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_edit_with_ee_tools_menu_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_about_help_menu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

gboolean
on_films_clist_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

void
on_films_clist_select_row              (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_films_clist_scroll_vertical         (GtkCList        *clist,
                                        GtkScrollType    scroll_type,
                                        gfloat           position,
                                        gpointer         user_data);

void
on_films_clist_click_column            (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data);

void
on_images_clist_select_row             (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_images_clist_scroll_vertical        (GtkCList        *clist,
                                        GtkScrollType    scroll_type,
                                        gfloat           position,
                                        gpointer         user_data);

void
on_images_clist_click_column           (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data);

void
on_image_canvas_size_allocate          (GtkWidget       *widget,
                                        GtkAllocation   *allocation,
                                        gpointer         user_data);

gboolean
on_images_clist_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

gboolean
on_image_canvas_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

void
on_right_notebook_switch_page          (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data);

void
on_left_panel_size_allocate            (GtkWidget       *widget,
                                        GtkAllocation   *allocation,
                                        gpointer         user_data);
