/* Pmud Monitor as Gnome Applet
 *
 * By Uwe Steinmann <Uwe.Steinmann@fernuni-hagen.de>
 *
 * Enjoy.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License  
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>
#include <gtkdatabox.h>
#include <gtkdatabox_points.h>
#include <gtkdatabox_lines.h>
#include <gtkdatabox_bars.h>
#include <gtkdatabox_grid.h>
#include <gtkdatabox_cross_simple.h>
#include <gtkdatabox_marker.h>
#include "gpmudmon.h"

extern int count_timer(gpointer data);

static void charge_apply_cb(GtkObject *ch, gint page, gpointer data)
{
	PmudData *pd = data;
	count_timer(pd);
}

static void
charge_toggled_cb(GtkWidget *widget, void *data)
{	
	PmudData *pd = data;
	gnome_property_box_changed(GNOME_PROPERTY_BOX(pd->ch));
}

static void
charge_reset_cb(GtkWidget *widget, void *data)
{	
	PmudData *pd = data;
	gnome_property_box_changed(GNOME_PROPERTY_BOX(pd->ch));
}

static void
charge_changed_cb(gpointer d)
{	
	PmudData *pd = d;
	gnome_property_box_changed(GNOME_PROPERTY_BOX(pd->ch));
}

static gint
motion_notify_left_cb(PmudData *pd, GdkEventMotion *event)
{
  GtkDataboxCoord coord;
  GtkDataboxValue value, top_left, bottom_right;
  gchar *text;

  coord.x = event->x;
  coord.y = event->y;

  value = gtk_databox_value_from_coord (GTK_DATABOX(pd->databox_left), coord);

	gtk_databox_get_visible_canvas (GTK_DATABOX(pd->databox_left), &top_left, &bottom_right);

	if(value.x*pd->graphupdatetime/1000.0 > 60.0) {
		int minutes = (int) (value.x*(float)pd->graphupdatetime/1000.0/60.0);
		int seconds = (int) ((int)(value.x*(float)pd->graphupdatetime/1000.0)%60);
		text=g_strdup_printf(_("%d min %d sec ago"), /*(int)event->x*/ minutes, seconds);
	} else {
		text=g_strdup_printf(_("%d sec ago"), (int) (value.x*(float)pd->graphupdatetime/1000));
	}
  gtk_entry_set_text(GTK_ENTRY(pd->xcoord_left), text);
  g_free((gpointer) text);
  text=g_strdup_printf("%.3fV / %.3fA", value.y/100.0, value.y/1000.0);
  gtk_entry_set_text(GTK_ENTRY(pd->ycoord_left), text);
  g_free((gpointer) text);

	int index = (int) (value.x + 0.5);
	guint position;
	pd->markerx_left[0] = value.x;
	pd->markery_left[0] = pd->graph_data_left->current[index];
	pd->markerx_left[1] = value.x;
	pd->markery_left[1] = pd->graph_data_left->voltage[index];

	if(event->x > 475)
		position = GTK_DATABOX_TEXT_NW;
	else if(event->x < 25)
		position = GTK_DATABOX_TEXT_NE;
	else
		position = GTK_DATABOX_TEXT_N;
	text = g_strdup_printf ("%.3f A", pd->graph_data_left->current[index]/1000.0);
  gtk_databox_marker_set_label (GTK_DATABOX_MARKER(pd->marker_left), 0,
                                position, text, TRUE);
  g_free((gpointer) text);

	if(event->x > 475)
		position = GTK_DATABOX_TEXT_SW;
	else if(event->x < 25)
		position = GTK_DATABOX_TEXT_SE;
	else
		position = GTK_DATABOX_TEXT_S;
	text = g_strdup_printf ("%.3f V", pd->graph_data_left->voltage[index]/100.0);
  gtk_databox_marker_set_label (GTK_DATABOX_MARKER(pd->marker_left), 1,
                                position, text, TRUE);
  g_free((gpointer) text);

	gtk_databox_redraw(GTK_DATABOX(pd->databox_left));

  return FALSE;

}

static gint
motion_notify_right_cb(PmudData *pd, GdkEventMotion *event)
{
  GtkDataboxCoord coord;
  GtkDataboxValue value, top_left, bottom_right;
  gchar *text;

  coord.x = event->x;
  coord.y = event->y;

  value = gtk_databox_value_from_coord (GTK_DATABOX(pd->databox_right), coord);

	gtk_databox_get_visible_canvas (GTK_DATABOX(pd->databox_right), &top_left, &bottom_right);

	if(value.x*pd->graphupdatetime/1000.0 > 60.0) {
		int minutes = (int) (value.x*(float)pd->graphupdatetime/1000.0/60.0);
		int seconds = (int) ((int)(value.x*(float)pd->graphupdatetime/1000.0)%60);
		text=g_strdup_printf(_("%d min %d sec ago"), (int)event->x /*minutes*/, seconds);
	} else {
		text=g_strdup_printf(_("%d sec ago"), (int) (value.x*(float)pd->graphupdatetime/1000));
	}
  gtk_entry_set_text(GTK_ENTRY(pd->xcoord_right), text);
  g_free((gpointer) text);
  text=g_strdup_printf("%.3fV / %.3fA", value.y/100.0, value.y/1000.0);
  gtk_entry_set_text(GTK_ENTRY(pd->ycoord_right), text);
  g_free((gpointer) text);

	int index = (int) (value.x + 0.5);
	guint position;
	pd->markerx_right[0] = value.x;
	pd->markery_right[0] = pd->graph_data_right->current[index];
	pd->markerx_right[1] = value.x;
	pd->markery_right[1] = pd->graph_data_right->voltage[index];

	if(event->x > 475)
		position = GTK_DATABOX_TEXT_NW;
	else if(event->x < 25)
		position = GTK_DATABOX_TEXT_NE;
	else
		position = GTK_DATABOX_TEXT_N;
	text = g_strdup_printf ("%.3f A", pd->graph_data_right->current[index]/1000.0);
  gtk_databox_marker_set_label (GTK_DATABOX_MARKER(pd->marker_right), 0,
                                position, text, TRUE);
  g_free((gpointer) text);

	if(event->x > 475)
		position = GTK_DATABOX_TEXT_SW;
	else if(event->x < 25)
		position = GTK_DATABOX_TEXT_SE;
	else
		position = GTK_DATABOX_TEXT_S;
	text = g_strdup_printf ("%.3f V", pd->graph_data_right->voltage[index]/100.0);
  gtk_databox_marker_set_label (GTK_DATABOX_MARKER(pd->marker_right), 1,
                                position, text, TRUE);
  g_free((gpointer) text);

	gtk_databox_redraw(GTK_DATABOX(pd->databox_right));

  return FALSE;

}

void
set_graph_scale_left(PmudData *pd) {
	GtkDataboxValue min;
	GtkDataboxValue max;

	min.x = (float) pd->numsamples;
	min.y = 2000.0;
	max.x = 0;
	max.y = -2000.0;
	gtk_databox_set_canvas (GTK_DATABOX(pd->databox_left), min, max);
}

void
set_graph_scale_right(PmudData *pd) {
	GtkDataboxValue min;
	GtkDataboxValue max;

	min.x = (float) pd->numsamples;
	min.y = 2000.0;
	max.x = 0;
	max.y = -2000.0;
	gtk_databox_set_canvas (GTK_DATABOX(pd->databox_right), min, max);
}

void
create_graph_left(PmudData *pd) {
	gfloat *markX;
	gfloat *markY;

	GtkDataboxGraph *graph, *graph2, *graph3;
	GdkColor color;
	gint i, j;

	if(!pd->databox_left)
		return;

	gtk_databox_graph_remove_all(GTK_DATABOX(pd->databox_left));

	color.red = 50115;
	color.green = 50115;
	color.blue = 63735;

	graph = gtk_databox_grid_new (7, 7, &color, 1);
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_left), graph);

	color.red = 0;
	color.green = 0;
	color.blue = 65535;

	graph = gtk_databox_lines_new (pd->numsamples, pd->graph_data_left->xindex, pd->graph_data_left->current, &color, 2);
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_left), graph);

	color.red = 65535;
	color.green = 0;
	color.blue = 0;

	graph2 = gtk_databox_lines_new (pd->numsamples, pd->graph_data_left->xindex, pd->graph_data_left->voltage, &color, 2);
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_left), graph2);

	pd->markerx_left[0] = 0;
	pd->markery_left[0] = 0;
	pd->markerx_left[1] = 0;
	pd->markery_left[1] = 0;
  color.red = 0;
  color.green = 65535;
  color.blue = 0;

	pd->marker_left = gtk_databox_marker_new (2, pd->markerx_left, pd->markery_left, &color, 7,
	                                GTK_DATABOX_MARKER_TRIANGLE);
	gtk_databox_marker_set_position (GTK_DATABOX_MARKER (pd->marker_left), 0,
	                                 GTK_DATABOX_MARKER_N);
	gtk_databox_marker_set_position (GTK_DATABOX_MARKER (pd->marker_left), 1,
	                                 GTK_DATABOX_MARKER_S);
//	shift_marker (GTK_DATABOX (pd->databox_left), GTK_DATABOX_MARKER (pd->marker_left));
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_left), GTK_DATABOX_GRAPH(pd->marker_left));

}

void
create_graph_right(PmudData *pd) {
	gfloat *markX;
	gfloat *markY;

	GtkDataboxGraph *graph, *graph2, *graph3;
	GdkColor color;
	gint i, j;

	if(!pd->databox_right)
		return;

	gtk_databox_graph_remove_all(GTK_DATABOX(pd->databox_right));

	color.red = 50115;
	color.green = 50115;
	color.blue = 63735;

	graph = gtk_databox_grid_new (7, 7, &color, 1);
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_right), graph);

	color.red = 0;
	color.green = 0;
	color.blue = 65535;

	graph = gtk_databox_lines_new (pd->numsamples, pd->graph_data_right->xindex, pd->graph_data_right->current, &color, 2);
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_right), graph);

	color.red = 65535;
	color.green = 0;
	color.blue = 0;

	graph2 = gtk_databox_lines_new (pd->numsamples, pd->graph_data_right->xindex, pd->graph_data_right->voltage, &color, 2);
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_right), graph2);

	pd->markerx_right[0] = 0;
	pd->markery_right[0] = 0;
	pd->markerx_right[1] = 0;
	pd->markery_right[1] = 0;
  color.red = 0;
  color.green = 65535;
  color.blue = 0;

	pd->marker_right = gtk_databox_marker_new (2, pd->markerx_right, pd->markery_right, &color, 7,
	                                GTK_DATABOX_MARKER_TRIANGLE);
	gtk_databox_marker_set_position (GTK_DATABOX_MARKER (pd->marker_right), 0,
	                                 GTK_DATABOX_MARKER_N);
	gtk_databox_marker_set_position (GTK_DATABOX_MARKER (pd->marker_right), 1,
	                                 GTK_DATABOX_MARKER_S);
//	shift_marker (GTK_DATABOX (pd->databox_right), GTK_DATABOX_MARKER (pd->marker_right));
	gtk_databox_graph_add (GTK_DATABOX (pd->databox_right), GTK_DATABOX_GRAPH(pd->marker_right));

}

void
charge_cb(BonoboUIComponent *uic, gpointer p, const gchar *verbname)
{
	GtkWidget *frame, *hbox, *label, *spin_labe;
	GtkWidget *table, *scrollbar, *ruler, *box1;
	GtkWidget *cadre;
	GtkWidget *tbox;
	GtkDataboxGraph *graph, *graph2;
	GdkColor color;
	gint i, j;

	PmudData *pd = (PmudData *) p;

	if(pd->ch) {
		gtk_window_set_screen (GTK_WINDOW (pd->ch),
				       gtk_widget_get_screen (GTK_WIDGET (pd->app)));
		gtk_window_present (GTK_WINDOW (pd->ch));
		return;
	}

	pd->ch = gnome_property_box_new();
	gtk_window_set_title(GTK_WINDOW(pd->ch), _("gpmudmon charge level"));
	
	if(pd->valid_data == 0) {
		BAT_STATUS *batleft, *batright;
		batright = pd->pmud_status->bat;
		batleft = batright++;
		if(batleft->present) {
			frame=gtk_vbox_new(FALSE,0);
			gnome_property_box_append_page(GNOME_PROPERTY_BOX(pd->ch), frame,
			                               gtk_label_new(_("Left battery")));
	
			box1=gtk_vbox_new(FALSE,0);
			gtk_box_pack_start(GTK_BOX(frame),box1,FALSE,FALSE,5);

			table = gtk_table_new (3, 3, FALSE);
			pd->databox_left = gtk_databox_new ();

			color.red = 65535;
			color.green = 65535;
			color.blue = 65535;
			gtk_widget_modify_bg (pd->databox_left, GTK_STATE_NORMAL, &color);

			gtk_table_attach (GTK_TABLE (table), pd->databox_left, 1, 2, 1, 2,
	                 GTK_FILL | GTK_EXPAND | GTK_SHRINK,
	                 GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);

			/* You could associate a scrollbar with a GtkDatabox widget either 
			 * this way ...*/
			scrollbar = gtk_hscrollbar_new (NULL);
			gtk_databox_set_hadjustment (GTK_DATABOX (pd->databox_left),
	                        gtk_range_get_adjustment (GTK_RANGE (scrollbar)));
			gtk_table_attach (GTK_TABLE (table), scrollbar, 1, 2, 2, 3,
	                  GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL, 0, 0);
			/* or this way ... */
			scrollbar = gtk_vscrollbar_new
											(gtk_databox_get_vadjustment (GTK_DATABOX (pd->databox_left)));
			gtk_table_attach (GTK_TABLE (table), scrollbar, 2, 3, 1, 2,
												GTK_FILL, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
			ruler = gtk_hruler_new ();
			gtk_table_attach (GTK_TABLE (table), ruler, 1, 2, 0, 1,
												GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL, 0, 0);
			gtk_databox_set_hruler (GTK_DATABOX (pd->databox_left), GTK_RULER (ruler));
			ruler = gtk_vruler_new ();
			gtk_table_attach (GTK_TABLE (table), ruler, 0, 1, 1, 2,
												GTK_FILL, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
			gtk_databox_set_vruler (GTK_DATABOX (pd->databox_left), GTK_RULER (ruler));
			/* end of gtk_databox_create_box_with_scrollbars_and_rulers */

			gtk_box_pack_start (GTK_BOX (box1), table, TRUE, TRUE, 0);

			gtk_widget_set_size_request (pd->databox_left, 500, 300);

			create_graph_left(pd);
			set_graph_scale_left(pd);

		//	gtk_databox_auto_rescale (GTK_DATABOX (pd->databox_left), 0.05);
			gdk_window_set_cursor(pd->databox_left->window, gdk_cursor_new (GDK_CROSS));

			/* Charge level */
			cadre=gtk_frame_new(_("Charge level"));
			tbox=gtk_vbox_new(FALSE,10);
			box1=gtk_hbox_new(FALSE,3);
			gtk_box_pack_start(GTK_BOX(tbox),box1,FALSE,FALSE, 2);
			label=gtk_label_new(_("Charge"));
			gtk_box_pack_start(GTK_BOX(box1),label,FALSE,FALSE,0);
			pd->charge_left = gtk_entry_new ();
			gtk_widget_set_size_request (pd->charge_left, 150, -1);
			gtk_editable_set_editable (GTK_EDITABLE(pd->charge_left), FALSE);
			gtk_box_pack_start (GTK_BOX (box1), pd->charge_left, FALSE, TRUE, 0);
		/*	GtkWidget *button = gtk_button_new_with_label("Reset");
			g_signal_connect_swapped (G_OBJECT (pd->button),
												"clicked",
												G_CALLBACK (charge_reset_cb),
												pd);
			gtk_box_pack_start (GTK_BOX (box1), button, FALSE, TRUE, 0);
		*/
			gtk_container_add(GTK_CONTAINER(cadre),tbox);
			gtk_box_pack_start(GTK_BOX(frame),cadre,FALSE,FALSE,5);

			/* Cursor position */
			cadre=gtk_frame_new(_("Cursor position"));
			tbox=gtk_vbox_new(FALSE,10);

			box1=gtk_hbox_new(FALSE,3);
		//	gtk_box_pack_start(GTK_BOX(frame),box1,FALSE,FALSE,5);
			gtk_box_pack_start(GTK_BOX(tbox),box1,FALSE,FALSE, 2);
			label=gtk_label_new(_("X value"));
			gtk_box_pack_start(GTK_BOX(box1),label,FALSE,FALSE,0);
			pd->xcoord_left = gtk_entry_new ();
			gtk_widget_set_size_request (pd->xcoord_left, 150, -1);
			gtk_editable_set_editable (GTK_EDITABLE(pd->xcoord_left), FALSE);
			gtk_box_pack_start (GTK_BOX (box1), pd->xcoord_left, FALSE, TRUE, 0);

			label=gtk_label_new(_("Y value"));
			gtk_box_pack_start(GTK_BOX(box1),label,FALSE,FALSE,0);
			pd->ycoord_left = gtk_entry_new ();
			gtk_widget_set_size_request (pd->ycoord_left, 150, -1);
			gtk_editable_set_editable (GTK_EDITABLE(pd->ycoord_left), FALSE);
			gtk_box_pack_start (GTK_BOX (box1), pd->ycoord_left, FALSE, TRUE, 0);
			g_signal_connect_swapped (G_OBJECT (pd->databox_left),
												"motion_notify_event",
												G_CALLBACK (motion_notify_left_cb),
												pd);

			gtk_container_add(GTK_CONTAINER(cadre),tbox);
			gtk_box_pack_start(GTK_BOX(frame),cadre,FALSE,FALSE,5);

			gtk_widget_show(box1);
			gtk_widget_show(frame);
		}

		if(batright->present) {
			frame=gtk_vbox_new(FALSE,0);
			gnome_property_box_append_page(GNOME_PROPERTY_BOX(pd->ch), frame,
			                               gtk_label_new(_("Right battery")));
			box1=gtk_vbox_new(FALSE,0);
			gtk_box_pack_start(GTK_BOX(frame),box1,FALSE,FALSE,5);

			table = gtk_table_new (3, 3, FALSE);
			pd->databox_right = gtk_databox_new ();

			color.red = 65535;
			color.green = 65535;
			color.blue = 65535;
			gtk_widget_modify_bg (pd->databox_right, GTK_STATE_NORMAL, &color);

			gtk_table_attach (GTK_TABLE (table), pd->databox_right, 1, 2, 1, 2,
	                 GTK_FILL | GTK_EXPAND | GTK_SHRINK,
	                 GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);

			/* You could associate a scrollbar with a GtkDatabox widget either 
			 * this way ...*/
			scrollbar = gtk_hscrollbar_new (NULL);
			gtk_databox_set_hadjustment (GTK_DATABOX (pd->databox_right),
	                        gtk_range_get_adjustment (GTK_RANGE (scrollbar)));
			gtk_table_attach (GTK_TABLE (table), scrollbar, 1, 2, 2, 3,
	                  GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL, 0, 0);
			/* or this way ... */
			scrollbar = gtk_vscrollbar_new
											(gtk_databox_get_vadjustment (GTK_DATABOX (pd->databox_right)));
			gtk_table_attach (GTK_TABLE (table), scrollbar, 2, 3, 1, 2,
												GTK_FILL, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
			ruler = gtk_hruler_new ();
			gtk_table_attach (GTK_TABLE (table), ruler, 1, 2, 0, 1,
												GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL, 0, 0);
			gtk_databox_set_hruler (GTK_DATABOX (pd->databox_right), GTK_RULER (ruler));
			ruler = gtk_vruler_new ();
			gtk_table_attach (GTK_TABLE (table), ruler, 0, 1, 1, 2,
												GTK_FILL, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
			gtk_databox_set_vruler (GTK_DATABOX (pd->databox_right), GTK_RULER (ruler));
			/* end of gtk_databox_create_box_with_scrollbars_and_rulers */

			gtk_box_pack_start (GTK_BOX (box1), table, TRUE, TRUE, 0);

			gtk_widget_set_size_request (pd->databox_right, 500, 300);

			create_graph_right(pd);
			set_graph_scale_right(pd);

		//	gtk_databox_auto_rescale (GTK_DATABOX (pd->databox_right), 0.05);
			gdk_window_set_cursor(pd->databox_right->window, gdk_cursor_new (GDK_CROSS));

			/* Charge level */
			cadre=gtk_frame_new(_("Charge level"));
			tbox=gtk_vbox_new(FALSE,10);
			box1=gtk_hbox_new(FALSE,3);
			gtk_box_pack_start(GTK_BOX(tbox),box1,FALSE,FALSE, 2);
			label=gtk_label_new(_("Charge"));
			gtk_box_pack_start(GTK_BOX(box1),label,FALSE,FALSE,0);
			pd->charge_right = gtk_entry_new ();
			gtk_widget_set_size_request (pd->charge_right, 150, -1);
			gtk_editable_set_editable (GTK_EDITABLE(pd->charge_right), FALSE);
			gtk_box_pack_start (GTK_BOX (box1), pd->charge_right, FALSE, TRUE, 0);
		/*	GtkWidget *button = gtk_button_new_with_label("Reset");
			g_signal_connect_swapped (G_OBJECT (pd->button),
												"clicked",
												G_CALLBACK (charge_reset_cb),
												pd);
			gtk_box_pack_start (GTK_BOX (box1), button, FALSE, TRUE, 0);
		*/
			gtk_container_add(GTK_CONTAINER(cadre),tbox);
			gtk_box_pack_start(GTK_BOX(frame),cadre,FALSE,FALSE,5);

			/* Cursor position */
			cadre=gtk_frame_new(_("Cursor position"));
			tbox=gtk_vbox_new(FALSE,10);

			box1=gtk_hbox_new(FALSE,3);
		//	gtk_box_pack_start(GTK_BOX(frame),box1,FALSE,FALSE,5);
			gtk_box_pack_start(GTK_BOX(tbox),box1,FALSE,FALSE, 2);
			label=gtk_label_new(_("X value"));
			gtk_box_pack_start(GTK_BOX(box1),label,FALSE,FALSE,0);
			pd->xcoord_right = gtk_entry_new ();
			gtk_widget_set_size_request (pd->xcoord_right, 150, -1);
			gtk_editable_set_editable (GTK_EDITABLE(pd->xcoord_right), FALSE);
			gtk_box_pack_start (GTK_BOX (box1), pd->xcoord_right, FALSE, TRUE, 0);

			label=gtk_label_new(_("Y value"));
			gtk_box_pack_start(GTK_BOX(box1),label,FALSE,FALSE,0);
			pd->ycoord_right = gtk_entry_new ();
			gtk_widget_set_size_request (pd->ycoord_right, 150, -1);
			gtk_editable_set_editable (GTK_EDITABLE(pd->ycoord_right), FALSE);
			gtk_box_pack_start (GTK_BOX (box1), pd->ycoord_right, FALSE, TRUE, 0);
			g_signal_connect_swapped (G_OBJECT (pd->databox_right),
												"motion_notify_event",
												G_CALLBACK (motion_notify_right_cb),
												pd);

			gtk_container_add(GTK_CONTAINER(cadre),tbox);
			gtk_box_pack_start(GTK_BOX(frame),cadre,FALSE,FALSE,5);

			gtk_widget_show(box1);
			gtk_widget_show(frame);
		}
	}


	gtk_signal_connect(GTK_OBJECT(pd->ch), "apply",
                           GTK_SIGNAL_FUNC(charge_apply_cb), pd);
	gtk_signal_connect(GTK_OBJECT(pd->ch), "destroy",
                           GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(pd->ch));

	gtk_widget_show_all(pd->ch);
}
