/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  extra-widgets.c: Functions to create embeddable and reusable widgets.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef EXTRA_WIDGETS_H
#define EXTRA_WIDGETS_H


/* FIXME MAINTENABILITY: should add GFX_FILTER_NUM to the list */
#define GFX_FILTER_NUM 18

enum filesel_graphic_filter_e {
	GFX_FILTER_NONE = 0,
	GFX_FILTER_PNG,
	GFX_FILTER_JPG,
	GFX_FILTER_GIF,
	GFX_FILTER_PCX,
	GFX_FILTER_TIF,
	GFX_FILTER_BMP,
	GFX_FILTER_WMF,
	GFX_FILTER_XPM,
	GFX_FILTER_XBM,
	GFX_FILTER_PNM,
	GFX_FILTER_HRZ,
	GFX_FILTER_PAT,
	GFX_FILTER_PSP,
	GFX_FILTER_PSD,
	GFX_FILTER_SGI,
	GFX_FILTER_TGA,
	GFX_FILTER_XWD
};

typedef enum filesel_graphic_filter_e filesel_graphic_filter_t;

GtkWidget *filesel_graphic_filter (void);

GtkWidget *gpredict_stock_pixmap_button (const gchar *label,
					 const gchar *stock_pixmap,
					 const gchar *tooltips);

GtkWidget *gpredict_pixmap_button       (const gchar *label,
					 const gchar *subdir,
					 const gchar *pixmap,
					 const gchar *tooltips);

GtkWidget *gpredict_mini_button         (const gchar *subdir,
					 const gchar *pixmap,
					 const gchar *tooltips);

#endif
