/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  sat-ui-utils.c:  Commonly used utility functions.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "sat-ui-utils.h"

extern GtkWidget *app;  /* main.c */


GtkWidget *sat_ui_utils_pixmap_button (const gchar *label,
				       const gchar *stock_pixmap,
				       const gchar *tooltips)
{
	GtkWidget *button;
	GtkTooltips *kooltips;

	/* we need either a label or a pixmap */
	g_return_val_if_fail (((label != NULL) || (stock_pixmap != NULL)), NULL);
	
	if (stock_pixmap)
		button = gnome_pixmap_button (gnome_stock_pixmap_widget (app, stock_pixmap), label);
	else
		button = gtk_button_new_with_label (label);

	if (tooltips) {
		kooltips = gtk_tooltips_new ();
		gtk_tooltips_set_tip (kooltips, button, tooltips, NULL);
	}

	return button;
}


void
sat_ui_utils_set_tooltip   (GtkWidget *widget, const gchar *tip)
{
	/* Utility function to set a widgets tooltip.
	 */
	GtkTooltips *tips;

	g_return_if_fail (widget != NULL);
	g_return_if_fail (tip != NULL);

	tips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (tips, widget, tip, tip);
}
