/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satmap-info.c:  Helper functions accompaning satmap.c

  Copyright (C)  2002-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>
#include "defaults.h"
#include "satdata.h"
#include "satmap-info.h"

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif


extern GtkWidget *app;


void satmap_info_cb (GtkWidget *button, gpointer data)
{
	/* This function is called when the user clicks on the
	   "Sat Info" button. It pops up a dialog showing the
	   info about all the selected satellite.
	*/
  	GtkWidget *dialog,*table,*label;
	GnomeCanvasItem *item;
	gint selection;


	GDate *epoch;
	sat_t *sat;
	gchar *buff;

	/* The right footer canvas item contains info about the selection */
	item = GNOME_CANVAS_ITEM (gtk_object_get_data (GTK_OBJECT (data), "sati"));
	selection = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (item), "index"));

	if (selection != -1) {
		sat = satdata_get_sat (selection);

		/* put the info strings into a table */
  		table = gtk_table_new (14, 3, FALSE);
  		gtk_table_set_col_spacings (GTK_TABLE (table), 10);

		label = gtk_label_new (_("Satellite Name"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1); 
		label = gtk_label_new (sat->name);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f );
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 0, 1);

  		label = gtk_label_new (_("Catalog Number"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
		buff = g_strdup_printf ("%d",sat->catnum);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 1, 2);
		g_free (buff);

  		label = gtk_label_new (_("Launch Year"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f );
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
		buff = g_strdup_printf ("%d",sat->lyear);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 2, 3);
		g_free (buff);

  		label = gtk_label_new (_("Launch Number"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
		buff = g_strdup_printf ("%d",sat->lnum);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 3, 4);
		g_free (buff);

  		label = gtk_label_new (_("Piece of Launch"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
		buff = g_strdup_printf ("%s",sat->piece);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 4, 5);
		g_free (buff);

		/* Age of element set */
		epoch = g_date_new_dmy (1, 1, 2000 + sat->epyear);
		g_date_add_days (epoch, (guint) sat->epday);
		buff = g_malloc (50);
		g_date_strftime (buff, 50, "%x" /*"%B %e %Y"*/, epoch); /* locale's date representation*/ 
 		label = gtk_label_new (_("Set Issued"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 5, 6);
		g_free (buff);
//  		label = gtk_label_new (_("[year daynum]"));
//		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
//		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 5, 6);
		g_date_free (epoch);

  		label = gtk_label_new (_("Inclination"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
		buff = g_strdup_printf ("%.4f",sat->incl);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 6, 7);
		g_free (buff);
  		label = gtk_label_new (_("[deg]"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 6, 7);

  		label = gtk_label_new (_("RAAN"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 7, 8);
		buff = g_strdup_printf ("%.4f",sat->raan);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 7, 8);
		g_free (buff);
  		label = gtk_label_new (_("[deg]"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 7, 8);

  		label = gtk_label_new (_("Eccentricity"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 8, 9);
		buff = g_strdup_printf ("%.7f",sat->eccn);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 8, 9);
		g_free (buff);

  		label = gtk_label_new (_("Arg. of Perigee"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 9,10);
		buff = g_strdup_printf ("%.4f",sat->argper);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 9,10);
		g_free (buff);
  		label = gtk_label_new (_("[deg]"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 9,10);

  		label = gtk_label_new (_("Mean Anomaly"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1,10,11);
		buff = g_strdup_printf ("%.4f",sat->meanan);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2,10,11);
		g_free (buff);
  		label = gtk_label_new (_("[deg]"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3,10,11);

  		label = gtk_label_new (_("Mean Motion"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1,11,12);
		buff = g_strdup_printf ("%.8f",sat->meanmo);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2,11,12);
		g_free (buff);
  		label = gtk_label_new (_("[rev/day]"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3,11,12);

  		label = gtk_label_new (_("Drag"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1,12,13);
		buff = g_strdup_printf ("%.8f",sat->drag);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2,12,13);
		g_free (buff);
  		label = gtk_label_new (_("[rev/day/day]"));
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3,12,13);

  		label = gtk_label_new (_("Orbit Number"));
		gtk_misc_set_alignment (GTK_MISC(label), 0.0f, 0.0f);
		gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1,13,14);
		buff = g_strdup_printf ("%ld",sat->orbit);
		label = gtk_label_new (buff);
		gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.0f );
		gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2,13,14);
		g_free (buff);

  		/* create the dialog window */
  		dialog = gnome_dialog_new (_("Satellite Info"), GNOME_STOCK_BUTTON_OK, NULL);
  		gnome_dialog_set_parent (GNOME_DIALOG (dialog), GTK_WINDOW (app));
  		gnome_dialog_set_close (GNOME_DIALOG (dialog), TRUE);

  		gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox),
  				    table, TRUE, TRUE, 0 );

  		gtk_widget_show_all (dialog);

	}
	else {
		gnome_app_error (GNOME_APP (app), _("Please select a satellite!"));
	}
}
