/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  sattarget.c: Widgets and functions for target management.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/
#if defined (HAVE_HAMLIB)


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <gnome.h>
#include "sattarget.h"

#define TARGET_X_PAD 3
#define TARGET_Y_PAD 0


GtkWidget *tarname;  /**< Widget showing target name. */
GtkWidget *tarstat;  /**< Widget showing target status. */
GtkWidget *taraz;    /**< Widget showing target azimuth.   */
GtkWidget *tarel;    /**< Widget showing target elevation. */



/** \brief Create target frame.
 *  \return A GtkFrame containing the widgets.
 *
 * This function creates and initializes the targetting frame which consists of a
 * little GtkFrame to be embedded into the bottom of the main window. The contents
 * of the info frame are packed into a GtkEventBox to catch mouse event. Clicking
 * on the Target Frame pops up the Target selector window.
 */
GtkWidget *
sattarget_create ()
{
	GtkWidget *frame,*table;

	/* Initialize widgets */

	/* target name and AOS */
	tarname = gtk_label_new (_("No Target"));
	tarstat = gtk_label_new (_("Out of Range"));
	gtk_misc_set_alignment (GTK_MISC (tarname), 0.0, 0.5);
	gtk_misc_set_alignment (GTK_MISC (tarstat), 0.0, 0.5);

	/* Az and El */
	taraz = gtk_label_new ("000.00");
	tarel = gtk_label_new ("+00.00");
	gtk_misc_set_alignment (GTK_MISC (taraz), 1.0, 0.5);
	gtk_misc_set_alignment (GTK_MISC (tarel), 1.0, 0.5);

	/* the table to contain the labels */
	table = gtk_table_new (3, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (tarname),
			  0, 1, 1, 2,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  TARGET_X_PAD, TARGET_Y_PAD );
	gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (tarstat),
			  0, 1, 2, 3,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  TARGET_X_PAD, TARGET_Y_PAD );
	gtk_table_attach (GTK_TABLE (table), gtk_label_new (_("Az:")),
			  1, 2, 1, 2, 
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  TARGET_X_PAD, TARGET_Y_PAD );
	gtk_table_attach (GTK_TABLE (table), gtk_label_new (_("El:")),
			  1, 2, 2, 3,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  TARGET_X_PAD, TARGET_Y_PAD );
	gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (taraz),
			  2, 3, 1, 2,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  TARGET_X_PAD, TARGET_Y_PAD);
	gtk_table_attach (GTK_TABLE (table), GTK_WIDGET (tarel),
			  2, 3, 2, 3,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL | GTK_EXPAND,
			  TARGET_X_PAD, TARGET_Y_PAD);

	/* create frame */
	frame = gtk_frame_new (_(" Target "));
	gtk_frame_set_label_align (GTK_FRAME (frame), 0.5, 0.5);
	gtk_frame_set_shadow_type (GTK_FRAME (frame),
				   GTK_SHADOW_ETCHED_OUT);
	gtk_container_add (GTK_CONTAINER (frame), GTK_WIDGET (table));

	return frame;
}



#endif /* HAVE_HAMLIB */
