/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satsky.c: Radial plot showing satellites above horizon.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/
#include <gnome.h>
#include <gconf/gconf-client.h>
#include <math.h>
#include <libgnomeui/gnome-window-icon.h>
#include "defaults.h"
#include "satdata.h"
#include "qth.h"
#include "util.h"
#include "satlog.h"
#include "extra-widgets.h"
#include "satsky.h"
#include "satplot.h"      /* use some config paths from here */

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif



enum satsky_mode_e {
	SATSKY_MODE_NONE = 0,  /* actually not a valid mode... */
	SATSKY_MODE_TAB,       /* widget is in the notebook */
	SATSKY_MODE_WIN,       /* widget is in a separate window */
	SATSKY_MODE_FULLSCR    /* widget is blowing out screen! */
};



extern qth_struc qth;       /* qth.c  */
extern GtkWidget *app;      /* main.c */
extern GConfClient *client; /* main.c */


void satsky_open_cb (GtkWidget *widget, gpointer data)
{
	/* This is just a gtk-callback function that calls
	   satsky_open.
	*/
	satsky_open (NULL, TRUE);
}


gint satsky_open (gchar *name, gboolean addtolist)
{
	/* This function creates the widget that shows selected
	   satellites on a radial plot. The configuration file is expected
	   to be located at $HOME/.gpredict/name.satsky. If name is
	   NULL the druid will be invoked.
	   If addtolist is TRUE, the module will be added to the 
	   list of open modules (this should not be the case when
	   we start the program and open the modules from the
	   existing list).
	*/


	/* you can open in window using this... */
/* 	satsky_switch_mode_cb (tabwin, vbox); */

	return 0;
}
