/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001, 2002, 2003 Magnus-swe <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "../config.h"
#include <gtk/gtk.h>
#include "gproftpd_window.h"
#include "dialogs.h"
#include "support.h"


int main(int argc, char *argv[])
{
    GtkWidget *gproftpd_window;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);
    add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps/" PACKAGE); 
    gproftpd_window = create_gproftpd_window();
    gtk_widget_show (gproftpd_window);
    g_signal_connect(GTK_OBJECT(gproftpd_window), "destroy",
	             GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_main();
    return 0;    
}
