/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001 - 2006 Magnus Loef (Magnus-swe) <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "add_server.h"
#include "show_info.h"
#include "system_defines.h"
#include "populate_servers.h"
#include "populate_conf_tab.h"



void add_server(struct w *widgets)
{
    FILE *fp;
    char *server_config;

    if((fp=fopen(PROFTPD_CONF, "a"))==NULL)
    {
	printf("Cant write to: %s\n", PROFTPD_CONF);
        return;
    }
    
    /* The server configuration to be added */
    server_config = allocate(16384);

    strcpy(server_config, "<VirtualHost Unspecified>\n");
    strcat(server_config, "Port 65535\n");
    strcat(server_config, "ServerName \"Unspecified\"\n");
    strcat(server_config, "ServerIdent on \"Unspecified\"\n");

    /* The IANA-registered ephemeral port range */
    strcat(server_config, "PassivePorts 49152 65534\n");
    strcat(server_config, "#MasqueradeAddress None\n");
    strcat(server_config, "ServerAdmin Admin@this.domain\n");
    strcat(server_config, "Umask 022\n");
    strcat(server_config, "TimesGMT off\n");
    strcat(server_config, "MaxLoginAttempts 3\n");
    strcat(server_config, "TimeoutLogin 300\n");
    strcat(server_config, "TimeoutNoTransfer 120\n");
    strcat(server_config, "TimeoutIdle 120\n");

    strcat(server_config, "User ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");

    strcat(server_config, "Group ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");

    strcat(server_config, "DirFakeUser on ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");

    strcat(server_config, "DirFakeGroup on ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");

    strcat(server_config, "DefaultTransferMode binary\n");
    strcat(server_config, "AllowForeignAddress on\n");
    strcat(server_config, "DeleteAbortedStores off\n");

    strcat(server_config, "AllowRetrieveRestart on\n");
    strcat(server_config, "AllowStoreRestart on\n");
    strcat(server_config, "TransferRate RETR 30\n");
    strcat(server_config, "TransferRate STOR 50\n");
    strcat(server_config, "TransferRate STOU 50\n");
    strcat(server_config, "TransferRate APPE 50\n");

    strcat(server_config, "<IfModule mod_tls.c>\n");
    strcat(server_config, "TLSEngine off\n");
    strcat(server_config, "TLSRequired off\n");
    strcat(server_config, "TLSVerifyClient off\n");

    strcat(server_config, "TLSLog ");
    strcat(server_config, GP_VARDIR);
    strcat(server_config, "/log/proftpd_tls.log\n");

    strcat(server_config, "TLSRSACertificateFile ");
    strcat(server_config, GP_APPCONFDIR);
    strcat(server_config, "/gproftpd/gproftpd.pem\n");

    strcat(server_config, "</IfModule>\n");
    strcat(server_config, "<Limit LOGIN>\n");
    strcat(server_config, "  DenyAll\n");
    strcat(server_config, "</Limit>\n");
    strcat(server_config, "</VirtualHost>\n");
    fputs("\n", fp);
    fputs(server_config, fp);
    fputs("\n", fp);
    fclose(fp);
    free(server_config);

    /* Repopulate the affected parts of the gui */
    populate_servers(widgets);

    populate_conf_tab(widgets);    
}
