#include "mainwindow.h"

#include <QToolBar>
#include <qmenubar.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qtooltip.h>

#include "httpwindow.h"

#include "viewer.h"
#include "copyLabel.h"
#include "clickableLabel.h"
#include "gpsshogi/revision.h"
MainWindow::MainWindow(QWidget *parent, const char *name)
  : QMainWindow(parent, name)
{
  viewer = new Viewer(this);
  setCentralWidget(viewer);
  resize(QSize(1000, 600));
  for (int i = 0; i < qApp->argc(); i++)
  {
    if (strcmp("-csa", qApp->argv()[i]) == 0)
    {
      if (i + 1 < qApp->argc() && qApp->argv()[i + 1][0] != '-')
      {
	std::string fileName(qApp->argv()[i + 1]);
	viewer->open(fileName);
      }
      if (i + 2 < qApp->argc() && qApp->argv()[i + 2][0] != '-')
      {
	bool ok;
	int index = QString(qApp->argv()[i + 2]).toInt(&ok);
	if (ok)
	  viewer->moveTo(index - 1);
      }
    }
    else if (strcmp("-kisen", qApp->argv()[i]) == 0)
    {
      if (i + 2 < qApp->argc() && qApp->argv()[i + 2][0] != '-')
      {
	std::string fileName(qApp->argv()[i + 1]);
	bool ok;
	int index = QString(qApp->argv()[i + 2]).toInt(&ok);
	if (ok)
	  viewer->open(fileName, index);
      }
    }
    else if (strcmp("-kif", qApp->argv()[i]) == 0)
    {
      if (i + 1 < qApp->argc() && qApp->argv()[i + 1][0] != '-')
      {
	std::string fileName(qApp->argv()[i + 1]);
	viewer->openKakinoki(fileName);
      }
    }
    else if (strcmp("-usi", qApp->argv()[i]) == 0)
    {
      if (i + 1 < qApp->argc() && qApp->argv()[i + 1][0] != '-')
      {
	std::string fileName(qApp->argv()[i + 1]);
	viewer->openUsi(fileName);
      }
    }
    else if (strcmp("-url", qApp->argv()[i]) == 0)
    {
      if (i + 1 < qApp->argc() && qApp->argv()[i + 1][0] != '-')
      {
	HttpWindow::setLastUrl(qApp->argv()[i + 1]);
	viewer->reloadUrl();
      }
    }
  }

  QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
  QAction *openAction = new QAction(tr("&Open"), this);
  openAction->setShortcut(tr("Ctrl+o"));
  connect(openAction, SIGNAL(activated()), viewer, SLOT(open()));
  fileMenu->addAction(openAction);

  QAction *nextAction = new QAction(tr("Open &Next"), this);
  connect(nextAction, SIGNAL(activated()), viewer, SLOT(nextFile()));
  nextAction->addTo(fileMenu);

  QAction *prevAction = new QAction(tr("Open &Previous"), this);
  connect(prevAction, SIGNAL(activated()), viewer, SLOT(prevFile()));
  prevAction->addTo(fileMenu);

  QAction *urlAction = new QAction(tr("Open &Url"), this);
  urlAction->setShortcut(tr("Ctrl+u"));
  connect(urlAction, SIGNAL(activated()), viewer, SLOT(openUrl()));
  urlAction->addTo(fileMenu);

  QAction *reloadUrlAction = new QAction(tr("&Reload Url"), this);
  reloadUrlAction->setShortcut(tr("Ctrl+r"));
  connect(reloadUrlAction, SIGNAL(activated()), viewer, SLOT(reloadUrl()));
  reloadUrlAction->addTo(fileMenu);

  QAction *hirateAction = new QAction(tr("&Hirate"), this);
  connect(hirateAction, SIGNAL(activated()), viewer, SLOT(hirate()));
  hirateAction->addTo(fileMenu);

  QAction *networkAction = new QAction(tr("Open Network &Connection"), this);
  connect(networkAction, SIGNAL(activated()), viewer, SLOT(network()));
  networkAction->addTo(fileMenu);

  QAction *viewAction = new QAction(tr("&View"), this);
  connect(viewAction, SIGNAL(activated()), viewer, SLOT(view()));
  viewAction->addTo(fileMenu);

  QAction *viewInNewTabAction = new QAction(tr("View In New &Tab"), this);
  connect(viewInNewTabAction, SIGNAL(activated()), viewer, SLOT(viewInNewTab()));
  viewInNewTabAction->addTo(fileMenu);

  QAction *watchFileAction = new QAction(tr("&Watch File"), this);
  watchFileAction->setToggleAction(true);
  connect(watchFileAction, SIGNAL(toggled(bool)), viewer, SLOT(watchFile(bool)));
  watchFileAction->addTo(fileMenu);

  QAction *saveToAction = new QAction(tr("Save &Moves To Now"), this);
  connect(saveToAction, SIGNAL(activated()), viewer, SLOT(saveMovesToCurrent()));
  saveToAction->addTo(fileMenu);

  QAction *autoSaveMovesAction = new QAction(tr("&Auto Save Moves..."), this);
  connect(autoSaveMovesAction, SIGNAL(activated()), viewer, SLOT(autoSaveMoves()));
  autoSaveMovesAction->addTo(fileMenu);
  autoSaveMovesAction->setWhatsThis(tr("Select a file where moves played in the Kifu viewer are saved automatically."));

  QAction *exportAction = new QAction(tr("&Export"), this);
  connect(exportAction, SIGNAL(activated()), viewer, SLOT(exportCurrent()));
  exportAction->addTo(fileMenu);

  QAction *exitAction = new QAction(tr("&Quit"), this);
  exitAction->setShortcut(tr("Ctrl+q"));
  connect(exitAction, SIGNAL(activated()), qApp, SLOT(quit()));
  exitAction->addTo(fileMenu);

  QMenu *editMenu = new QMenu(this);
  QAction *copyAction = new QAction(tr("&Copy"), this);
  copyAction->setShortcut(tr("Ctrl+c"));
  connect(copyAction, SIGNAL(activated()), viewer, SLOT(copy()));
  copyAction->addTo(editMenu);

  QAction *copyBoardAndMovesAction =
    new QAction(tr("Copy &Board and Moves"), this);
  connect(copyBoardAndMovesAction, SIGNAL(activated()),
	  viewer, SLOT(copyBoardAndMoves()));
  copyBoardAndMovesAction->addTo(editMenu);

  QAction *copyUsiAction = new QAction(tr("Copy &USI"), this);
  connect(copyUsiAction, SIGNAL(activated()), viewer, SLOT(copyUsi()));
  copyUsiAction->addTo(editMenu);

  QAction *copyBoardAndMovesUsiAction =
    new QAction(tr("Copy Board and Moves USI"), this);
  connect(copyBoardAndMovesUsiAction, SIGNAL(activated()),
	  viewer, SLOT(copyBoardAndMovesUsi()));
  copyBoardAndMovesUsiAction->addTo(editMenu);

  QAction *pasteAction = new QAction(tr("&Paste"), this);
  pasteAction->setShortcut(tr("Ctrl+v"));
  connect(pasteAction, SIGNAL(activated()), viewer, SLOT(paste()));
  pasteAction->addTo(editMenu);

  editMenu->addSeparator();

  QAction *editStateAction = new QAction(tr("Edit B&oard"), this);
  connect(editStateAction, SIGNAL(activated()),
	  viewer, SLOT(editState()));
  editStateAction->addTo(editMenu);

  QMenu *goMenu = new QMenu(this);

  QAction *initialAction = new QAction(tr("&Initial State"), this);
  connect(initialAction, SIGNAL(activated()), viewer, SLOT(toInitialState()));
  initialAction->setIconSet(loadPixmap("beginning.png"));
  initialAction->addTo(goMenu);

  QAction *forwardAction = new QAction(tr("&Forward"), this);
  forwardAction->setShortcut(tr("Ctrl+f"));
  forwardAction->setIconSet(loadPixmap("forward.png"));
  connect(forwardAction, SIGNAL(activated()), viewer, SLOT(forward()));
  forwardAction->addTo(goMenu);

  QAction *backAction = new QAction(tr("&Backward"), this);
  backAction->setShortcut(tr("Ctrl+b"));
  backAction->setIconSet(loadPixmap("backward.png"));
  connect(backAction, SIGNAL(activated()), viewer, SLOT(backward()));
  backAction->addTo(goMenu);

  QAction *lastAction = new QAction(tr("&Last"), this);
  lastAction->setIconSet(loadPixmap("end.png"));
  connect(lastAction, SIGNAL(activated()), viewer, SLOT(toLastState()));
  lastAction->addTo(goMenu);

  QMenu *analysisMenu = new QMenu(this);

  QAction *analyzeAction = new QAction(tr("&Search"), this);
  connect(analyzeAction, SIGNAL(activated()), viewer, SLOT(analyze()));
  analyzeAction->addTo(analysisMenu);

  QAction *analyzeInNewTabAction = new QAction(tr("Search In New &Tab"), this);
  connect(analyzeInNewTabAction, SIGNAL(activated()), viewer,
	  SLOT(analyzeInNewTab()));
  analyzeInNewTabAction->addTo(analysisMenu);
  QAction *checkmateAction = new QAction(tr("&Checkmate Search"), this);
  connect(checkmateAction, SIGNAL(activated()), viewer, SLOT(checkmateSearch()));
  checkmateAction->addTo(analysisMenu);

  QAction *altCheckmateAction = new QAction(tr("C&heckmate Search (alt)"), this);
  connect(altCheckmateAction, SIGNAL(activated()), viewer, SLOT(altCheckmateSearch()));
  altCheckmateAction->addTo(analysisMenu);

#ifndef OSL_PUBLIC_RELEASE
  QAction *quiescenceHalfAction = new QAction(tr("Q&uiescence Search Half Depth"), this);
  connect(quiescenceHalfAction, SIGNAL(activated()), viewer, SLOT(quiescenceSearchHalf()));
  quiescenceHalfAction->addTo(analysisMenu);

  analysisMenu->addSeparator();

  QAction *moveGenerateAction = new QAction(tr("Show &Moves"), this);
  connect(moveGenerateAction, SIGNAL(activated()), viewer, SLOT(moveGenerateDialog()));
  moveGenerateAction->addTo(analysisMenu);

  analysisMenu->addSeparator();

  QAction *kifuAnalyzeAction = new QAction(tr("Analyze &Kifu"), this);
  connect(kifuAnalyzeAction, SIGNAL(activated()), viewer, SLOT(kifuAnalyze()));
  kifuAnalyzeAction->addTo(analysisMenu);

  QMenu *evalDebugMenu = new QMenu(this);

  QAction *evalDebugAction = new QAction(tr("Analyze Evaluation Function (OpenMidEndingEvavl)"),
					 this);
  connect(evalDebugAction, SIGNAL(activated()), viewer,
	  SLOT(testEvalDebug()));
  evalDebugAction->addTo(evalDebugMenu);
  QAction *progressDebugAction = new QAction(tr("Analyze Progress"), this);
  progressDebugAction->addTo(evalDebugMenu);
  connect(progressDebugAction, SIGNAL(activated()), viewer,
          SLOT(showProgressDebug()));
  evalDebugMenu->addSeparator();

  QAction *evalDebugSetStatus1Action = new QAction(tr("Set first status to be analyzed"), this);
  QAction *evalDebugSetStatus2Action = new QAction(tr("Set second status to be analyzed"), this);
  QAction *evalDebugDiffAction = new QAction(tr("Show Eval Diff"), this);
  evalDebugSetStatus1Action->addTo(evalDebugMenu);
  connect(evalDebugSetStatus1Action, SIGNAL(activated()), viewer,
          SLOT(setState1()));
  evalDebugSetStatus2Action->addTo(evalDebugMenu);
  connect(evalDebugSetStatus2Action, SIGNAL(activated()), viewer,
          SLOT(setState2()));
  evalDebugDiffAction->addTo(evalDebugMenu);
  connect(evalDebugDiffAction, SIGNAL(activated()), viewer,
          SLOT(showEvalDiff()));
#endif
  analyzeOnlineAction = new QAction(tr("Analyze &Online"), this);
  connect(analyzeOnlineAction, SIGNAL(toggled(bool)), viewer,
	  SLOT(setAnalyzeOnline(bool)));
  analyzeOnlineAction->setToggleAction(true);
  analyzeOnlineAction->addTo(analysisMenu);

  QMenu *viewMenu = new QMenu(this);

  flipAction = new QAction(tr("&Flip View"), this);
  connect(flipAction, SIGNAL(toggled(bool)), viewer,
	  SLOT(setOrientation(bool)));
  flipAction->setToggleAction(true);
  flipAction->addTo(viewMenu);
  effectAction = new QAction(tr("Show &Effect"), this);
  connect(effectAction, SIGNAL(toggled(bool)), viewer,
	  SLOT(enableEffect(bool)));
  effectAction->setToggleAction(true);
  effectAction->addTo(viewMenu);
  QAction *evalGraphAction = new QAction(tr("Evaluation &Graph"), this);
  evalGraphAction->addTo(viewMenu);
  connect(evalGraphAction, SIGNAL(activated()), viewer, SLOT(openEvalGraph()));  
  lastMoveAction = new QAction(tr("Highlight &Last Move"), this);
  connect(lastMoveAction, SIGNAL(toggled(bool)), viewer,
	  SLOT(highlightLastMove(bool)));
  lastMoveAction->setToggleAction(true);
  lastMoveAction->addTo(viewMenu);
  lastMoveAction->toggle();

  bookMoveAction = new QAction(tr("Highlight &Book Move"), this);
  connect(bookMoveAction, SIGNAL(toggled(bool)), viewer,
	  SLOT(highlightBookMove(bool)));
  bookMoveAction->setToggleAction(true);
  bookMoveAction->addTo(viewMenu);
  bookMoveAction->toggle();

  arrowMoveAction = new QAction(tr("Show &Arrows for Moves"), this);
  connect(arrowMoveAction, SIGNAL(toggled(bool)), viewer,
	  SLOT(showArrowMove(bool)));
  arrowMoveAction->setToggleAction(true);
  arrowMoveAction->addTo(viewMenu);
  arrowMoveAction->toggle();

  menuBar()->insertItem(tr("&File"), fileMenu);
  menuBar()->insertItem(tr("&Edit"), editMenu);
  menuBar()->insertItem(tr("&Go"), goMenu);
  menuBar()->insertItem(tr("&Analyze"), analysisMenu);
#ifndef OSL_PUBLIC_RELEASE
  menuBar()->insertItem(tr("&Debug"), evalDebugMenu);
#endif
  menuBar()->insertItem(tr("&View"), viewMenu);

  QToolBar *toolbar = addToolBar(tr("Go"));
  toolbar->addAction(loadPixmap("beginning.png"),
		     "&Initial State",
		     viewer, SLOT(toInitialState()));
  toolbar->addAction(loadPixmap("backward.png"),
		     tr("&Backward"),
		     viewer, SLOT(backward()));
  toolbar->addAction(loadPixmap("forward.png"),
		     tr("&Forward"),
		     viewer, SLOT(forward()));
  toolbar->addAction(loadPixmap("end.png"),
		     tr("&Last"),
		     viewer, SLOT(toLastState()));

  moveLabel = new QLabel(QString::fromUtf8(" 1234手 "), statusBar());
  moveLabel->setAlignment(Qt::AlignHCenter);
  moveLabel->setMinimumSize(moveLabel->sizeHint());
  statusBar()->addWidget(moveLabel);

  turnLabel = new QLabel(QString::fromUtf8(" 先手 "), statusBar());
  turnLabel->setAlignment(Qt::AlignHCenter);
  turnLabel->setMinimumSize(turnLabel->sizeHint());
  statusBar()->addWidget(turnLabel);

  evalLabel = new ClickableLabel(QString::fromUtf8("評価値: -1234 (-1234 -1234 -1234 -1234) -1234"),
				 statusBar());
  evalLabel->setToolTip(QString::fromUtf8("評価値: 合計 (序盤 中盤1 中盤2 終盤"
					  ") 緊張度"));
  evalLabel->setAlignment(Qt::AlignHCenter);
  evalLabel->setMinimumSize(evalLabel->sizeHint());
  statusBar()->addWidget(evalLabel);
  connect(evalLabel, SIGNAL(clicked()), viewer, SLOT(testEvalDebug()));

  progressLabel = new CopyRateLabel(QString::fromUtf8("進行度: 12 (12 12)"),
				    statusBar());
  progressLabel->setToolTip(QString::fromUtf8("進行度: 総合 (先手 後手)"));
  progressLabel->setAlignment(Qt::AlignHCenter);
  progressLabel->setMinimumSize(progressLabel->sizeHint());
  statusBar()->addWidget(progressLabel);

  threatmateLabel = new CopyRateLabel(QString::fromUtf8("詰めろ? 12.3 34.5"),
				      statusBar());
  threatmateLabel->setAlignment(Qt::AlignHCenter);
  threatmateLabel->setMinimumSize(threatmateLabel->sizeHint());
  statusBar()->addWidget(threatmateLabel);

  filenameLabel = new CopyLabel(QString::fromUtf8("12345678901234567890"),
				statusBar());
  filenameLabel->setAlignment(Qt::AlignHCenter);
  filenameLabel->setMinimumSize(filenameLabel->sizeHint());
  statusBar()->addWidget(filenameLabel);

  std::string gpsname = "gpsshogi ";
#ifdef OSL_SMP
  gpsname += "(smp) ";
#endif
  gpsname += gpsshogi::gpsshogi_revision;
  QLabel *revisionLabel = new CopyLabel(QString::fromStdString(gpsname), statusBar());
  revisionLabel->setAlignment(Qt::AlignHCenter);
  revisionLabel->setMinimumSize(revisionLabel->sizeHint());
  statusBar()->addWidget(revisionLabel);

  connect(viewer, SIGNAL(statusChanged()),
	  this, SLOT(updateStatusBar()));
  connect(viewer, SIGNAL(orientationChanged(bool)),
	  this, SLOT(updateFlipButton(bool)));
  connect(viewer, SIGNAL(effectChanged(bool)),
	  this, SLOT(updateEffectButton(bool)));
  connect(viewer, SIGNAL(analyzeOnlineDisabled()),
	  this, SLOT(turnOffAnalyzeOnlineButton()));
  updateStatusBar();
}

void MainWindow::updateStatusBar()
{
  moveLabel->setText(QString::fromUtf8(" %1手 ").arg(viewer->moveCount()));
  if (viewer->turn() == osl::BLACK)
    turnLabel->setText(QString::fromUtf8("先手"));
  else
    turnLabel->setText(QString::fromUtf8("後手"));

  const viewer::EvalInfo eval = viewer->evalState();
  evalLabel->setText(QString::fromUtf8("評価値: %1 (%2 %3 %4 %5) %6")
		     .arg(eval.total).arg(eval.opening).arg(eval.mid1)
		     .arg(eval.mid2).arg(eval.ending).arg(eval.tension));
  evalLabel->setRate(eval.total / 3000.0);
  osl::stl::vector<int> progress;
  viewer->progressOfState(progress);
  progressLabel->setText(QString::fromUtf8("進行度: %1 (%2 %3)")
			 .arg(progress[0]).arg(progress[1]).arg(progress[2]));
  progressLabel->setRate(progress[0]/16.0);
  const std::pair<double,double> threatmate_probability = viewer->checkmateProbability();
  threatmateLabel->setText(QString::fromUtf8("詰めろ? %1 %2")
			   .arg(threatmate_probability.first*100,0,'g',3)
			   .arg(threatmate_probability.second*100,0,'g',3));
  threatmateLabel->setRate(threatmate_probability.first);
  filenameLabel->setText(viewer->getFilename());
}

void MainWindow::updateFlipButton(bool sente)
{
  flipAction->setOn(!sente);
}

void MainWindow::updateEffectButton(bool on)
{
  effectAction->setOn(on);
}

void MainWindow::turnOffAnalyzeOnlineButton()
{
  analyzeOnlineAction->setOn(false);
}

QPixmap MainWindow::loadPixmap(const QString &name)
{
  return QPixmap(":/images/" + name);
}
