#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <semaphore.h>
#include <gtk/gtk.h>
#include <linux/types.h> 
#include <linux/videodev.h>
#include <signal.h>
#include <png.h>
#include "gqcam.h"
#include "filters.h"

void swap_rgb24(struct Camera *camera)
{
  char  c;
  char *p = camera->pic;
  int   i = camera->vid_win.width*camera->vid_win.height;
  int bytes_per_rgb = 3;
  
  //  printf("Swapping...\n");
  if(!camera->greyscale){
    while (--i) {
      //  printf("%d\n", i);
      c = p[0]; p[0] = p[2]; p[2] = c;
      p += bytes_per_rgb;
    }
  } 
}

void auto_bright(struct Camera *camera)
{
  int i, average, num_components;
  unsigned char *picpointer=camera->pic;
  long total = 0;
  int size = camera->vid_win.height * camera->vid_win.width;

  if (camera->greyscale)
    num_components = 1;
  else
    num_components = 3;
  
  for (i=0;i<size*num_components;i++)
    total += *picpointer++;

  average = total/(size*num_components);
  if((average <= 124 || average >= 132)){
    pthread_mutex_lock(&camera->pref_mutex);
    camera->vid_pic.brightness += ((128 - average)/3)*256;
    //    printf("Brightness: %d, %d, avg: %d\n", total, camera->vid_pic.brightness, average);
    camera->update_camera = 1;
    pthread_mutex_unlock(&camera->pref_mutex);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(camera->controls.adjbrightness), camera->vid_pic.brightness/256);
  }
}

  
