/*		
 *		GRAMophone II, a grammar based algorithmic musical composition tool
 *		--------------------------------------------------------------------
 *		
 *		init.c
 *
 *		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
 *
 * 		GRAMophone II is free software; you can redistribute it and/or modify
 * 		it under the terms of the GNU General Public License as published by
 * 		the Free Software Foundation; either version 2 of the License, or
 * 		(at your option) any later version.
 *
 * 		This program is distributed in the hope that it will be useful,
 * 		but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * 		GNU Library General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License along
 *		with this program; if not, write to the Free Software Foundation, Inc.,
 *		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *		-------------------------------------------------------------------
 */

#include "global.h"
#include <time.h>

void init_rand(void) {
  int stime;
  long ltime;

  ltime=time(NULL);
  stime=(unsigned)ltime/2;
  srand(stime);
}

void init_local_flag(void) {
  memset(loc_par_flag, 0, 10);
}

void initGRAMophone(void) {
  register unsigned int i;
  extern int ctrl[];
  extern pnote_var noteVarTemp, noteVarTempBis;
  
  varCount=macroCount=globalWritten=0;
  isGlobal=1;
  tempo=120;
  global_iterations=1;
  global_resolution=480;
  grammarOption=0;
  memset(ctrl, 0, NUM_CTRL);
  glob_num=glob_den=4;
  global_params[DEFOCT]=3;
  global_params[DEFVEL]=64;
  global_params[DEFDUR]=global_resolution;
  global_params[DEFREL]=0;
  init_local_flag();
  for(i=NUM_VARS; i--;) {
    global_vars[i].name=NULL;
    global_vars[i].type=0;
    global_vars[i].value=0;
  }
  if(!(noteVarTemp=(pnote_var)malloc(sizeof(*noteVarTemp))))
    sntx_err(MEMORY_ERR, "");
  if(!(noteVarTemp->name=(char *)malloc((1+VAR_LENGTH)*sizeof(char))))
    sntx_err(MEMORY_ERR, "");
  noteVarTemp->type=0;
  noteVarTemp->value=0;
  if(!(noteVarTempBis=(pnote_var)malloc(sizeof(*noteVarTempBis))))
    sntx_err(MEMORY_ERR, "");
  if(!(noteVarTempBis->name=(char *)malloc((1+VAR_LENGTH)*sizeof(char))))
    sntx_err(MEMORY_ERR, "");
  noteVarTempBis->type=0;
  noteVarTempBis->value=0;
  //Initialize the players vector
  playerCount=0;
  memset(players, 0, NUM_PLAYERS);
  for(i=NUM_MACRO; i--;)
    macros[i].name=macros[i].data=NULL;
  //Initialize the pseudo-random numbers generator
  init_rand();
}

void init_player(void) {
  register unsigned int i;	

  if(!(players[playerCount]=(pPlayer)malloc(sizeof(player))))
    sntx_err(MEMORY_ERR, "");
  players[playerCount]->identifier=NULL;
  for(i=NUM_VARS; i--;) {
    players[playerCount]->local_vars[i].name=NULL;
    players[playerCount]->local_vars[i].type=0;
    players[playerCount]->local_vars[i].value=0;
  }
  for(i=NUM_PRODS; i--;) {
    players[playerCount]->productions[i]=NULL;
  }
  players[playerCount]->num=players[playerCount]->den=
  players[playerCount]->iterations=
  players[playerCount]->local_params[DEFOCT]=
  players[playerCount]->local_params[DEFVEL]=
  players[playerCount]->local_params[DEFDUR]=
  players[playerCount]->local_params[DEFREL]=
  players[playerCount]->local_params[DEFINSTR]=
  players[playerCount]->local_params[CHN]=0;
}

