// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: DeckInfo.cpp,v 1.8 2005/05/08 18:48:00 vlg Exp $
//------------------------------------------------------------------------------
//                            DeckInfo.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Mon Feb 16 22:08:26 EST 2004
//
//------------------------------------------------------------------------------

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/label.h>
#include <gtkmm/alignment.h>
#include <gtkmm/entry.h>
#include <gtkmm/table.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/main.h>

#include "Granule-main.h"
#include "DeckInfo.h"
#include "Deck.h"

DeckInfo::
DeckInfo (Gtk::Window& parent_, Deck& deck_) :
	m_deck (deck_),
	m_author_entry (Gtk::manage (new Gtk::Entry ())),
	m_desc_entry (Gtk::manage (new Gtk::Entry ())),
	m_snd_path_entry (Gtk::manage (new Gtk::Entry ()))
{  
	trace_with_mask("DeckInfo::DeckInfo", GUITRACE);

	set_modal (false);
	property_window_position ().set_value (Gtk::WIN_POS_CENTER);
	set_resizable (true);
	property_destroy_with_parent ().set_value (false);
	set_has_separator (true);
	set_title ("Deck Info");
	set_transient_for (parent_);

	Gtk::Button* cancel_button;
	Gtk::Button* ok_button;
	Gtk::Button* snd_browse_button;

	Gtk::Label* author_label;
	Gtk::Label* desc_label;
	Gtk::Label* label12;

	Gtk::Alignment* alignment7;
	Gtk::Alignment* alignment8;
	Gtk::Alignment* alignment9;

	Gtk::Table* table1;

	Gtk::HBox* hbox5;
	Gtk::VBox* vbox1;

	cancel_button = Gtk::manage(new Gtk::Button (Gtk::StockID ("gtk-cancel")));
	ok_button = Gtk::manage (new Gtk::Button (Gtk::StockID ("gtk-ok")));
	author_label = Gtk::manage (new Gtk::Label ("Author : "));
	alignment7 = Gtk::manage (new Gtk::Alignment (0.95, 0.5, 0, 0));
	desc_label = Gtk::manage (new Gtk::Label ("Description : "));
	alignment8 = Gtk::manage (new Gtk::Alignment (0.91, 0.5, 0, 0));

	table1 = Gtk::manage (new Gtk::Table (2, 2, false));
	label12 = Gtk::manage (new Gtk::Label ("Default sound path : "));
	alignment9 = Gtk::manage (new Gtk::Alignment (0.5, 0.55, 0, 0));
	snd_browse_button = Gtk::manage (new Gtk::Button ("Browse ..."));
	hbox5 = Gtk::manage (new Gtk::HBox (false, 2));
	vbox1 = Gtk::manage (new Gtk::VBox (false, 0));

	cancel_button->set_flags (Gtk::CAN_FOCUS);
	cancel_button->set_relief (Gtk::RELIEF_NORMAL);

	ok_button->set_flags (Gtk::CAN_FOCUS);
	ok_button->set_relief (Gtk::RELIEF_NORMAL);

	get_action_area ()->property_layout_style ().set_value (Gtk::BUTTONBOX_END);

	author_label->set_alignment (0.5,0.5);
	author_label->set_padding (0,0);
	author_label->set_justify (Gtk::JUSTIFY_LEFT);
	author_label->set_line_wrap (false);
	author_label->set_use_markup (false);
	author_label->set_selectable (false);
	alignment7->add (*author_label);

	desc_label->set_alignment (0.5,0.5);
	desc_label->set_padding (0,0);
	desc_label->set_justify (Gtk::JUSTIFY_LEFT);
	desc_label->set_line_wrap (false);
	desc_label->set_use_markup (false);
	desc_label->set_selectable (false);
	alignment8->add (*desc_label);

	m_author_entry->set_flags (Gtk::CAN_FOCUS);
	m_author_entry->set_visibility (true);
	m_author_entry->set_editable (true);
	m_author_entry->set_max_length (0);
	m_author_entry->set_text (m_deck.get_author ());
	m_author_entry->set_has_frame (true);
	m_author_entry->set_activates_default (false);

	m_desc_entry->set_flags (Gtk::CAN_FOCUS);
	m_desc_entry->set_visibility (true);
	m_desc_entry->set_editable (true);
	m_desc_entry->set_max_length (0);
	m_desc_entry->set_text (m_deck.get_desc ());
	m_desc_entry->set_has_frame (true);
	m_desc_entry->set_activates_default (false);

	table1->set_row_spacings (0);
	table1->set_col_spacings (0);
	table1->attach (*alignment7, 0, 1, 0, 1, 
					Gtk::EXPAND|Gtk::FILL, Gtk::EXPAND|Gtk::FILL, 0, 0);
	table1->attach (*alignment8, 0, 1, 1, 2, 
					Gtk::FILL, Gtk::EXPAND|Gtk::FILL, 0, 0);
	table1->attach (*m_author_entry, 1, 2, 0, 1, 
					Gtk::EXPAND|Gtk::FILL, Gtk::AttachOptions (), 0, 7);
	table1->attach (*m_desc_entry, 1, 2, 1, 2, 
					Gtk::EXPAND|Gtk::FILL, Gtk::AttachOptions (), 0, 7);
	label12->set_alignment (0.5,0.5);
	label12->set_padding (0,0);
	label12->set_justify (Gtk::JUSTIFY_LEFT);
	label12->set_line_wrap (false);
	label12->set_use_markup (false);
	label12->set_selectable (false);
	alignment9->add (*label12);

	m_snd_path_entry->set_flags (Gtk::CAN_FOCUS);
	m_snd_path_entry->set_visibility (true);
	m_snd_path_entry->set_editable (false);
	m_snd_path_entry->set_max_length (0);
	m_snd_path_entry->set_text (m_deck.get_snd_path ());
	m_snd_path_entry->set_has_frame (true);
	m_snd_path_entry->set_activates_default (false);

	snd_browse_button->set_flags (Gtk::CAN_FOCUS);
	snd_browse_button->set_relief (Gtk::RELIEF_NORMAL);

	hbox5->pack_start (*alignment9);
	hbox5->pack_start (*m_snd_path_entry, Gtk::PACK_EXPAND_WIDGET, 6);
	hbox5->pack_start (*snd_browse_button, Gtk::PACK_SHRINK, 2);
	vbox1->pack_start (*table1, Gtk::PACK_SHRINK, 8);
	vbox1->pack_start (*hbox5, Gtk::PACK_SHRINK, 7);

	get_vbox ()->set_homogeneous (false);
	get_vbox ()->set_spacing (0);
	get_vbox ()->pack_start (*vbox1);

	add_action_widget (*cancel_button, -6);
	add_action_widget (*ok_button, -5);

	/** Initialize callbacks 
	 */
	ok_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &DeckInfo::on_ok_clicked));
	snd_browse_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &DeckInfo::on_browse_clicked));

	show_all  ();
}

void
DeckInfo::
on_browse_clicked ()
{
	trace_with_mask("DeckInfo::on_browse_clicked", GUITRACE);

	Gtk::FileChooserDialog f ("Select Sound Dictionary",
							  Gtk::FILE_CHOOSER_ACTION_SELECT_FOLDER);
    f.set_transient_for (*this);
	f.add_button (Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
	f.add_button ("Select",           Gtk::RESPONSE_OK);
	f.set_current_folder (m_snd_path_entry->get_text () + G_DIR_SEPARATOR_S);
	f.set_local_only ();

    if (f.run () == Gtk::RESPONSE_OK) {
        m_snd_path_entry->set_text (
			Glib::filename_from_utf8 (f.get_filename ()));
    }
}

void
DeckInfo::
on_ok_clicked ()
{
	trace_with_mask("DeckInfo::on_ok_clicked", GUITRACE);

	if (m_deck.get_author () != m_author_entry->get_text ()) {
		m_deck.set_author (m_author_entry->get_text ());
		m_deck.mark_as_modified ();
	}
	if (m_deck.get_desc () != m_desc_entry->get_text ()) {
		m_deck.set_desc (m_desc_entry->get_text ());
		m_deck.mark_as_modified ();
	}
	if (m_deck.get_snd_path () != m_snd_path_entry->get_text ()) {
		m_deck.set_snd_path (m_snd_path_entry->get_text ());
		m_deck.mark_as_modified ();
	}
}


