// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule-main.cpp,v 1.8 2005/11/13 02:50:48 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule-main.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003-2005 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   Granule - a flash card program.                                          \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   Granule is a flashcard program that implements Leither cardfile          \n"
"   methodology for learning new words. It features both short-term          \n"
"   and long-term memory training capabilities with scheduling.              \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  granule [OPTIONS]                                                \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
"     --secs-in-day NUM   - Number of seconds in a day (used for debugging)  \n"
"     --secs-in-week NUM  - Number of seconds in a week (used for debugging) \n"
"                                                                            \n"
" -D, --log-file NAME     - Write debug to NAME file                         \n"
" -d, --log-stdout BOOL   - Write debug to standard output                   \n"
" -z, --log-size NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" -c, --log-level NUM     - Log verbosity                                    \n"
" -s, --with-log-server BOOL - Redirect log messages to the log server       \n"
" -S, --log-server NAME   - Define assa-logd server address                  \n"
" -m, --mask MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
"                                                                            \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                             \n"
"                                                                           \n";
//------------------------------------------------------------------------------

#include "Granule-main.h"
#include "Granule.h"
#include "Intern.h"

int
main (int argc, char* argv[])
{
    static const char release[] = "VERSION";
    int patch_level = 0;

	/** 
	 * Initialize the locale as specified in the environment.
	 * (e.g., the user sets LANG=fr_FR in the environment to
	 * get French messages.
	 */
	setlocale (LC_ALL, "");

	/**
	 * Tell Gettext where to find message catalogs for this message.
	 */
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	bind_textdomain_codeset(PACKAGE, "UTF-8");

    GRANULE->set_version (release, patch_level);
    GRANULE->set_author  ("Vladislav Grinchenko");
    GRANULE->set_flags   (ASSA::GenServer::RMLOG);

    GRANULE->init (&argc, argv, help_msg);
 
    GRANULE->init_service ();
    GRANULE->process_events ();

    return GRANULE->get_exit_value ();
}
