// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule-main.cpp,v 1.10 2006/02/19 03:54:31 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule-main.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003-2005 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   Granule - a flash card program.                                          \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   Granule is a flashcard program that implements Leither cardfile          \n"
"   methodology for learning new words. It features both short-term          \n"
"   and long-term memory training capabilities with scheduling.              \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  granule [OPTIONS]                                                \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
"     --secs-in-day=NUM   - Number of seconds in a day (used for debugging)  \n"
"     --secs-in-week=NUM  - Number of seconds in a week (used for debugging) \n"
"                                                                            \n"
" -D, --log-file=NAME     - Write debug to NAME file                         \n"
" -d, --log-stdout=YESNO  - Write debug to standard output                   \n"
" -z, --log-size=NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" -c, --log-level=NUM     - Log verbosity                                    \n"
" -s, --with-log-server=YESNO - Redirect log messages to the log server      \n"
" -S, --log-server=NAME   - Define assa-logd server address                  \n"
" -m, --mask=MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
"                                                                            \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                             \n"
"                                                                            \n"
"     --dump-cardboxes=YESNO                                                 \n"
"                         - Dump content of each cardbox to a file,          \n"
"                           cardbox{1..5}.dat after every card movement.     \n"
"                                                                            \n"
"                                                                           \n";
//------------------------------------------------------------------------------

#include "Granule-main.h"
#include "Granule.h"
#include "Intern.h"

#ifdef IS_HILDON
#    include <libosso.h>
#endif

#include <fstream>
using std::ofstream;


int
main (int argc, char* argv[])
{
#ifdef IS_HILDON_EXTRA

	unlink ("/tmp/granule-env.dump");
	ofstream dump_env ("/tmp/granule-env.dump", std::ios::out);
	
	char* bus_address = getenv ("DBUS_SESSION_BUS_ADDRESS");
	if (bus_address != NULL) {
		dump_env  << "BUS_SESSION_BUS_ADDRESS = \"" 
				  << bus_address << "\"\n";
		std::cout << "BUS_SESSION_BUS_ADDRESS = \"" 
				  << bus_address << "\"" << std::endl;
	}
	else {
		dump_env  << "BUS_SESSION_BUS_ADDRESS = NULL!\n";
		setenv("DBUS_SESSION_BUS_ADDRESS",
			   "unix:path=/tmp/session_bus_socket-vlg", 1);
	}
	dump_env.close ();
#endif


#ifdef IS_HILDON
	/**
	 * Connect Granule to D-BUS session bus and system bus.
	 * If osso doesn't hear from us, it'll kill us right away.
	 */
	osso_context_t* osso_context; 
	osso_context = osso_initialize (PACKAGE, VERSION, TRUE, NULL );	
	if (osso_context == NULL) {
		std::cerr << "Failed to initalize osso context!\n";
		exit (1);
	}
#endif

	/** 
	 * Initialize the locale as specified in the environment.
	 * (e.g., the user sets LANG=fr_FR in the environment to
	 * get French messages.
	 */
	setlocale (LC_ALL, "");

	/**
	 * Tell Gettext where to find message catalogs for this message.
	 */
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	bind_textdomain_codeset(PACKAGE, "UTF-8");

    GRANULE->set_version (VERSION, 0);
    GRANULE->set_author  ("Vladislav Grinchenko");
    GRANULE->set_flags   (ASSA::GenServer::RMLOG);

    GRANULE->init (&argc, argv, help_msg);
    GRANULE->init_service ();
    GRANULE->process_events ();

#ifdef IS_HILDON
	if (osso_context != NULL) {
		osso_deinitialize (osso_context);	 /* disconnect from the session */
	}
#endif

    return GRANULE->get_exit_value ();
}
