// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: DeckInfo.h,v 1.8 2007/01/01 01:00:36 vlg Exp $
//------------------------------------------------------------------------------
//                            DeckInfo.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Mon Feb 16 22:08:26 EST 2004
//
//------------------------------------------------------------------------------
#ifndef DECK_INFO_H
#define DECK_INFO_H

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <gtkmm/dialog.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/box.h>

class Gtk::Entry;
class Deck;
class AppearancePrefs;
class MyTextAlignmentsWidget;

//------------------------------------------------------------------------------
// Class FontEntry (duplicate from AppearancePrefs.h)
//------------------------------------------------------------------------------
//	Compound Font Entry
//
//	+-------+-------+---------------------------+
//	| Label | Entry | Select Font Dialog Button |
//	+-------+-------+---------------------------+
//------------------------------------------------------------------------------
class DIFontEntry : public Gtk::Frame
{
public:
	DIFontEntry ();

	void on_select_clicked ();

	void set_font (const std::string& v_);
	std::string get_font () const;

private:
	Gtk::Table*   m_font_table;

    Gtk::Label*   m_label;
    Gtk::Entry*   m_entry;		// Font entry
    Gtk::Button*  m_button;		// Font Dialog selection button
	Pango::FontDescription m_question_font_desc;
};

inline void
DIFontEntry::
set_font (const std::string& v_)
{
	m_entry->set_text (v_);
}

inline std::string
DIFontEntry::
get_font () const
{
	return (m_entry->get_text ().c_str ());
}

//------------------------------------------------------------------------------
// Class DeckInfo
//------------------------------------------------------------------------------
class DeckInfo : public Gtk::Dialog
{  
public:
	DeckInfo (Gtk::Window& parent_, Deck& deck_);

	void on_ok_clicked ();
	void on_browse_clicked ();
	void on_enable_snd_clicked ();
	void on_enable_app_clicked ();

	bool appearance_changed () const { return m_appearance_changed; }

private:
	void load_appearance ();
	void save_appearance ();

	void set_question_font (const std::string& v_);
	std::string get_question_font () const;

	void set_x_alignment   (SideSelection side_, const std::string& v_);
	void set_y_alignment   (SideSelection side_, const std::string& v_);
	void set_x_padding     (SideSelection side_, const std::string& v_);
	void set_y_padding     (SideSelection side_, const std::string& v_);
	void set_justification (SideSelection side_, const std::string& v_);

	std::string get_x_alignment   (SideSelection side_) const;
	std::string get_y_alignment   (SideSelection side_) const;
	std::string get_x_padding     (SideSelection side_) const;
	std::string get_y_padding     (SideSelection side_) const;
	std::string get_justification (SideSelection side_) const;

private:
	Deck&        m_deck;

	/** Origin
	 */
	Gtk::Entry*  m_author_entry;
	Gtk::Entry*  m_desc_entry;
	Gtk::Entry*  m_snd_path_entry;

	/** Custom sound preferences
	 */
	Gtk::Button*      m_snd_browse_button;
	Gtk::CheckButton* m_enable_alt_snd;

	/** Custom appearance
	 */
	Gtk::CheckButton* m_enable_custom_app;
	Gtk::VBox*        m_inner_app_vbox;

	MyTextAlignmentsWidget* m_front_widget;
	MyTextAlignmentsWidget* m_back_widget;
	MyTextAlignmentsWidget* m_example_widget;

	DIFontEntry* m_question_font;
	bool m_appearance_changed;
};

#endif
