# This file is part of the graph-includes package
#
# (c) 2005 Yann Dirson <ydirson@altern.org>
# Distributed under version 2 of the GNU GPL.

package graphincludes::extractor::C;
use strict;
use warnings;

use base qw(graphincludes::extractor);

use graphincludes::params;
use File::Basename qw(dirname);

sub pattern { '\.([ch](pp|xx|\+\+)?|C|H|cc|hh)$' }

sub getdeps {
  my $self = shift;
  my %deps;

  @ARGV = @{$self->{FILES}};
  while (<>) {
    my $dstfile;
    if (m/^\s*#\s*include\s*"(.*)"/) {
      $dstfile = $self->locatefile ($1, dirname($ARGV), @graphincludes::params::inclpath);
    } elsif (m/^\s*#\s*include\s*<(.*)>/) {
      $dstfile = $self->locatefile ($1, @graphincludes::params::inclpath);
    } else {
      next;
    }

    if (defined $dstfile) {
      $self->record_dep (\%deps, $ARGV, $dstfile);
    } else {
      $self->record_missed_dep ($ARGV, $1);
    }
  }
  return \%deps;
}

1;
