/* data.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

/* appele pour chaques entres de la liste */
gboolean foreachfiles(GtkTreeModel *Amodel, GtkTreePath *Apath, GtkTreeIter *Aiter, gpointer Adata)
{
  gint Ltype, Lparenttype, Lfd;
  Tgrave *Lg = (Tgrave *)Adata;
  gchar *Lonlyname = NULL, *Lnom = NULL, *Lnomutf8 = NULL;
  gchar *Lonlynameparent = NULL;
  gchar Lparents[MAXPATHLEN], Ltmp[MAXPATHLEN];
  GtkTreeIter LparentIter;
  GtkTreePath *Lparentpath;
  gboolean Lreturn = FALSE;

  Lfd = GPOINTER_TO_INT (sc_grave_get_data(Lg, "graftfd"));

  gtk_tree_model_get(Amodel, Aiter, 0, &Ltype, 2, &Lonlyname, 4, &Lnomutf8, 5, &Lnom, -1);

  while(gtk_events_pending()) gtk_main_iteration();
  if (Ltype == TYPE_DIR || Ltype == TYPE_FILE) {

    *Lparents=*Ltmp=0;
    Lparentpath = gtk_tree_path_copy(Apath);
    while (gtk_tree_path_up(Lparentpath)) {
      if (gtk_tree_model_get_iter(Amodel, &LparentIter, Lparentpath)==FALSE) {
        Lreturn = TRUE;
        break;
      }
      /* on recupere le parent, et on utilise son nom que si c'est
       * un repertoire, sinon on arrete de remonter */
      gtk_tree_model_get(Amodel, &LparentIter, 0, &Lparenttype, 2, &Lonlynameparent, -1);
      if (Lparenttype != TYPE_DIR) break;

      g_snprintf(Ltmp, sizeof(Ltmp)-1, "%s/%s", Lonlynameparent, Lparents);
      strcpy(Lparents, Ltmp);
      g_free(Lonlynameparent);
    }
    gtk_tree_path_free(Lparentpath);

    if (!Lreturn) {
      if (Ltype == TYPE_FILE) {
      _DEB("creation graft [%s] car [%s]", *Lparents ? Lparents : "/" , Lnom);       
        g_snprintf (Ltmp, MAXPATHLEN, "%s=%s\n", *Lparents ? Lparents : "/", Lnom);
        write (Lfd, Ltmp, strlen (Ltmp));
      }
    }

  }

  g_free(Lnomutf8);
  g_free(Lnom);
  g_free(Lonlyname);

  return Lreturn;
}

/* preparation pour la gravure, creation du repertorie
 * temporraire et des liens qui vont servir a creer l'image a graver */
gboolean preparedata(Tgrave *Ag, GError **Aerror)
{
  gchar *Ltmpfile = (gchar *)sc_grave_get_data(Ag, "tmpdir");
  GtkLabel *Ltitle = GTK_LABEL(sc_grave_get_data(Ag, "gravetitle"));
  GtkTreeModel *LTreeModel = gtk_tree_view_get_model(GTK_TREE_VIEW(sc_grave_get_data(Ag, "_current_list")));
  gboolean Lstatus = TRUE;
  gint Lfd = -1;
  
  g_assert(LTreeModel);

  g_snprintf(Ltmpfile, MAXPATHLEN-1, "%s/%s", conf_get_string_def("tmpdir", "/tmp"), "gravemanXXXXXX");
  gtk_label_set_text(Ltitle, _("Prepare files..."));

  if ((Lfd = g_mkstemp (Ltmpfile)) < 0) {
    g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s", 
             _("Cannot create file"), Ltmpfile, g_strerror(errno));
    *Ltmpfile = 0;
    Lstatus = FALSE;
  } else {
    _DEB("repertoire temp [%s]\n", Ltmpfile);
    /* conversion de chaques fichiers */
    sc_grave_set_data(Ag, GINT_TO_POINTER (Lfd), "graftfd");
    gtk_tree_model_foreach(LTreeModel, foreachfiles, Ag);
    sc_grave_del_data(Ag, "graftfd");
    close (Lfd);
    
    /* si Aerror n'est plus NULL c'est qu'il y a eu une erreur ! */
    if ((GError *)*Aerror) Lstatus = FALSE;
  }

  return Lstatus;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
