/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPREF_H__
#define __GRDCPREF_H__

/*
 * Grdc Perference Loader
 */

G_BEGIN_DECLS

typedef struct _GrdcPref
{
    /* In GrdcPrefDialog */
    gboolean separated_process;
    gboolean save_view_mode;
    gchar *groups;
    gchar *resolutions;

    /* In View menu */
    gboolean hide_toolbar;
    gboolean hide_statusbar;
    gboolean small_toolbutton;
} GrdcPref;

extern const gchar *default_resolutions;
extern gchar *grdc_pref_file;
extern GrdcPref grdc_pref;

void grdc_pref_init (void);
void grdc_pref_save (void);

G_END_DECLS

#endif  /* __GRDCPREF_H__  */

