/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "grdcstringlist.h"
#include "grdcpref.h"
#include "grdcprefdialog.h"

static gboolean
grdc_pref_resolution_validation_func (const gchar *new_str, gchar **error)
{
    gint i;
    gint width, height;
    gboolean splitted;
    gboolean result;

    width = 0;
    height = 0;
    splitted = FALSE;
    result = TRUE;
    for (i = 0; new_str[i] != '\0'; i++)
    {
        if (new_str[i] == 'x')
        {
            if (splitted)
            {
                result = FALSE;
                break;
            }
            splitted = TRUE;
            continue;
        }
        if (new_str[i] < '0' || new_str[i] > '9')
        {
                result = FALSE;
                break;
        }
        if (splitted)
        {
            height = 1;
        }
        else
        {
            width = 1;
        }
    }

    if (width == 0 || height == 0) result = FALSE;

    if (!result) *error = g_strdup (_("Please enter format 'widthxheight'."));
    return result;
}

gboolean
grdc_pref_dialog_run (GtkWindow *parent, gint default_tab)
{
    GtkWidget *dialog;
    GtkWidget *notebook;
    GtkWidget *tablabel;
    GtkWidget *vbox;
    GtkWidget *widget;
    GtkWidget *separated_process_check;
    GtkWidget *save_view_mode_check;
    GtkWidget *groups_list;
    GtkWidget *resolutions_list;
    gint response;
    gboolean ret;
    gchar *s;

    /* Create the dialog */
    dialog = gtk_dialog_new_with_buttons (_("Preferences"),
        parent, GTK_DIALOG_MODAL,
        GTK_STOCK_OK, GTK_RESPONSE_OK,
        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
        NULL);
    gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);

    /* Create the notebook */
    notebook = gtk_notebook_new ();
    gtk_widget_show (notebook);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), notebook, TRUE, TRUE, 4);
    gtk_container_set_border_width (GTK_CONTAINER (notebook), 4);

    /* Options tab */
    tablabel = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (tablabel);

    widget = gtk_image_new_from_stock (GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU);
    gtk_box_pack_start (GTK_BOX (tablabel), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);

    widget = gtk_label_new (_("Options"));
    gtk_box_pack_start (GTK_BOX (tablabel), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);

    /* Options body */
    vbox = gtk_vbox_new (FALSE, 2);
    gtk_widget_show (vbox);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, tablabel);

    separated_process_check = gtk_check_button_new_with_label (_("Open Connections in Separated Processes"));
    gtk_widget_show (separated_process_check);
    gtk_box_pack_start (GTK_BOX (vbox), separated_process_check, FALSE, FALSE, 4);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (separated_process_check), grdc_pref.separated_process);

    save_view_mode_check = gtk_check_button_new_with_label (_("Remember Last View Mode for Each Connection"));
    gtk_widget_show (save_view_mode_check);
    gtk_box_pack_start (GTK_BOX (vbox), save_view_mode_check, FALSE, FALSE, 4);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (save_view_mode_check), grdc_pref.save_view_mode);

    /* Groups tab */
    tablabel = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (tablabel);

    widget = gtk_image_new_from_stock (GTK_STOCK_INDEX, GTK_ICON_SIZE_MENU);
    gtk_box_pack_start (GTK_BOX (tablabel), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);

    widget = gtk_label_new (_("Groups"));
    gtk_box_pack_start (GTK_BOX (tablabel), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);

    /* Groups body */
    vbox = gtk_vbox_new (FALSE, 2);
    gtk_widget_show (vbox);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, tablabel);

    groups_list = grdc_string_list_new ();
    gtk_widget_show (groups_list);
    gtk_container_set_border_width (GTK_CONTAINER (groups_list), 8);
    gtk_widget_set_size_request (groups_list, 350, -1);
    grdc_string_list_set_new_entry_tooltip_text (GRDC_STRING_LIST (groups_list),
        _("Press Enter key to add new group"));
    gtk_box_pack_start (GTK_BOX (vbox), groups_list, FALSE, FALSE, 0);

    grdc_string_list_set_text (GRDC_STRING_LIST (groups_list), grdc_pref.groups);

    /* Resolutions tab */
    tablabel = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (tablabel);

    widget = gtk_image_new_from_stock (GTK_STOCK_FULLSCREEN, GTK_ICON_SIZE_MENU);
    gtk_box_pack_start (GTK_BOX (tablabel), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);

    widget = gtk_label_new (_("Resolutions"));
    gtk_box_pack_start (GTK_BOX (tablabel), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);

    /* Resolutions body */
    vbox = gtk_vbox_new (FALSE, 2);
    gtk_widget_show (vbox);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, tablabel);

    resolutions_list = grdc_string_list_new ();
    gtk_widget_show (resolutions_list);
    gtk_container_set_border_width (GTK_CONTAINER (resolutions_list), 8);
    gtk_widget_set_size_request (resolutions_list, 350, -1);
    grdc_string_list_set_new_entry_tooltip_text (GRDC_STRING_LIST (resolutions_list),
        _("Press Enter key to add new resolution"));
    grdc_string_list_set_validation_func (GRDC_STRING_LIST (resolutions_list),
        grdc_pref_resolution_validation_func);
    gtk_box_pack_start (GTK_BOX (vbox), resolutions_list, FALSE, FALSE, 0);

    grdc_string_list_set_text (GRDC_STRING_LIST (resolutions_list), grdc_pref.resolutions);

    /* Show the default tab */
    if (default_tab > 0) gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook), default_tab);

    /* Run the dialog */
    response = gtk_dialog_run (GTK_DIALOG (dialog));

    switch (response)
    {
        case GTK_RESPONSE_OK:
            grdc_pref.separated_process = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (separated_process_check));
            grdc_pref.save_view_mode = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (save_view_mode_check));

            g_free (grdc_pref.groups);
            grdc_pref.groups = grdc_string_list_get_text (GRDC_STRING_LIST (groups_list));

            g_free (grdc_pref.resolutions);
            s = grdc_string_list_get_text (GRDC_STRING_LIST (resolutions_list));
            if (s[0] == '\0') s = g_strdup (default_resolutions);
            grdc_pref.resolutions = s;

            grdc_pref_save ();
            ret = TRUE;
            break;

        default:
            ret = FALSE;
            break;
    }

    gtk_widget_destroy (dialog);
    return ret;
}

