/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCCHATWINDOW_H__
#define __GRDCCHATWINDOW_H__

G_BEGIN_DECLS

#define GRDC_TYPE_CHAT_WINDOW               (grdc_chat_window_get_type ())
#define GRDC_CHAT_WINDOW(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_CHAT_WINDOW, GrdcChatWindow))
#define GRDC_CHAT_WINDOW_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_CHAT_WINDOW, GrdcChatWindowClass))
#define GRDC_IS_CHAT_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_CHAT_WINDOW))
#define GRDC_IS_CHAT_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_CHAT_WINDOW))
#define GRDC_CHAT_WINDOW_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_CHAT_WINDOW, GrdcChatWindowClass))

typedef struct _GrdcChatWindow
{
    GtkWindow window;

    GtkWidget *history_text;
    GtkWidget *send_text;
} GrdcChatWindow;

typedef struct _GrdcChatWindowClass
{
    GtkWindowClass parent_class;

    void (* send) (GrdcChatWindow *window);
} GrdcChatWindowClass;

GType grdc_chat_window_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_chat_window_new (GtkWindow *parent, const gchar *chat_with);
void grdc_chat_window_receive (GrdcChatWindow *window, const gchar *name, const gchar *text);

G_END_DECLS

#endif  /* __GRDCCHATWINDOW_H__  */

