/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPLUG_VNC_H__
#define __GRDCPLUG_VNC_H__

#include "config.h"
#include "grdcplug.h"

#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif

G_BEGIN_DECLS

#define GRDC_TYPE_PLUG_VNC              (grdc_plug_vnc_get_type ())
#define GRDC_PLUG_VNC(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_PLUG_VNC, GrdcPlugVnc))
#define GRDC_PLUG_VNC_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_PLUG_VNC, GrdcPlugVncClass))
#define GRDC_IS_PLUG_VNC(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_PLUG_VNC))
#define GRDC_IS_PLUG_VNC_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_PLUG_VNC))
#define GRDC_PLUG_VNC_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_PLUG_VNC, GrdcPlugVncClass))

typedef struct _GrdcPlugVnc
{
    GrdcPlug plug;

    /* Whether the user requests to connect/disconnect */
    gboolean connected;
    /* Whether the vnc process is running */
    gboolean running;
    /* Whether the initialzation calls the authentication process */
    gboolean auth_called;
    /* Whether the close_connection command is called */
    gboolean closed;

    GtkWidget *drawing_area;
    guchar *vnc_buffer;
    GdkPixbuf *rgb_buffer;

    GdkPixbuf *scale_buffer;
    gint scale_width;
    gint scale_height;
    guint scale_handler;

    gint queuedraw_x, queuedraw_y, queuedraw_w, queuedraw_h;
    guint queuedraw_handler;

    gulong clipboard_handler;
    GTimeVal clipboard_timer;

    gpointer client;
    gint listen_sock;

    gint button_mask;

    GPtrArray *pressed_keys;

    GtkWidget *chat_window;

#ifdef HAVE_PTHREAD
    pthread_t thread;
    pthread_mutex_t vnc_mutex;
    pthread_mutex_t buffer_mutex;
#else
    gint thread;
#endif
} GrdcPlugVnc;

typedef struct _GrdcPlugVncClass
{
    GrdcPlugClass parent_class;
} GrdcPlugVncClass;

GType grdc_plug_vnc_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_plug_vnc_new (gboolean scale);

G_END_DECLS

#endif  /* __GRDCPLUG_VNC_H__  */

