/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPREF_H__
#define __GRDCPREF_H__

/*
 * Grdc Perference Loader
 */

G_BEGIN_DECLS

enum
{
    GRDC_VIEW_FILE_LIST,
    GRDC_VIEW_FILE_TREE
};

enum
{
    GRDC_ACTION_CONNECT = 0,
    GRDC_ACTION_EDIT = 1
};

enum
{
    AUTO_MODE = 0,
    SCROLLED_WINDOW_MODE = 1,
    FULLSCREEN_MODE = 2,
    SCROLLED_FULLSCREEN_MODE = 3,
    VIEWPORT_FULLSCREEN_MODE = 4
};

typedef struct _GrdcPref
{
    /* In GrdcPrefDialog */
    gboolean separated_process;
    gboolean save_view_mode;
    gboolean invisible_toolbar;
    gint default_action;
    gint scale_quality;
    gchar *groups;
    gchar *resolutions;
    gint sshtunnel_port;
    gint recent_maximum;
    gint default_mode;

    gboolean applet_quick_ontop;
    gboolean applet_hide_count;

    /* In View menu */
    gboolean hide_toolbar;
    gboolean hide_statusbar;
    gboolean small_toolbutton;
    gint view_file_mode;

    /* Auto */
    gint main_width;
    gint main_height;
    gboolean main_maximize;

    /* Crypto */
    gchar *secret;
} GrdcPref;

#define DEFAULT_SSHTUNNEL_PORT 4732
#define DEFAULT_SSH_PORT 22

extern const gchar *default_resolutions;
extern gchar *grdc_pref_file;
extern GrdcPref grdc_pref;

void grdc_pref_init (void);
void grdc_pref_save (void);

void grdc_pref_add_recent (const gchar *protocol, const gchar *server);
gchar* grdc_pref_get_recent (const gchar *protocol);
void grdc_pref_clear_recent (void);

guint grdc_pref_keymap_keyval (const gchar *keymap, guint keyval);
gchar* grdc_pref_keymap_groups (void);

G_END_DECLS

#endif  /* __GRDCPREF_H__  */

